/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.filesystem.manager.AbstractQingFile;
import com.kingdee.bos.qing.filesystem.manager.AppLocalTempQingFile;
import com.kingdee.bos.qing.filesystem.manager.ClientAndTmpFileRelationManager;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;

public class FileFactory {
    private static Constructor<AbstractQingFile> TEMP_FILE_CONSTRUCTOR = null;
    private static Constructor<AbstractQingFile> PERSISTENT_FILE_CONSTRUCTOR = null;
    private static Constructor<AbstractQingFile> LOCAL_TEMP_FILE_CONSTRUCTOR = null;

    static Constructor<AbstractQingFile> getTempFileConstructor() {
        if (TEMP_FILE_CONSTRUCTOR != null) {
            return TEMP_FILE_CONSTRUCTOR;
        }
        Class<FileFactory> clazz = FileFactory.class;
        synchronized (FileFactory.class) {
            if (TEMP_FILE_CONSTRUCTOR != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return TEMP_FILE_CONSTRUCTOR;
            }
            String specifiedClass = System.getProperty("qing.tempfile.impl");
            if (specifiedClass != null && !"".equals(specifiedClass.trim())) {
                try {
                    Class<?> clazz2 = Class.forName(specifiedClass);
                    if (clazz2 != null) {
                        TEMP_FILE_CONSTRUCTOR = clazz2.getConstructor(QingTempFileType.class);
                        LogUtil.info("Qing Temp File switch to " + clazz2.getName());
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return TEMP_FILE_CONSTRUCTOR;
                    }
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!", e);
                }
            }
            throw new IllegalArgumentException("qing.tempfile.impl should not be null!");
        }
    }

    static Constructor<AbstractQingFile> getPersistentFileConstructor() {
        if (PERSISTENT_FILE_CONSTRUCTOR != null) {
            return PERSISTENT_FILE_CONSTRUCTOR;
        }
        Class<FileFactory> clazz = FileFactory.class;
        synchronized (FileFactory.class) {
            if (PERSISTENT_FILE_CONSTRUCTOR != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return PERSISTENT_FILE_CONSTRUCTOR;
            }
            String specifiedClass = System.getProperty("qing.persistentfile.impl");
            if (specifiedClass != null && !"".equals(specifiedClass.trim())) {
                try {
                    Class<?> clazz2 = Class.forName(specifiedClass);
                    if (clazz2 != null) {
                        PERSISTENT_FILE_CONSTRUCTOR = clazz2.getConstructor(QingPersistentFileType.class);
                        if (LogUtil.isDebugEnabled()) {
                            LogUtil.debug("Qing Persistent File switch to " + clazz2.getName());
                        }
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return PERSISTENT_FILE_CONSTRUCTOR;
                    }
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!", e);
                }
            }
            throw new IllegalArgumentException("qing.persistentfile.impl should not be null!");
        }
    }

    static Constructor<AbstractQingFile> getLocalTempFileConstructor() {
        if (LOCAL_TEMP_FILE_CONSTRUCTOR != null) {
            return LOCAL_TEMP_FILE_CONSTRUCTOR;
        }
        Class<FileFactory> clazz = FileFactory.class;
        synchronized (FileFactory.class) {
            if (LOCAL_TEMP_FILE_CONSTRUCTOR != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOCAL_TEMP_FILE_CONSTRUCTOR;
            }
            try {
                Class<?> clazz2 = Class.forName(AppLocalTempQingFile.class.getName());
                if (clazz2 != null) {
                    LOCAL_TEMP_FILE_CONSTRUCTOR = clazz2.getConstructor(QingAppLocalTempFileType.class);
                    if (LogUtil.isDebugEnabled()) {
                        LogUtil.debug("Qing AppLocalTempQingFile File switch to " + clazz2.getName());
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return LOCAL_TEMP_FILE_CONSTRUCTOR;
                }
                throw new IllegalArgumentException("Class AppLocalTempQingFile cannot be loaded!");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class AppLocalTempQingFile cannot be loaded!", e);
            }
        }
    }

    public static IQingFile newTempFile(QingTempFileType fileType) {
        Constructor<AbstractQingFile> constructor = FileFactory.getTempFileConstructor();
        try {
            return constructor.newInstance(fileType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("qing.tempfile.impl newInstance failed!", e);
        }
    }

    public static IQingFile newPersistentFile(QingContext qingContext, QingFileResourceInfo fileResourceInfo, QingPersistentFileType fileType) {
        IQingFile qingFile = null;
        Constructor<AbstractQingFile> constructor = FileFactory.getPersistentFileConstructor();
        try {
            qingFile = constructor.newInstance(fileType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("qing.persistentfile.impl newInstance failed!", e);
        }
        AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager(qingContext);
        qingFile.setFileResourceService(resourceManager.getFileResourceService());
        if (fileResourceInfo != null) {
            fileResourceInfo.setFileType(fileType);
            qingFile.setFileResourceInfo(fileResourceInfo);
        }
        return qingFile;
    }

    public static IQingFileUpdater newFileUpdater(QingContext qingContext, AbstractQingFileType fileType, String name) {
        IQingFile tempFileUpdate = null;
        if (fileType instanceof QingPersistentFileType) {
            tempFileUpdate = FileFactory.newPersistentFile(qingContext, null, (QingPersistentFileType)fileType);
        } else if (fileType instanceof QingTempFileType) {
            tempFileUpdate = FileFactory.newTempFile((QingTempFileType)fileType);
        }
        if (tempFileUpdate != null) {
            IQingFileUpdater qingFileUpdater = tempFileUpdate.findFile(fileType, name);
            qingFileUpdater.setFileResourceService(tempFileUpdate.getFileResourceService());
            return qingFileUpdater;
        }
        throw new RuntimeException("do something here");
    }

    public static IQingFile newAppLocalTempFile(QingAppLocalTempFileType fileType) {
        Constructor<AbstractQingFile> constructor = FileFactory.getLocalTempFileConstructor();
        try {
            return constructor.newInstance(fileType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("qing.QingAppLocalTempFile.impl newInstance failed!", e);
        }
    }

    public static IQingFileVisitor newFileVisitor(AbstractQingFileType fileType, String name) {
        if (fileType instanceof QingPersistentFileType) {
            return FileFactory.newPersistentFile(null, null, (QingPersistentFileType)fileType).findFile(fileType, name);
        }
        if (fileType instanceof QingTempFileType) {
            IQingFileUpdater visitor = FileFactory.newTempFile((QingTempFileType)fileType).findFile(fileType, name);
            ClientAndTmpFileRelationManager.getInstance().bindOnVisit(visitor);
            return visitor;
        }
        if (fileType instanceof QingAppLocalTempFileType) {
            return FileFactory.newAppLocalTempFile((QingAppLocalTempFileType)fileType).findFile(fileType, name);
        }
        throw new RuntimeException("do something here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContent(AbstractQingFileType fileType, String name) throws IOException {
        byte[] byArray;
        IQingFileVisitor file = FileFactory.newFileVisitor(fileType, name);
        QingInputStream sis = null;
        try {
            sis = file.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtil.copy(sis, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            CloseUtil.close(sis);
            throw throwable;
        }
        CloseUtil.close(sis);
        return byArray;
    }

    public static void copy(IQingFileVisitor dataFile, IQingFile newDataFile, boolean autoDeleteIfFailed) throws IOException {
        dataFile.copyTo(newDataFile, autoDeleteIfFailed);
    }

    public static void clearFile(Collection<IQingFile> fileList) {
        if (fileList != null && !fileList.isEmpty()) {
            for (IQingFile qingFile : fileList) {
                FileFactory.clearFile(qingFile);
            }
        }
    }

    public static void clearFile(IQingFile qingFile) {
        if (qingFile != null) {
            qingFile.delete();
        }
    }

    public static void clearTempFile(QingTempFileType qingTempFileType, String fileName) {
        IQingFile tempFile = FileFactory.newTempFile(qingTempFileType);
        IQingFileUpdater qingFileUpdater = tempFile.findFile(qingTempFileType, fileName);
        if (qingFileUpdater != null) {
            qingFileUpdater.delete();
        }
    }
}

