/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.model;

import java.util.HashSet;
import java.util.Set;

public class OneClientToMultiFileRelation {
    private String clientId;
    private Set<String> qsFileNameSet = new HashSet<String>(5);
    private volatile long lastActiveTime = System.currentTimeMillis();

    public OneClientToMultiFileRelation(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void touch() {
        this.lastActiveTime = System.currentTimeMillis();
    }

    public synchronized boolean addIfNotExist(String tmpFileName) {
        this.touch();
        if (this.qsFileNameSet.contains(tmpFileName)) {
            return false;
        }
        this.qsFileNameSet.add(tmpFileName);
        return true;
    }

    public synchronized String[] getAllRelatedFileNames() {
        return this.qsFileNameSet.toArray(new String[this.qsFileNameSet.size()]);
    }
}

