/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.stream;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.exception.IntegratedIOException;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageLimitException;
import com.kingdee.bos.qing.filesystem.exception.QingFileStorageNoSpaceException;
import com.kingdee.bos.qing.filesystem.manager.api.IFileResourceService;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends OutputStream {
    private static final int blockSizeByte = 0x500000;
    private long _fileSize = 0L;
    private long _checkSizeByte = 0L;
    private IFileResourceService _resourceService;
    private OutputStream _fileOutStream;
    private QingFileResourceInfo _fileResourceInfo;

    public LimitedOutputStream(IFileResourceService resourceService, QingFileResourceInfo fileResourceInfo, OutputStream outputStream) {
        this._fileOutStream = outputStream;
        this._resourceService = resourceService;
        this._fileResourceInfo = fileResourceInfo;
    }

    private void doWrite(int b) throws IOException {
        if (this._fileOutStream != null) {
            try {
                this._fileOutStream.write(b);
            }
            catch (IOException e) {
                this.changeIOException(e);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this._resourceService != null && this._fileResourceInfo != null) {
            ++this._checkSizeByte;
            if (this._fileSize == 0L || this._checkSizeByte >= 0x500000L) {
                this._checkSizeByte = 0L;
                try {
                    if (!this._resourceService.requestFileSize(this._fileSize)) {
                        throw new QingFileStorageLimitException();
                    }
                    this.doWrite(b);
                }
                catch (AbstractQingIntegratedException e) {
                    throw new IntegratedIOException(e);
                }
                catch (ResourceManagementException e) {
                    throw new IOException(e);
                }
            } else {
                this.doWrite(b);
            }
        } else {
            this.doWrite(b);
        }
        ++this._fileSize;
    }

    private void changeIOException(IOException e) throws IOException {
        String message = e.getMessage();
        if ("\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3\u3002".equals(message)) {
            throw new QingFileStorageNoSpaceException();
        }
        if ("No space left on device".equals(message)) {
            throw new QingFileStorageNoSpaceException();
        }
        throw e;
    }

    @Override
    public void flush() throws IOException {
        if (this._fileOutStream != null) {
            try {
                this._fileOutStream.flush();
            }
            catch (IOException e) {
                this.changeIOException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this._fileOutStream != null) {
            try {
                this._fileOutStream.close();
            }
            catch (IOException e) {
                this.changeIOException(e);
            }
            finally {
                this._fileOutStream = null;
            }
        }
    }

    public long getFileSize() {
        return this._fileSize;
    }
}

