/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.stream;

import com.kingdee.bos.qing.common.secret.QingClassLoader;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

public class QingEncryptedStreamUtil {
    private static final ThreadLocal<EncryptedType> encryptedFlag = new ThreadLocal();
    private static final Class[] PARAMTYPES = new Class[]{InputStream.class};
    private static final Class[] PARAMTYPES2 = new Class[]{InputStream.class, Boolean.class};

    public static EncryptedType getEncryptedFlag() {
        return encryptedFlag.get();
    }

    public static void setEncryptedFlag(EncryptedType encryptedType) {
        encryptedFlag.set(encryptedType);
    }

    public static void clearEncryptedFlag() {
        encryptedFlag.remove();
    }

    private QingEncryptedStreamUtil() {
    }

    public static final ZipInputStream createZipInputStream(InputStream in) throws Throwable {
        ClassLoader classLoader = QingEncryptedStreamUtil.class.getClassLoader();
        return (ZipInputStream)QingClassLoader.invokeInStaticMethod(classLoader, "com.kingdee.bos.qing.filesystem.stream.QingEnctryptStreamFactory", "createZipInputStream", PARAMTYPES, new Object[]{in});
    }

    public static final Boolean isZipInputStreamEnctrypt(InputStream in, boolean autoClose) throws Throwable {
        ClassLoader classLoader = QingEncryptedStreamUtil.class.getClassLoader();
        Boolean isZipInputStreamEnctrypt = (Boolean)QingClassLoader.invokeInStaticMethod(classLoader, "com.kingdee.bos.qing.filesystem.stream.QingEnctryptStreamFactory", "isZipInputStreamEnctrypt", PARAMTYPES2, new Object[]{in, autoClose});
        return isZipInputStreamEnctrypt;
    }

    public static enum EncryptedType {
        IMPORT,
        DELETE,
        DFSFILEREPAIR,
        HANDOVER,
        OTHER;

    }
}

