/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.msgbus.manage.MessageManager;
import com.kingdee.bos.qing.msgbus.model.MsgBusDecoder;
import com.kingdee.bos.qing.msgbus.model.msgpack.MsgPackage;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.List;
import java.util.Map;

public class MessageBusService
implements IQingContextable {
    private QingContext qingContext;
    private MessageManager msgManager;

    private MessageManager getMsgManager() {
        if (this.msgManager == null) {
            this.msgManager = new MessageManager();
            this.msgManager.setQingContext(this.qingContext);
        }
        return this.msgManager;
    }

    @Override
    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public byte[] sendMsg(Map<String, String> params) {
        try {
            String jsonMsgPack = params.get("msgPack");
            MsgPackage msgPackage = MsgBusDecoder.decode(jsonMsgPack, MsgPackage.class);
            int stateCode = this.getMsgManager().receiveMsgPack(msgPackage);
            return ResponseUtil.output(new ResponseSuccessWrap(stateCode));
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus receive msg failed", e);
            return ResponseUtil.output(new ResponseSuccessWrap(4000));
        }
    }

    public void sendFilterAction(List<String> nodeIds, String filterType, Object ... params) {
        try {
            this.getMsgManager().receiveFilterAction(nodeIds, filterType, params);
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus receive filter action failed", e);
        }
    }

    public void sendRefreshAction(List<String> nodeIds) {
        try {
            this.getMsgManager().receiveRefreshAction(nodeIds);
        }
        catch (Exception e) {
            LogUtil.error("Qing msg bus receive refresh action failed", e);
        }
    }
}

