/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.Collection;

public class QingIframeNodeHelper {
    private static final String CLIENT_CACHE_KEY_PREFIX = "Qing.Msgbus.Client.";
    private static final String NODE_CACHE_KEY_PREFIX = "Qing.Msgbus.Node.";

    public static void activateNode(String clientId, String nodeId, QingContext qingContext) {
        if (StringUtils.isEmpty(clientId) || StringUtils.isEmpty(nodeId)) {
            return;
        }
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        qingSession.set(QingIframeNodeHelper.getClientCacheKey(clientId), nodeId);
        qingSession.set(QingIframeNodeHelper.getNodeCacheKey(nodeId), clientId);
    }

    public static void inactivateNode(Collection<String> clientIds, QingContext qingContext) {
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        for (String clientId : clientIds) {
            String clientCacheKey = QingIframeNodeHelper.getClientCacheKey(clientId);
            String nodeId = qingSession.get(clientCacheKey);
            if (!StringUtils.isNotBlank(nodeId)) continue;
            qingSession.remove(clientCacheKey);
            String nodeCacheKey = QingIframeNodeHelper.getNodeCacheKey(nodeId);
            String currentNodeClientId = qingSession.get(nodeCacheKey);
            if (!clientId.equals(currentNodeClientId)) continue;
            qingSession.remove(nodeCacheKey);
        }
    }

    public static String getClientId(String nodeId) {
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        return qingSession.get(QingIframeNodeHelper.getNodeCacheKey(nodeId));
    }

    private static String getClientCacheKey(String clientId) {
        return CLIENT_CACHE_KEY_PREFIX + clientId;
    }

    private static String getNodeCacheKey(String nodeId) {
        return NODE_CACHE_KEY_PREFIX + nodeId;
    }
}

