/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.resource.domain.ResourceInfoDomain;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.schedule.dao.IScheduleExecuteDao;
import com.kingdee.bos.qing.schedule.dao.impl.ScheduleExecuteDaoImpl;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.DateUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public class ScheduleExecuteDomain {
    public static final int userFreeScheduleCount = 10;
    public static final int tenantFreeScheduleCount = 0;
    private IScheduleExecuteDao scheduleExecuteDao;
    private ITransactionManagement tx;
    private QingContext qingContext;
    private ResourceInfoDomain resourceInfoDomain;

    private ResourceInfoDomain getResourceInfoDomain() {
        if (this.resourceInfoDomain == null) {
            AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager(this.qingContext);
            this.resourceInfoDomain = new ResourceInfoDomain(resourceManager);
        }
        return this.resourceInfoDomain;
    }

    public ScheduleExecuteDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter idbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.scheduleExecuteDao = new ScheduleExecuteDaoImpl(idbExcuter);
    }

    public int getUserFreeScheduleCount() {
        return 10;
    }

    public int getTenantFreeScheduleCount() {
        return 0;
    }

    public String insert(ScheduleExecutePO scheduleExecutePO) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            String string = this.scheduleExecuteDao.insert(scheduleExecutePO);
            return string;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(Date dateMin, Date dateMax) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            String userId = this.qingContext.getUserId();
            return this.scheduleExecuteDao.findScheduleExecuteListByUserId(userId, dateMin, dateMax);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public ScheduleExecuteVO findScheduleExecuteById(String id) throws AbstractQingIntegratedException, SQLException {
        return this.scheduleExecuteDao.findScheduleExecuteById(id);
    }

    public int findPaySizeByTenantId() throws AbstractQingIntegratedException, ResourceManagementException {
        int licenseStorageSize = 0;
        try {
            licenseStorageSize = this.getResourceInfoDomain().getLicenseStorageSize();
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
        int payScheduleCount = licenseStorageSize * 10;
        return payScheduleCount;
    }

    public int getTenantUseScheduleCountByTenant(Date dateMin, Date dateMax) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            String tenantId = this.qingContext.getTenantId();
            return this.scheduleExecuteDao.getExecuteCountByTenantId(tenantId, 10, dateMin, dateMax);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public int getUserUseScheduleCountByUserId(Date dateMin, Date dateMax) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            String userId = this.qingContext.getUserId();
            return this.scheduleExecuteDao.getExecuteCountByUserId(userId, dateMin, dateMax);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public boolean isEnoughScheduleCount(String userId, String tenantId) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            int payCount;
            if (!this.getResourceInfoDomain().hasResourceManager()) {
                return true;
            }
            int userExecCount = this.scheduleExecuteDao.getExecuteCountByUserId(userId, DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()));
            if (userExecCount < 10) {
                return true;
            }
            int tenantExecCount = this.scheduleExecuteDao.getExecuteCountByTenantId(tenantId, 10, DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()));
            if (tenantExecCount < 0 + (payCount = this.findPaySizeByTenantId())) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
        return false;
    }

    public void updateExecuteState(String id, ExecuteStateEnum executeStateEnum) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.scheduleExecuteDao.updateExecuteState(id, executeStateEnum);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }
}

