/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.model;

import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import org.jdom2.Element;

public class Schedule {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 4;
    public static final int WEDNESDAY = 8;
    public static final int THURSDAY = 16;
    public static final int FRIDAY = 32;
    public static final int SATURDAY = 64;
    public static final int WORKDAY = 62;
    public static final int ALL = 127;
    private Period period;
    private int dayAtMonthly = 0;
    private int weekAtWeekly = 62;
    private int time = 0;
    private String cron;

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public int getDay() {
        return this.dayAtMonthly;
    }

    public void setDay(int day) {
        this.dayAtMonthly = day;
    }

    public boolean isWeek(int week) {
        return (this.weekAtWeekly & week) == week;
    }

    public int getWeek() {
        return this.weekAtWeekly;
    }

    public void setWeek(int week) {
        this.weekAtWeekly = week;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void toXml(Element node) {
        if (this.period != null) {
            node.setAttribute("period", this.period.toPersistance());
        }
        node.setAttribute("dayAtMonthly", Integer.toString(this.dayAtMonthly));
        node.setAttribute("weekAtWeekly", Integer.toString(this.weekAtWeekly));
        node.setAttribute("time", Integer.toString(this.time));
        if (this.cron != null) {
            node.setAttribute("cron", this.cron);
        }
    }

    public void fromXml(Element node) throws ScheduleModelParseException {
        String period = node.getAttributeValue("period");
        this.period = period == null ? null : Period.fromPersistance(period);
        String dam = node.getAttributeValue("dayAtMonthly");
        String waw = node.getAttributeValue("weekAtWeekly");
        String time = node.getAttributeValue("time");
        String cron = node.getAttributeValue("cron");
        try {
            if (dam != null) {
                this.dayAtMonthly = Integer.parseInt(dam);
            }
            if (waw != null) {
                this.weekAtWeekly = Integer.parseInt(waw);
            }
            if (time != null) {
                this.time = Integer.parseInt(time);
            }
            if (cron != null) {
                this.cron = cron;
            }
        }
        catch (NumberFormatException ex) {
            throw new ScheduleModelParseException("ExtractSchedule parse error.", ex);
        }
    }

    public boolean equals(Schedule newOne) {
        if (this.period == null && newOne.getPeriod() == null) {
            return true;
        }
        return this.period != null && newOne.getPeriod() != null && this.period.toPersistance().equals(newOne.getPeriod().toPersistance()) && (this.cron != null && newOne.getCron() != null && this.cron.equals(newOne.getCron()) || this.cron == null && newOne.getCron() == null) && this.time == newOne.getTime() && this.weekAtWeekly == this.getWeek() && this.dayAtMonthly == this.getDay();
    }

    public static enum Period {
        Monthly,
        Weekly,
        Daily,
        Custom;


        public String toPersistance() {
            return this.name();
        }

        public static Period fromPersistance(String name) throws ScheduleModelParseException {
            return Period.valueOf(name);
        }
    }
}

