/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.config;

import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ConfigManager {
    private static ConfigManager instance = new ConfigManager();
    private AbstractConfigSetting _configSetting;

    public static ConfigManager getInstance() {
        return instance;
    }

    private ConfigManager() {
    }

    public void hookConfigSetting(AbstractConfigSetting cs) {
        this._configSetting = cs;
    }

    private AbstractConfigSetting getConfigSetting() {
        if (this._configSetting == null) {
            this._configSetting = new DefaultConfigSetting();
        }
        return this._configSetting;
    }

    public Element getExecutorNode() {
        return this.getSubLevel("Executor");
    }

    public Element getExtractorNode() {
        return this.getSubLevel("EmbeddedScene");
    }

    private Element getSubLevel(String name) {
        Element root = this.getConfigSetting().loadConfig();
        Element sub = null;
        if (root != null) {
            sub = root.getChild(name);
        }
        return sub;
    }

    private static class DefaultConfigSetting
    extends AbstractLocalFileConfigSetting {
        private DefaultConfigSetting() {
        }

        @Override
        protected String getLocalFileDirectory() {
            return System.getProperty("QingAnalysis.TempDir");
        }
    }

    public static abstract class AbstractLocalFileConfigSetting
    extends AbstractConfigSetting {
        private static String LOCAL_FILE_NAME = "qing_analysis_config.xml";

        protected AbstractLocalFileConfigSetting() {
            this.init();
        }

        private void init() {
            Element srcRoot = this.loadRootElementFromDefaultFile();
            Element destRoot = this.loadRootElementFromLocalFile();
            if (destRoot != null) {
                this.upgrade(srcRoot, destRoot);
            }
            this.saveLocalFile(srcRoot);
        }

        private void upgrade(Element srcRoot, Element destRoot) {
            LinkedList<Element> queue = new LinkedList<Element>();
            queue.add(srcRoot);
            while (!queue.isEmpty()) {
                Element peer;
                Element node = (Element)queue.removeFirst();
                for (Element childNode : node.getChildren()) {
                    queue.addLast(childNode);
                }
                if (node == srcRoot || (peer = this.getPeerNode(node, destRoot)) == null || !"true".equalsIgnoreCase(peer.getAttributeValue("lock"))) continue;
                node.setAttribute("value", peer.getAttributeValue("value"));
                node.setAttribute("lock", "true");
            }
        }

        private Element getPeerNode(Element node, Element anotherRoot) {
            String name;
            LinkedList<String> path = new LinkedList<String>();
            for (Element parent = node; parent != null; parent = parent.getParentElement()) {
                path.addFirst(parent.getName());
            }
            Element peerNode = anotherRoot;
            for (int i = 1; i < path.size() && (peerNode = peerNode.getChild(name = (String)path.get(i))) != null; ++i) {
            }
            return peerNode;
        }

        private File getLocalFile() {
            String path = this.getLocalFileDirectory() + File.separator + LOCAL_FILE_NAME;
            File file = new File(path);
            return file;
        }

        private Element loadRootElementFromLocalFile() {
            File file = this.getLocalFile();
            if (file.exists()) {
                try {
                    return XmlUtil.loadRootElementFromFile((File)file);
                }
                catch (IOException e) {
                    LogUtil.error((String)("Load " + LOCAL_FILE_NAME + " error."), (Throwable)e);
                }
                catch (JDOMException e) {
                    LogUtil.error((String)("Load " + LOCAL_FILE_NAME + " error."), (Throwable)e);
                }
            }
            return null;
        }

        private void saveLocalFile(Element rootNode) {
            File file = this.getLocalFile();
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    LogUtil.error((String)("Create" + LOCAL_FILE_NAME + " error."), (Throwable)e);
                    return;
                }
            }
            try {
                XmlUtil.saveFile((Element)rootNode, (File)file);
            }
            catch (IOException e) {
                LogUtil.error((String)("Save" + LOCAL_FILE_NAME + " error."), (Throwable)e);
            }
        }

        /*
         * Loose catch block
         * WARNING - bad return control flow
         */
        private Element loadRootElementFromDefaultFile() {
            Element element;
            InputStream stm = null;
            try {
                stm = ConfigManager.class.getResourceAsStream("DefaultConfig.xml");
                element = XmlUtil.loadRootElement((InputStream)stm);
            }
            catch (JDOMException e) {
                LogUtil.error((String)"Load DefaultConfig.xml error.", (Throwable)e);
                CloseUtil.close((Closeable[])new Closeable[]{stm});
            }
            catch (IOException e2) {
                LogUtil.error((String)"Load DefaultConfig.xml error.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{stm});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{stm});
            }
            CloseUtil.close((Closeable[])new Closeable[]{stm});
            return element;
            return null;
        }

        @Override
        protected final Element loadConfig() {
            return this.loadRootElementFromDefaultFile();
        }

        protected abstract String getLocalFileDirectory();
    }

    public static abstract class AbstractConfigSetting {
        protected abstract Element loadConfig();
    }
}

