/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.longer;

import com.kingdee.bos.qing.core.charttype.longer.AbstractChartTypeCoupler;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.FlatBuilderForTreeMap;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

class TreeMap
extends AbstractChartTypeCoupler {
    TreeMap() {
    }

    @Override
    public ModelAssistantStructure parseAssistantStructure(AnalyticalModel model) {
        ArrayList<AnalyticalField> measureFields = new ArrayList<AnalyticalField>();
        ArrayList<AnalyticalField> rowDimensionFields = new ArrayList<AnalyticalField>();
        ArrayList<AnalyticalField> columnDimensionFields = new ArrayList<AnalyticalField>();
        ArrayList<AnalyticalField> cellDimensionFields = new ArrayList<AnalyticalField>();
        this.parseFields(model.getRow(), rowDimensionFields, null);
        this.parseFields(model.getColumn(), columnDimensionFields, null);
        MarkFieldSet markFieldSet = model.getMarkFieldSet();
        TreeMap.makeSureMarkTypeAppointed(markFieldSet, "size", "measure");
        TreeMap.makeSureMarkTypeSingle(markFieldSet, "color");
        TreeMap.makeSureMarkTypeSingle(markFieldSet, "size");
        this.makeSureMarkTypeAcceptable(markFieldSet, "size", "color", "blank");
        this.makeSureDimensionNoDuplicated(markFieldSet);
        this.parseFields(markFieldSet, cellDimensionFields, measureFields);
        ModelAssistantStructure mas = new ModelAssistantStructure();
        mas.setRowDimensionFields(rowDimensionFields);
        mas.setColumnDimensionFields(columnDimensionFields);
        mas.setCellDimensionFields(cellDimensionFields);
        mas.setMeasureFields(measureFields);
        mas.setMeasureFieldCountForCell(measureFields.size());
        return mas;
    }

    @Override
    public AbstractFlatBuilder createFlatBuilder() {
        return new FlatBuilderForTreeMap();
    }

    private void makeSureMarkTypeAcceptable(MarkFieldSet markFieldSet, String ... acceptTypes) {
        Iterator<AnalyticalField> analyticalFieldIterator = markFieldSet.getFields().iterator();
        Iterator<String> markTypeIterator = markFieldSet.getMarkTypes().iterator();
        while (analyticalFieldIterator.hasNext()) {
            analyticalFieldIterator.next();
            String markType = markTypeIterator.next();
            boolean acceptable = false;
            for (String type : acceptTypes) {
                if (!type.equals(markType)) continue;
                acceptable = true;
                break;
            }
            if (acceptable) continue;
            analyticalFieldIterator.remove();
            markTypeIterator.remove();
        }
    }

    private void makeSureDimensionNoDuplicated(MarkFieldSet markFieldSet) {
        this.moveAnalyticalFieldToTop(markFieldSet, "color", "dimension");
        this.moveAnalyticalFieldToTop(markFieldSet, "color", "measure");
        this.moveAnalyticalFieldToTop(markFieldSet, "size", "measure");
        Iterator<AnalyticalField> analyticalFieldIterator = markFieldSet.getFields().iterator();
        Iterator<String> markTypeIterator = markFieldSet.getMarkTypes().iterator();
        HashSet<MetaField> metaFieldHashSet = new HashSet<MetaField>();
        while (analyticalFieldIterator.hasNext()) {
            boolean acceptable;
            AnalyticalField analyticalField = analyticalFieldIterator.next();
            markTypeIterator.next();
            if (analyticalField.getRole().equals("measure") || (acceptable = metaFieldHashSet.add(analyticalField.getMetaField()))) continue;
            analyticalFieldIterator.remove();
            markTypeIterator.remove();
        }
    }

    private void moveAnalyticalFieldToTop(MarkFieldSet markFieldSet, String markType, String role) {
        int colorIdx = markFieldSet.getMarkTypes().indexOf(markType);
        if (colorIdx < 0) {
            return;
        }
        AnalyticalField colorAnalyticalField = markFieldSet.getFields().get(colorIdx);
        if (colorAnalyticalField.getRole().equals(role)) {
            int firstIndexOfColorField = colorIdx;
            for (int i = 0; i < colorIdx; ++i) {
                AnalyticalField analyticalField = markFieldSet.getFields().get(i);
                boolean isBlank = markFieldSet.getMarkTypes().get(i).equals("blank");
                if (!analyticalField.getRole().equals(role) || !analyticalField.getMetaField().equals(colorAnalyticalField.getMetaField()) || !isBlank) continue;
                firstIndexOfColorField = i;
                break;
            }
            if (colorIdx != firstIndexOfColorField) {
                AnalyticalField noColorField = markFieldSet.getFields().get(firstIndexOfColorField);
                markFieldSet.getMarkTypes().set(firstIndexOfColorField, markType);
                markFieldSet.getFields().set(firstIndexOfColorField, colorAnalyticalField);
                markFieldSet.getFields().set(colorIdx, noColorField);
                markFieldSet.getMarkTypes().set(colorIdx, "blank");
            }
        }
    }
}

