/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SortableCompositeMember;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDataGetter {
    public static AbstractDataGetter create(AnalyticalField field, IExecuteContext ctx) {
        if (field.isParentChildDimension()) {
            PcdCompositeDataGetter getter;
            MetaField pcdIdMf = field.getParentChildDimensionIdField();
            MetaField pcdParentIdMf = field.getParentChildDimensionParentIdField();
            MetaField sortAccordingMf = field.getSortAccordingField();
            AbstractDataGetter idGetter = AbstractDataGetter.createSingle(pcdIdMf, ctx);
            AbstractDataGetter parentIdGetter = AbstractDataGetter.createSingle(pcdParentIdMf, ctx);
            AbstractDataGetter valueGetter = AbstractDataGetter.createSingle(field.getMetaField(), ctx);
            if (field.getMetaField().isOrderCustomized()) {
                OrderCustomizedDataGetter orderCustomizedDataGetter = new OrderCustomizedDataGetter(field.getMetaField());
                getter = new PcdCompositeDataGetter(idGetter, parentIdGetter, valueGetter, orderCustomizedDataGetter);
            } else {
                AbstractDataGetter sortAccordingGetter = sortAccordingMf == null ? null : AbstractDataGetter.createSingle(sortAccordingMf, ctx);
                getter = new PcdCompositeDataGetter(idGetter, parentIdGetter, valueGetter, sortAccordingGetter);
            }
            return getter;
        }
        AbstractDataGetter dataGetter = AbstractDataGetter.createSingle(field.getMetaField(), ctx);
        if (field.isDimension() || field.isProperty()) {
            if (field.getMetaField().isOrderCustomized()) {
                OrderCustomizedDataGetter orderCustomizedDataGetter = new OrderCustomizedDataGetter(field.getMetaField());
                return new CompositeDataGetter(dataGetter, orderCustomizedDataGetter);
            }
            if (field.getSortAccordingField() != null) {
                AbstractDataGetter sortAccordingGetter = AbstractDataGetter.createSingle(field.getSortAccordingField(), ctx);
                return new CompositeDataGetter(dataGetter, sortAccordingGetter);
            }
        }
        return dataGetter;
    }

    private static AbstractDataGetter createSingle(MetaField mf, IExecuteContext ctx) {
        if (mf.isCalculation()) {
            if (MetaField.FormulaAggStatus.isRelativeAggregation(mf.getFormulaAggStatus())) {
                return new DelayedDataGetter();
            }
            return new CalculatingFieldDataGetter(mf, ctx);
        }
        return new PrimitiveFieldDataGetter(mf.getFullName());
    }

    public boolean isFieldExist(Map<String, ?> row) {
        return true;
    }

    public abstract Object getData(Map<String, ?> var1) throws FormulaExecutingException;

    static class PcdCompositeDataGetter
    extends AbstractDataGetter {
        private Map<ParentChildDimensionMember, ParentChildDimensionMember> _cache = new HashMap<ParentChildDimensionMember, ParentChildDimensionMember>();
        private AbstractDataGetter _getterForIdField;
        private AbstractDataGetter _getterForParentIdField;
        private AbstractDataGetter _getterForDisplayField;
        private AbstractDataGetter _getterForSortAccordingField;
        private OrderCustomizedDataGetter _getterForCustomOrder;

        public PcdCompositeDataGetter(AbstractDataGetter idGetter, AbstractDataGetter parentIdGetter, AbstractDataGetter valueGetter, AbstractDataGetter sortAccordingGetter) {
            this._getterForIdField = idGetter;
            this._getterForParentIdField = parentIdGetter;
            this._getterForDisplayField = valueGetter;
            this._getterForSortAccordingField = sortAccordingGetter;
            this._getterForCustomOrder = null;
        }

        public PcdCompositeDataGetter(AbstractDataGetter idGetter, AbstractDataGetter parentIdGetter, AbstractDataGetter valueGetter, OrderCustomizedDataGetter cursomOderGetter) {
            this._getterForIdField = idGetter;
            this._getterForParentIdField = parentIdGetter;
            this._getterForDisplayField = valueGetter;
            this._getterForSortAccordingField = null;
            this._getterForCustomOrder = cursomOderGetter;
        }

        @Override
        public Object getData(Map<String, ?> row) throws FormulaExecutingException {
            Object id = this._getterForIdField.getData(row);
            ParentChildDimensionMember member = new ParentChildDimensionMember(id);
            ParentChildDimensionMember exist = this._cache.get(member);
            if (exist == null) {
                Object display;
                Object parentId = this._getterForParentIdField.getData(row);
                Object sortAccording = display = this._getterForDisplayField.getData(row);
                if (this._getterForCustomOrder != null) {
                    this._getterForCustomOrder.setBaseMember(display);
                    Object order = this._getterForCustomOrder.getData(row);
                    if (order != null) {
                        sortAccording = order;
                    }
                } else if (this._getterForSortAccordingField != null) {
                    sortAccording = this._getterForSortAccordingField.getData(row);
                }
                member.setValue(parentId, display, sortAccording);
                this._cache.put(member, member);
                exist = member;
            }
            return exist;
        }
    }

    static class OrderCustomizedDataGetter
    extends AbstractDataGetter {
        private MetaField _metaField;
        private Object _member;

        public OrderCustomizedDataGetter(MetaField metaField) {
            this._metaField = metaField;
        }

        public void setBaseMember(Object member) {
            this._member = member;
        }

        @Override
        public Object getData(Map<String, ?> row) throws FormulaExecutingException {
            return this._metaField.getCustomOrderIndex(this._member);
        }
    }

    static class CompositeDataGetter
    extends AbstractDataGetter {
        private AbstractDataGetter _getterForField;
        private AbstractDataGetter _getterForSortAccording;
        private OrderCustomizedDataGetter _getterForCustomOrder;

        public CompositeDataGetter(AbstractDataGetter getter, AbstractDataGetter sortAccordingGetter) {
            this._getterForField = getter;
            this._getterForSortAccording = sortAccordingGetter;
        }

        public CompositeDataGetter(AbstractDataGetter getter, OrderCustomizedDataGetter cursomOderGetter) {
            this._getterForField = getter;
            this._getterForCustomOrder = cursomOderGetter;
        }

        @Override
        public Object getData(Map<String, ?> row) throws FormulaExecutingException {
            Object value = this._getterForField.getData(row);
            if (this._getterForCustomOrder != null) {
                this._getterForCustomOrder.setBaseMember(value);
                Object order = this._getterForCustomOrder.getData(row);
                Object sortAccordingValue = order == null ? value : order;
                return new SortableCompositeMember(value, sortAccordingValue);
            }
            if (this._getterForSortAccording.isFieldExist(row)) {
                Object sortAccordingValue = this._getterForSortAccording.getData(row);
                return new SortableCompositeMember(value, sortAccordingValue);
            }
            return value;
        }
    }

    static class DelayedDataGetter
    extends AbstractDataGetter {
        DelayedDataGetter() {
        }

        @Override
        public Object getData(Map<String, ?> row) {
            return null;
        }
    }

    static class CalculatingFieldDataGetter
    extends AbstractDataGetter {
        private static final int MAX_DECIMAL_SCALE = 8;
        private IExpr _expr;
        private IExecuteContext _ctx;

        CalculatingFieldDataGetter(MetaField metaField, IExecuteContext ctx) {
            this._ctx = ctx;
            if (metaField.isValidCalculation()) {
                this._expr = metaField.getExpr();
            }
        }

        @Override
        public Object getData(Map<String, ?> row) throws FormulaExecutingException {
            if (this._expr != null) {
                Object data = null;
                try {
                    data = this._expr.execute(this._ctx);
                }
                catch (ExecuteException ex) {
                    throw new FormulaExecutingException(ex);
                }
                if (data != null) {
                    return CalculatingFieldDataGetter.process(data);
                }
            }
            return null;
        }

        private static Object process(Object data) {
            if (data instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)data;
                if (decimal.scale() > 8) {
                    return decimal.setScale(8, RoundingMode.HALF_UP);
                }
            } else if (!(data instanceof String) && !(data instanceof Calendar)) {
                return data.toString();
            }
            return data;
        }
    }

    static class PrimitiveFieldDataGetter
    extends AbstractDataGetter {
        private String _fieldFullName;
        private Boolean _isFieldExist = null;

        PrimitiveFieldDataGetter(String fieldFullName) {
            this._fieldFullName = fieldFullName;
        }

        @Override
        public Object getData(Map<String, ?> row) {
            return row.get(this._fieldFullName);
        }

        @Override
        public boolean isFieldExist(Map<String, ?> row) {
            if (this._isFieldExist == null) {
                this._isFieldExist = row.containsKey(this._fieldFullName);
            }
            return this._isFieldExist;
        }
    }
}

