/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.AbstractDataGetter;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeCubeFilter;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeDsFilter;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.AggregatedValueRuntimeFilter;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CalculatingFieldAggregationSupporter;
import com.kingdee.bos.qing.core.engine.CalculatingFieldWithTotalSupporter;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.DataSourceTraversal;
import com.kingdee.bos.qing.core.engine.DateProcesser;
import com.kingdee.bos.qing.core.engine.EliminationProcessor;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.engine.MemberRuntimeFilter;
import com.kingdee.bos.qing.core.engine.MetaRecognizer;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SubCuboidCalculater;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.engine.func.Param;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.param.Parameters;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Elimination;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEngine
implements IEngineOutput {
    public static final int RESERVED_MEMORY = 8192;
    private IQingModel _model;
    private List<AbstractDataGetter> _dimensionDataGetters;
    private List<AbstractDataGetter> _measureDataGetters;
    private List<AnalyticalField> _dimensionFields;
    private List<AnalyticalField> _measureFields;
    private List<AnalyticalField> _additionalFields;
    private Cuboid _cuboid;
    private Map<SubCuboidKey, Cuboid> _subCuboids;
    private DataSourceTraversal _dataSourceTraversal;
    private Map<AnalyticalField, IDataProcesser> _dataProcesserMap = new HashMap<AnalyticalField, IDataProcesser>();
    private FormulaExecuteContext _formulaExecuteContext = new FormulaExecuteContext();
    private CalculatingFieldAggregationSupporter _calculatingFieldAggregationSupporter;
    private CalculatingFieldWithTotalSupporter _calculatingFieldWithTotalSupporter;
    private EliminationProcessor _eliminationProcessor;
    private List<AbstractRuntimeDsFilter> _dsFilters;
    private List<AbstractRuntimeFilter.IRuntimePushdownFilter> _pushdownFilters;
    private List<FilterPreparedValueGainer.AbstractPreparedValueGainer> _dsFilterPreparedValueGainers;
    private List<FilterPreparedValueGainer.AbstractPreparedValueGainer> _cubeFilterPreparedValueGainers;
    private List<FilterPreparedValueGainer.AbstractPreparedValueGainer> _relativedFilterPreparedValueGainers;
    private IDataDetailIntercepter _dataDetailIntercepter;
    private II18nContext _i18nContext;
    private ICorrespondent _correspondent;
    private long _estimateHeapSizePerCell;

    public void setI18nContext(II18nContext i18nCtx) {
        this._i18nContext = i18nCtx;
    }

    public void setCorrespondent(ICorrespondent correspondent) {
        this._correspondent = correspondent;
    }

    protected void setAnalyticalModel(IQingModel model) {
        this._model = model;
        AbstractRuntimeFilter.IModelVisitor modelVisitor = this.createModelVisitorForRuntimeFilter();
        this._dsFilters = AbstractRuntimeFilter.createRuntimeDsFilters(modelVisitor);
        this._pushdownFilters = AbstractRuntimeFilter.createRuntimePushdownFilters(modelVisitor);
        this._formulaExecuteContext.setModel(this._model);
        this._formulaExecuteContext.setI18nContext(this._i18nContext);
    }

    private AbstractRuntimeFilter.IModelVisitor createModelVisitorForRuntimeFilter() {
        boolean isIgnoredCubeInterlineCalculation = this._dataDetailIntercepter != null;
        return this.createModelVisitorForRuntimeFilter(isIgnoredCubeInterlineCalculation);
    }

    protected abstract AbstractRuntimeFilter.IModelVisitor createModelVisitorForRuntimeFilter(boolean var1);

    protected abstract List<AnalyticalField> getFilterFields();

    protected abstract ISubtotalDependance createSubtotalDependance();

    public void setDimensionFields(List<AnalyticalField> dimensionFields) {
        this._dimensionFields = dimensionFields;
        this._dimensionDataGetters = new ArrayList<AbstractDataGetter>(dimensionFields.size());
        for (int i = 0; i < dimensionFields.size(); ++i) {
            AnalyticalField field = dimensionFields.get(i);
            this._dimensionDataGetters.add(AbstractDataGetter.create(field, (IExecuteContext)this._formulaExecuteContext));
        }
    }

    public void setMeasureFields(List<AnalyticalField> measureFields) {
        MetaField mf;
        AnalyticalField field;
        int i;
        this._measureFields = measureFields;
        int c = measureFields.size();
        for (i = 0; i < c; ++i) {
            field = measureFields.get(i);
            mf = field.getMetaField();
            if (!CalculatingFieldWithTotalSupporter.isMyTarget(mf)) continue;
            field.setAggregation(Aggregation.AGG);
            if (this._calculatingFieldWithTotalSupporter == null) {
                ISubtotalDependance sd = this.createSubtotalDependance();
                if (sd == null) break;
                this._calculatingFieldWithTotalSupporter = new CalculatingFieldWithTotalSupporter();
                this._calculatingFieldWithTotalSupporter.setContext(this._i18nContext, this._model.getMeta(), this._measureFields, sd);
            }
            this._calculatingFieldWithTotalSupporter.deriveAssistants(field, i);
        }
        c = measureFields.size();
        for (i = 0; i < c; ++i) {
            field = measureFields.get(i);
            mf = field.getMetaField();
            if (!CalculatingFieldAggregationSupporter.isMyTarget(mf)) continue;
            field.setAggregation(Aggregation.AGG);
            if (this._calculatingFieldAggregationSupporter == null) {
                this._calculatingFieldAggregationSupporter = new CalculatingFieldAggregationSupporter();
                this._calculatingFieldAggregationSupporter.setContext(this._i18nContext, this._model.getMeta(), this._measureFields, this._dimensionFields);
            }
            this._calculatingFieldAggregationSupporter.replaceAggregation(field, i);
        }
        this._measureDataGetters = new ArrayList<AbstractDataGetter>(measureFields.size());
        for (i = 0; i < measureFields.size(); ++i) {
            AnalyticalField field2 = measureFields.get(i);
            this._measureDataGetters.add(AbstractDataGetter.create(field2, (IExecuteContext)this._formulaExecuteContext));
        }
    }

    public void addAdditionalFields(Collection<AnalyticalField> fields) {
        if (this._additionalFields == null) {
            this._additionalFields = new ArrayList<AnalyticalField>();
        }
        this._additionalFields.addAll(fields);
    }

    public void setDataSourceTraversal(DataSourceTraversal dataSourceTraversal) {
        this._dataSourceTraversal = dataSourceTraversal;
    }

    public void setFilterPreparedValueGainer(List<FilterPreparedValueGainer.AbstractPreparedValueGainer> filterPreparedValueGainers) {
        this._dsFilterPreparedValueGainers = null;
        this._cubeFilterPreparedValueGainers = null;
        if (filterPreparedValueGainers == null) {
            return;
        }
        for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : filterPreparedValueGainers) {
            if (gainer.isAggregation()) {
                if (this._cubeFilterPreparedValueGainers == null) {
                    this._cubeFilterPreparedValueGainers = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
                }
                this._cubeFilterPreparedValueGainers.add(gainer);
                continue;
            }
            if (this._dsFilterPreparedValueGainers == null) {
                this._dsFilterPreparedValueGainers = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
            }
            this._dsFilterPreparedValueGainers.add(gainer);
        }
    }

    public void setRelativedFilterPreparedValueGainer(List<FilterPreparedValueGainer.AbstractPreparedValueGainer> filterPreparedValueGainers) {
        this._relativedFilterPreparedValueGainers = filterPreparedValueGainers;
    }

    public void setDataDetailIntercepter(IDataDetailIntercepter intercepter) {
        this._dataDetailIntercepter = intercepter;
    }

    public void work() throws AnalysisException {
        this._cuboid = new Cuboid();
        this._cuboid.setDimensionFields(this._dimensionFields);
        this._cuboid.setMeasureFields(this._measureFields);
        this._estimateHeapSizePerCell = this._cuboid.getHeapSizePerCell() + OccupyByte.STRING * this._dimensionFields.size();
        this.traversalData();
        if (this._eliminationProcessor != null) {
            this._eliminationProcessor.release();
        }
        if (this._dataDetailIntercepter != null) {
            return;
        }
        if (this._calculatingFieldAggregationSupporter != null) {
            this._calculatingFieldAggregationSupporter.struggle(this._cuboid);
        }
        this.aggregationCalculating(this._cuboid, false);
        this.checkUserStop();
        this.gainFilterPreparedValue(this._cubeFilterPreparedValueGainers);
        this.checkUserStop();
        this.cubeFilter();
        this.checkUserStop();
        this.gainFilterPreparedValue(this._relativedFilterPreparedValueGainers);
        this.checkUserStop();
        this.subtotal();
        this.checkUserStop();
        this.withTotalCalculating();
        this.checkUserStop();
    }

    private void checkUserStop() throws UserStoppedException {
        if (this._correspondent != null) {
            this._correspondent.checkStoppedByUser();
        }
    }

    protected void traversalData() throws AnalysisException {
        this.traversalData(null);
    }

    protected final void traversalData(List<AbstractRuntimeFilter.IRuntimePushdownFilter> moreFilters) throws AnalysisException {
        MetaRecognizer recognizer = this._dataSourceTraversal.getMetaRecognizer();
        recognizer.classifyFields(this._dimensionFields, false);
        recognizer.classifyFields(this._measureFields, true);
        recognizer.classifyFields(this.getFilterFields(), null);
        recognizer.classifyFields(this._additionalFields, false);
        if (this._model.getMeta().isEliminationsImportant()) {
            recognizer.appointEliminations(this._model.getMeta().getEliminations());
        }
        recognizer.recognizing();
        Set<Elimination> eliminations = recognizer.getEliminations();
        if (eliminations != null && !eliminations.isEmpty()) {
            this._model.getMeta().setEliminations(new ArrayList<Elimination>(eliminations));
            this._eliminationProcessor = new EliminationProcessor();
            this._eliminationProcessor.prepare(this._model.getMeta(), this._dimensionFields, this._measureFields);
        }
        this._dataSourceTraversal.setDataCounter(new DataCounter());
        this._dataSourceTraversal.addPushdownFilters(this._pushdownFilters);
        this._dataSourceTraversal.addPushdownFilters(moreFilters);
        this._dataSourceTraversal.traversal();
    }

    private void aggregationCalculating(Cuboid cuboid, boolean isSubtotal) {
        if (this._calculatingFieldAggregationSupporter == null) {
            return;
        }
        Integer[] targetFieldsIndex = this._calculatingFieldAggregationSupporter.getTargetMeasureFieldsIndex(isSubtotal);
        if (targetFieldsIndex.length == 0) {
            return;
        }
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey key = it.next();
            Aggregator[] aggregators = cuboid.getCellAggregators(key);
            Integer[] integerArray = targetFieldsIndex;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int idx = integerArray[i];
                Object value = null;
                try {
                    value = this._calculatingFieldAggregationSupporter.calculateAfterAggregated(idx, key, cuboid);
                }
                catch (FormulaExecutingException ex) {
                    LogUtil.debug((String)"Execute formula error.", (Throwable)((Object)ex));
                }
                aggregators[idx].append(value);
            }
        }
    }

    private void withTotalCalculating() {
        this.withTotalCalculating(this._cuboid, null);
        for (Map.Entry<SubCuboidKey, Cuboid> item : this._subCuboids.entrySet()) {
            SubCuboidKey key = item.getKey();
            Cuboid subCuboid = item.getValue();
            this.withTotalCalculating(subCuboid, key.getDimTag());
        }
    }

    private void withTotalCalculating(Cuboid currentCuboid, boolean[] currnetCuboidTag) {
        if (this._calculatingFieldWithTotalSupporter == null) {
            return;
        }
        Integer[] targetFieldsIndex = this._calculatingFieldWithTotalSupporter.getTargetMeasureFieldsIndex();
        if (targetFieldsIndex.length == 0) {
            return;
        }
        Iterator<CompositeKey> it = currentCuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey key = it.next();
            Aggregator[] aggregators = currentCuboid.getCellAggregators(key);
            Integer[] integerArray = targetFieldsIndex;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int idx = integerArray[i];
                Object value = null;
                try {
                    value = this._calculatingFieldWithTotalSupporter.calculateAfterSubtotal(idx, key, currentCuboid, currnetCuboidTag, this._cuboid, this._subCuboids);
                }
                catch (FormulaExecutingException ex) {
                    LogUtil.debug((String)"Execute formula error.", (Throwable)((Object)ex));
                }
                aggregators[idx].append(value);
            }
        }
    }

    @Override
    public Cuboid getCuboid() {
        return this._cuboid;
    }

    @Override
    public Collection<SubCuboidKey> getSubCuboidTags() {
        return this._subCuboids.keySet();
    }

    @Override
    public Cuboid getSubCuboid(SubCuboidKey dimensionTag) {
        return this._subCuboids.get(dimensionTag);
    }

    @Override
    public boolean searchPcdAsParent(int dimensionIdx, ParentChildDimensionMember member) {
        return false;
    }

    private void subtotal() throws EnvCeilingException {
        int i;
        this._subCuboids = new HashMap<SubCuboidKey, Cuboid>();
        ISubtotalDependance sd = this.createSubtotalDependance();
        if (sd == null) {
            return;
        }
        boolean[] rowsRequest = this._calculatingFieldWithTotalSupporter == null ? null : this._calculatingFieldWithTotalSupporter.getVerticalCalculatingRequest();
        boolean[] colsRequest = this._calculatingFieldWithTotalSupporter == null ? null : this._calculatingFieldWithTotalSupporter.getHorizontalCalculatingRequest();
        List<AnalyticalField> rowDimensionFields = sd.getRowDimensionFields();
        List<AnalyticalField> columnDimensionFields = sd.getColumnDimensionFields();
        int rowDimCount = rowDimensionFields.size();
        int colDimCount = columnDimensionFields.size();
        List<SubCuboidKey> rowTags = this.makeSubCuboidDimensionTag(rowDimensionFields, sd.isColumnGrandTotal(), rowsRequest);
        List<SubCuboidKey> colTags = this.makeSubCuboidDimensionTag(columnDimensionFields, sd.isRowGrandTotal(), colsRequest);
        int rowTagSize = rowTags.size();
        int colTagSize = colTags.size();
        Cuboid[][] matrix = new Cuboid[rowTagSize + 1][];
        long bytes = 0L;
        int n = i = rowTagSize == 0 ? -1 : 0;
        while (i < rowTagSize) {
            int j;
            int matrixRow = i + 1;
            matrix[matrixRow] = new Cuboid[colTagSize + 1];
            boolean[] rowTag = i == -1 ? new boolean[]{} : rowTags.get(i).getDimTag();
            boolean visibleForRowTag = i == -1 ? true : rowTags.get(i).isVisible();
            int n2 = j = colTagSize == 0 ? -1 : 0;
            while (j < colTagSize) {
                int matrixColumn = j + 1;
                if (i <= 0 && j <= 0) {
                    matrix[matrixRow][matrixColumn] = this._cuboid;
                } else {
                    boolean[] colTag = j == -1 ? new boolean[]{} : colTags.get(j).getDimTag();
                    boolean visibleForColTag = j == -1 ? true : colTags.get(j).isVisible();
                    boolean[] dimTag = new boolean[rowDimCount + colDimCount];
                    System.arraycopy(rowTag, 0, dimTag, 0, rowDimCount);
                    System.arraycopy(colTag, 0, dimTag, rowDimCount, colDimCount);
                    Cuboid parent = j <= 0 ? matrix[matrixRow - 1][matrixColumn] : matrix[matrixRow][matrixColumn - 1];
                    SubCuboidCalculater scc = new SubCuboidCalculater();
                    scc.setDimensionTag(dimTag);
                    scc.setParentCuboid(parent);
                    scc.generateSubCuboid(this._eliminationProcessor);
                    Cuboid sub = scc.getSubCuboid();
                    this.aggregationCalculating(sub, true);
                    matrix[matrixRow][matrixColumn] = sub;
                    boolean visible = visibleForRowTag && visibleForColTag;
                    this._subCuboids.put(new SubCuboidKey(dimTag, visible), sub);
                    bytes += this._estimateHeapSizePerCell * (long)sub.getCellCount();
                }
                ++j;
            }
            ++i;
        }
        if (this._correspondent != null) {
            this._correspondent.applyForMemory(2, bytes);
        }
    }

    private List<SubCuboidKey> makeSubCuboidDimensionTag(List<AnalyticalField> dimFields, boolean hasGrandTotal, boolean[] calculatingRequest) {
        ArrayList<SubCuboidKey> tags = new ArrayList<SubCuboidKey>();
        int fieldCount = dimFields.size();
        if (fieldCount > 0) {
            for (int i = 0; i <= fieldCount; ++i) {
                boolean visible = true;
                if (0 < i && i < fieldCount) {
                    AnalyticalField preField = dimFields.get(fieldCount - 1 - i);
                    visible = preField.isShowSubtotal();
                } else if (i == fieldCount) {
                    visible = hasGrandTotal;
                }
                if (!visible && (calculatingRequest == null || !calculatingRequest[i])) continue;
                boolean[] tag = new boolean[fieldCount];
                for (int j = 0; j < fieldCount; ++j) {
                    tag[j] = fieldCount > i + j;
                }
                tags.add(new SubCuboidKey(tag, visible));
            }
        }
        return tags;
    }

    private void cubeFilter() throws AnalysisException {
        AbstractRuntimeFilter.IModelVisitor modelVisitor = this.createModelVisitorForRuntimeFilter();
        List<AbstractRuntimeCubeFilter> filters = AbstractRuntimeFilter.createRuntimeCubeFilters(modelVisitor, this._cuboid);
        for (int i = 0; i < filters.size(); ++i) {
            AbstractRuntimeCubeFilter filter = filters.get(i);
            if (filter instanceof AggregatedValueRuntimeFilter) {
                AggregatedValueRuntimeFilter aggFilter = (AggregatedValueRuntimeFilter)filter;
                AnalyticalField aggregatedField = null;
                int aggreadedIndex = -1;
                for (int k = 0; k < this._measureFields.size(); ++k) {
                    AnalyticalField aggrField = this._measureFields.get(k);
                    if (!aggFilter.isTargetField(aggrField)) continue;
                    aggregatedField = aggrField;
                    aggreadedIndex = k;
                    break;
                }
                if (aggregatedField == null) {
                    throw new AnalysisException(new RuntimeException("Invalid filter"), -1);
                }
                Iterator<CompositeKey> it = this._cuboid.createDimensionKeyIterator();
                while (it.hasNext()) {
                    CompositeKey key = it.next();
                    Aggregator[] aggrs = this._cuboid.getCellAggregators(key);
                    Aggregator aggregator = aggrs[aggreadedIndex];
                    Object aggregatedValue = aggregator.getValue();
                    if (aggFilter.isAccepted(aggregatedValue)) continue;
                    it.remove();
                }
                continue;
            }
            if (!(filter instanceof MemberRuntimeFilter)) continue;
            MemberRuntimeFilter memberFilter = (MemberRuntimeFilter)filter;
            Iterator<CompositeKey> it = this._cuboid.createDimensionKeyIterator();
            while (it.hasNext()) {
                CompositeKey key = it.next();
                if (memberFilter.isAccepted(key)) continue;
                it.remove();
            }
        }
        if (this._correspondent != null) {
            long estimate = this._estimateHeapSizePerCell * (long)this._cuboid.getCellCount();
            this._correspondent.applyForMemory(1, estimate);
        }
    }

    private void gainFilterPreparedValue(List<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainers) throws EnvCeilingException {
        if (gainers == null || gainers.size() == 0) {
            return;
        }
        ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainerAtDimension = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
        ArrayList<Integer> filterFieldIndexAtDimension = new ArrayList<Integer>();
        ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainerAtMeasure = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
        ArrayList<Integer> filterFieldIndexAtMeasure = new ArrayList<Integer>();
        block0: for (int i = 0; i < gainers.size(); ++i) {
            AnalyticalField field;
            int j;
            FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = gainers.get(i);
            AnalyticalField filterField = gainer.getField();
            boolean isFound = false;
            for (j = 0; j < this._dimensionFields.size(); ++j) {
                field = this._dimensionFields.get(j);
                if (!filterField.isSame(field)) continue;
                gainerAtDimension.add(gainer);
                filterFieldIndexAtDimension.add(j);
                isFound = true;
                break;
            }
            if (isFound) continue;
            for (j = 0; j < this._measureFields.size(); ++j) {
                field = this._measureFields.get(j);
                if (!filterField.isSame(field)) continue;
                gainerAtMeasure.add(gainer);
                filterFieldIndexAtMeasure.add(j);
                isFound = true;
                continue block0;
            }
        }
        if (gainerAtDimension.size() == 0 && gainerAtMeasure.size() == 0) {
            return;
        }
        Iterator<CompositeKey> it = this._cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey key = it.next();
            for (int i = 0; i < gainerAtDimension.size(); ++i) {
                FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = (FilterPreparedValueGainer.AbstractPreparedValueGainer)gainerAtDimension.get(i);
                int index = (Integer)filterFieldIndexAtDimension.get(i);
                gainer.gain(key.getMember(index));
            }
            Aggregator[] aggrs = this._cuboid.getCellAggregators(key);
            for (int i = 0; i < gainerAtMeasure.size(); ++i) {
                FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = (FilterPreparedValueGainer.AbstractPreparedValueGainer)gainerAtMeasure.get(i);
                int index = (Integer)filterFieldIndexAtMeasure.get(i);
                Aggregator aggregator = aggrs[index];
                Object aggregatedValue = aggregator.getValue();
                gainer.gain(aggregatedValue);
            }
        }
        if (this._correspondent != null) {
            int key = gainers == this._cubeFilterPreparedValueGainers ? 4 : (gainers == this._relativedFilterPreparedValueGainers ? 5 : -1);
            long bytes = 0L;
            for (int i = 0; i < gainers.size(); ++i) {
                FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = gainers.get(i);
                bytes += gainer.estimateHeapSize(0);
            }
            this._correspondent.applyForMemory(key, bytes);
        }
    }

    protected static interface ISubtotalDependance {
        public List<AnalyticalField> getRowDimensionFields();

        public List<AnalyticalField> getColumnDimensionFields();

        public boolean isColumnGrandTotal();

        public boolean isRowGrandTotal();
    }

    public static interface IDataDetailIntercepter {
        public boolean isAggregateNeeded();
    }

    static interface IDataProcesser {
        public Calendar process(Object var1);
    }

    static class FormulaExecuteContext
    extends AbstractExecuteContext {
        private IQingModel _model;
        private Map<String, MetaField> _metaFields;
        private Map<String, ?> _row;
        private Map<String, String> _paramValues;

        FormulaExecuteContext() {
        }

        public void setModel(IQingModel model) {
            this._model = model;
        }

        public void bindData(Map<String, ?> row) {
            this._row = row;
        }

        private MetaField searchMetaField(String filedName) {
            if (this._metaFields == null) {
                this._metaFields = this._model.getMeta().createSearchingMap();
            }
            return this._metaFields.get(filedName);
        }

        private String getParamValue(String parameterName) {
            if (this._paramValues == null) {
                this._paramValues = new HashMap<String, String>(this._model.getParameters().getItemCount());
                int c = this._model.getParameters().getItemCount();
                for (int i = 0; i < c; ++i) {
                    Parameters.Parameter param = this._model.getParameters().getItem(i);
                    this._paramValues.put(param.getName(), param.getValue());
                }
            }
            return this._paramValues.get(parameterName);
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            if (expr instanceof RefExpr) {
                MetaField mf;
                String fieldName = ((RefExpr)expr).getName();
                Object value = this._row.get(fieldName);
                if (value == null && (mf = this.searchMetaField(fieldName)) != null && mf.isValidCalculation()) {
                    IExpr refExpr = mf.getExpr();
                    value = refExpr.execute((IExecuteContext)this);
                }
                return value;
            }
            if (expr instanceof Param) {
                IExpr sub = ((Param)expr).getParams()[0];
                String parameterName = (String)sub.execute((IExecuteContext)this);
                return this.getParamValue(parameterName);
            }
            throw new RuntimeException("Unsupported");
        }
    }

    private class DataCounter
    implements DataSourceTraversal.IDataCounter {
        private int MALLOC_CELLS = 100;
        private long _rowCount;

        private DataCounter() {
        }

        @Override
        public void countOneRow(Map<String, ?> row) throws AnalysisException {
            Object value;
            AbstractDataGetter getter;
            AbstractEngine.this._formulaExecuteContext.bindData(row);
            if (AbstractEngine.this._correspondent != null && this._rowCount % (long)this.MALLOC_CELLS == 0L) {
                int cellCount = AbstractEngine.this._cuboid.getCellCount();
                long estimate = AbstractEngine.this._estimateHeapSizePerCell * (long)(cellCount + this.MALLOC_CELLS);
                AbstractEngine.this._correspondent.checkStoppedByUser();
                AbstractEngine.this._correspondent.checkMoreThanMaxCubeCells(cellCount);
                AbstractEngine.this._correspondent.applyForMemory(1, estimate);
                if (AbstractEngine.this._dsFilterPreparedValueGainers != null) {
                    estimate = 0L;
                    for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : AbstractEngine.this._dsFilterPreparedValueGainers) {
                        estimate += gainer.estimateHeapSize(this.MALLOC_CELLS);
                    }
                    AbstractEngine.this._correspondent.applyForMemory(3, estimate);
                }
            }
            ++this._rowCount;
            if (AbstractEngine.this._dsFilterPreparedValueGainers != null) {
                for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : AbstractEngine.this._dsFilterPreparedValueGainers) {
                    getter = gainer.getDataGetter((IExecuteContext)AbstractEngine.this._formulaExecuteContext);
                    value = this.getData(gainer.getField(), getter, row);
                    gainer.gain(value);
                }
            }
            if (!AbstractEngine.this._dsFilters.isEmpty()) {
                for (AbstractRuntimeDsFilter filter : AbstractEngine.this._dsFilters) {
                    getter = filter.getDataGetter((IExecuteContext)AbstractEngine.this._formulaExecuteContext);
                    value = this.getData(filter.getField(), getter, row);
                    if (filter.isAccepted(value)) continue;
                    return;
                }
            }
            CompositeKey key = new CompositeKey();
            for (int i = 0; i < AbstractEngine.this._dimensionDataGetters.size(); ++i) {
                getter = (AbstractDataGetter)AbstractEngine.this._dimensionDataGetters.get(i);
                Object member = this.getData((AnalyticalField)AbstractEngine.this._dimensionFields.get(i), getter, row);
                key.addMember(member);
            }
            if (AbstractEngine.this._dataDetailIntercepter != null && !AbstractEngine.this._dataDetailIntercepter.isAggregateNeeded()) {
                return;
            }
            Aggregator[] aggregators = AbstractEngine.this._cuboid.getCellAggregators(key);
            for (int k = 0; k < AbstractEngine.this._measureDataGetters.size(); ++k) {
                Object measuredValue = null;
                if (aggregators[k] instanceof Aggregator.RowNum) {
                    measuredValue = new Long(this._rowCount);
                } else {
                    if (AbstractEngine.this._eliminationProcessor != null && AbstractEngine.this._eliminationProcessor.isDuplicated(k, key, row)) continue;
                    AbstractDataGetter getter2 = (AbstractDataGetter)AbstractEngine.this._measureDataGetters.get(k);
                    measuredValue = this.getData((AnalyticalField)AbstractEngine.this._measureFields.get(k), getter2, row);
                }
                aggregators[k].append(measuredValue);
            }
        }

        private Object getData(AnalyticalField field, AbstractDataGetter dataGetter, Map<String, ?> row) {
            try {
                Object data = dataGetter.getData(row);
                IDataProcesser dp = this.getDataProcessor(field);
                if (dp != null) {
                    data = dp.process(data);
                }
                return data;
            }
            catch (FormulaExecutingException ex) {
                if (LogUtil.isDebugEnabled()) {
                    LogUtil.debug((String)"Execute formula error.", (Throwable)((Object)ex));
                }
                return null;
            }
        }

        private IDataProcesser getDataProcessor(AnalyticalField field) {
            if (field.getDataType() == DataType.DATE) {
                IDataProcesser processer = (IDataProcesser)AbstractEngine.this._dataProcesserMap.get(field);
                if (processer == null) {
                    processer = new DateProcesser(field);
                    AbstractEngine.this._dataProcesserMap.put(field, processer);
                }
                return processer;
            }
            return null;
        }
    }
}

