/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.func;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.func.AbstractInterlineFunction;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;

class IncreaseRateFunctions {
    IncreaseRateFunctions() {
    }

    public static class SamePeriodLastYear
    extends AbstractIncreaseRateFunction {
        public SamePeriodLastYear() {
            super("SamePeriodLastYear");
        }

        @Override
        protected AbstractInterlineFunction.IDateParser createDateParser(List<AnalyticalField> dimensionFields) {
            return new DateParser(dimensionFields);
        }

        private static class DateParser
        extends AbstractInterlineFunction.AbstractDateParser {
            public DateParser(List<AnalyticalField> dimensionFields) {
                super(dimensionFields);
            }

            @Override
            public CompositeKey createAnotherDimensionKey(CompositeKey thisDimKey) {
                return this.createLastYearKey(thisDimKey);
            }

            private CompositeKey createLastYearKey(CompositeKey thisDimKey) {
                Object last;
                Object member;
                Object[] members = new Object[this._dimIdxs.length];
                boolean isCatched = false;
                if (this._dimIdxs[1] >= 0 && (member = thisDimKey.getMember(this._dimIdxs[1])) instanceof Calendar) {
                    members[1] = this.calendarLastYear((Calendar)member);
                    isCatched = true;
                }
                if (this._continuous[2] && this._dimIdxs[2] >= 0 && (member = thisDimKey.getMember(this._dimIdxs[2])) instanceof Calendar) {
                    members[2] = this.calendarLastYear((Calendar)member);
                    isCatched = true;
                }
                if (this._continuous[3] && this._dimIdxs[3] >= 0 && (member = thisDimKey.getMember(this._dimIdxs[3])) instanceof Calendar) {
                    members[3] = this.calendarLastYear((Calendar)member);
                    isCatched = true;
                }
                if (this._continuous[4] && this._dimIdxs[4] >= 0 && (member = thisDimKey.getMember(this._dimIdxs[4])) instanceof Calendar) {
                    boolean specialDay;
                    Calendar date = (Calendar)member;
                    boolean bl = specialDay = date.get(2) == 1 && date.get(5) == 29;
                    if (!specialDay) {
                        members[4] = this.calendarLastYear(date);
                        isCatched = true;
                    }
                }
                if (this._dimIdxs[0] >= 0 && (last = this.searchCustomLastYear(member = thisDimKey.getMember(this._dimIdxs[0]))) != null) {
                    members[0] = last;
                    isCatched = true;
                }
                if (this._dimIdxs[5] >= 0) {
                    // empty if block
                }
                if (!isCatched) {
                    return null;
                }
                CompositeKey another = new CompositeKey();
                int c = thisDimKey.getMemberCount();
                for (int i = 0; i < c; ++i) {
                    Object member2 = thisDimKey.getMember(i);
                    for (int j = 0; j < this._dimIdxs.length; ++j) {
                        if (i != this._dimIdxs[j] || members[j] == null) continue;
                        member2 = members[j];
                        break;
                    }
                    another.addMember(member2);
                }
                return another;
            }

            private Calendar calendarLastYear(Calendar member) {
                int year = member.get(1);
                Calendar inst = (Calendar)member.clone();
                inst.set(1, --year);
                return inst;
            }
        }
    }

    public static class LastPeriod
    extends AbstractIncreaseRateFunction {
        public LastPeriod() {
            super("LastPeriod");
        }

        @Override
        protected AbstractInterlineFunction.IDateParser createDateParser(List<AnalyticalField> dimensionFields) {
            return new AbstractInterlineFunction.LastPeriodDateParser(dimensionFields);
        }
    }

    static abstract class AbstractIncreaseRateFunction
    extends AbstractInterlineFunction {
        private static final int[] P1 = new int[]{2};
        private static final int[] P2 = new int[]{2, 1};
        private static final String TYPE_RATIO = "ratio";
        private static final String TYPE_VALUE = "value";

        public AbstractIncreaseRateFunction(String name) {
            super(name);
        }

        protected final void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{P1, P2});
        }

        private IExpr getParamExpr() {
            return this.getSubExprs()[0];
        }

        private IExpr getSecondParamExpr() {
            IExpr[] subExprs = this.getSubExprs();
            return subExprs.length == 2 ? subExprs[1] : null;
        }

        private BigDecimal getNullableValue(IExpr expr, IExecuteContext ctx) throws ExecuteException {
            Object value = expr.execute(ctx);
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return null;
        }

        @Override
        public final BigDecimal interlineExecuteImpl(AbstractInterlineFunction.IInterlineEnv interlineEnv, AbstractInterlineFunction.IDateParser dateParser) throws ExecuteException {
            String type;
            IExecuteContext ctx = interlineEnv.createThisLineContext();
            IExpr param2 = this.getSecondParamExpr();
            String string = type = param2 == null ? null : this.getNullableStringValue(param2, ctx);
            if (type == null || type.isEmpty() || TYPE_RATIO.equalsIgnoreCase(type)) {
                BigDecimal me = this.getNullableValue(this.getParamExpr(), interlineEnv.createThisLineContext());
                if (me == null) {
                    return null;
                }
                BigDecimal another = this.searchAnotherLineValue(interlineEnv, dateParser);
                if (another == null || BigDecimal.ZERO.compareTo(another) == 0) {
                    return null;
                }
                BigDecimal diff = me.subtract(another);
                BigDecimal rate = AbstractIncreaseRateFunction.divide((BigDecimal)diff, (BigDecimal)another.abs());
                return rate;
            }
            if (TYPE_VALUE.equalsIgnoreCase(type)) {
                return this.searchAnotherLineValue(interlineEnv, dateParser);
            }
            throw ExecuteException.unexpectedParamValue((IExpr)param2);
        }

        private BigDecimal searchAnotherLineValue(AbstractInterlineFunction.IInterlineEnv interlineEnv, AbstractInterlineFunction.IDateParser dateParser) throws ExecuteException {
            CompositeKey thisDimKey;
            CompositeKey anotherDimKey;
            BigDecimal another = null;
            Cuboid cuboid = interlineEnv.getCuboid();
            Aggregator[] aggrsForAnother = cuboid.getNullableCellAggregators(anotherDimKey = dateParser.createAnotherDimensionKey(thisDimKey = interlineEnv.getThisLineDimension()));
            if (aggrsForAnother != null) {
                interlineEnv.previousLine(anotherDimKey);
                IExecuteContext ctxForAnother = interlineEnv.createThisLineContext();
                another = this.getNullableValue(this.getParamExpr(), ctxForAnother);
            }
            return another;
        }
    }
}

