/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.func;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.NumberExpr;
import com.kingdee.bos.qing.common.grammar.expr.StringExpr;
import com.kingdee.bos.qing.core.engine.func.AbstractWithTotalFunction;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import java.math.BigDecimal;

public class Total
extends AbstractWithTotalFunction {
    private int _horizontalGroupsOutward = 65535;
    private int _verticalGroupsOutward = 65535;
    private Aggregation _totalUsing;
    private boolean _constantParamsParsed = false;

    public Total() {
        super("Total");
    }

    protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
        if (subExprs.length < 1 || subExprs.length > 4) {
            throw Total.exUnmatchedParamCount((IExpr)this);
        }
        int[] checker = new int[]{2, 2, 2, 1};
        for (int i = 0; i < subExprs.length; ++i) {
            IExpr param = subExprs[i];
            if (param.getReturnDataType() != checker[i]) {
                throw Total.exUnmatchedDataType((IExpr)param);
            }
            if (!(i != 1 && i != 2 || param instanceof NumberExpr)) {
                throw Total.exUnmatchedDataType((IExpr)param);
            }
            if (i != 3 || param instanceof StringExpr) continue;
            throw Total.exUnmatchedDataType((IExpr)param);
        }
    }

    public int getReturnDataType() {
        return 2;
    }

    public Object execute(IExecuteContext ctx) throws ExecuteException {
        return ctx.getValue((IExpr)this);
    }

    public IExpr getParamAggregatingTarget() {
        return this.getSubExprs()[0];
    }

    public int getHGroupsOutward() {
        if (!this._constantParamsParsed) {
            this.parseConstantParams();
        }
        return this._horizontalGroupsOutward;
    }

    public int getVGroupsOutward() {
        if (!this._constantParamsParsed) {
            this.parseConstantParams();
        }
        return this._verticalGroupsOutward;
    }

    public Aggregation getTotalUsingAggregation() {
        if (!this._constantParamsParsed) {
            this.parseConstantParams();
        }
        return this._totalUsing;
    }

    private void parseConstantParams() {
        this._horizontalGroupsOutward = this.executeGroupsOutward(1);
        this._verticalGroupsOutward = this.executeGroupsOutward(2);
        this._totalUsing = this.executeTotalUsingAggregation();
        this._constantParamsParsed = true;
    }

    private int executeGroupsOutward(int paramIndex) {
        if (this.getParams().length > paramIndex) {
            BigDecimal value;
            IExpr param = this.getParams()[paramIndex];
            try {
                value = (BigDecimal)param.execute(null);
            }
            catch (ExecuteException e) {
                value = null;
            }
            return value == null ? 0 : value.intValue();
        }
        return 65535;
    }

    public Aggregation executeTotalUsingAggregation() {
        if (this.getParams().length > 3) {
            String agg;
            IExpr param = this.getParams()[3];
            try {
                agg = (String)param.execute(null);
            }
            catch (ExecuteException e) {
                agg = null;
            }
            if (agg != null) {
                try {
                    return Aggregation.valueOf(agg.toUpperCase());
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }
}

