/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.RuntimePushdownFilter;
import com.kingdee.bos.qing.core.exception.NecesaryDimensionMissingException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Helper {
    private Helper() {
    }

    static void mergeDimensions(List<AnalyticalField> dimensionFields, List<AnalyticalField> part) {
        if (part != null) {
            dimensionFields.addAll(part);
        }
    }

    static void mergeMeasures(List<AnalyticalField> measureFields, List<AnalyticalField> fields) {
        for (AnalyticalField field : fields) {
            if (!field.isMeasure()) continue;
            boolean isFound = false;
            for (int i = 0; i < measureFields.size(); ++i) {
                if (!measureFields.get(i).isSame(field)) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            measureFields.add(field);
        }
    }

    static List<AbstractRuntimeFilter.IRuntimePushdownFilter> checkDimensionNecessity(AnalyticalModel model) throws NecesaryDimensionMissingException {
        ArrayList<AbstractRuntimeFilter.IRuntimePushdownFilter> pushdownFilters = new ArrayList<AbstractRuntimeFilter.IRuntimePushdownFilter>();
        Map<String, MetaField> allMetaFields = model.getMeta().createSearchingMap();
        HashSet<MetaField> mfs = new HashSet<MetaField>();
        Helper.collectUsedMetaField(allMetaFields, model.getRow(), mfs);
        Helper.collectUsedMetaField(allMetaFields, model.getColumn(), mfs);
        Helper.collectUsedMetaField(allMetaFields, model.getMarkFieldSet(), mfs);
        Helper.collectUsedMetaField(allMetaFields, model.getFilterFieldSet(), mfs);
        Collection<String> rootRepresentedParentIdFieldNames = model.getMeta().checkNecessaryDimension(mfs);
        if (rootRepresentedParentIdFieldNames != null) {
            for (String name : rootRepresentedParentIdFieldNames) {
                AnalyticalField field = new AnalyticalField();
                field.setName(name);
                field.setRole("dimension");
                field.bindMetaField(MetaField.getNotNullInstance(allMetaFields, name));
                DiscreteFilter filter = new DiscreteFilter();
                filter.setSelecteds(Arrays.asList(new String[]{null}));
                RuntimePushdownFilter runtimeFilter = AbstractRuntimeFilter.createDiscreteRuntimePushdownFilter(field, filter);
                pushdownFilters.add(runtimeFilter);
            }
        }
        return pushdownFilters;
    }

    private static void collectUsedMetaField(Map<String, MetaField> allMetaFields, AbstractFieldSet fieldSet, Set<MetaField> mfs) {
        for (AnalyticalField field : fieldSet.getFields()) {
            Set<String> dependence;
            MetaField mf = field.getMetaField();
            mfs.add(mf);
            if (!mf.isValidCalculation() || (dependence = mf.getAllDependence()) == null) continue;
            for (String fullName : dependence) {
                mfs.add(allMetaFields.get(fullName));
            }
        }
    }

    static void applyAppointedFilterFieldToMeasures(List<AnalyticalField> targetFilterFields, List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        dimensionFields = Collections.unmodifiableList(dimensionFields);
        for (AnalyticalField filterField : targetFilterFields) {
            if (Helper.analyticalFieldListContains(dimensionFields, filterField) || Helper.analyticalFieldListContains(measureFields, filterField)) continue;
            if (filterField.isMeasure()) {
                measureFields.add(filterField);
                continue;
            }
            filterField.setAggregation(Aggregation.PROPERTIES);
            measureFields.add(filterField);
        }
    }

    private static boolean analyticalFieldListContains(List<AnalyticalField> list, AnalyticalField field) {
        for (AnalyticalField measureField : list) {
            if (!measureField.isSame(field)) continue;
            return true;
        }
        return false;
    }
}

