/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.square;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.square.AbstractEngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractEngineRunnerForFilterPreparedValue
extends AbstractEngineRunner {
    private List<AnalyticalField> _fields;
    private List<FilterPreparedValueGainer.AbstractPreparedValueGainer> _gainers;

    public AbstractEngineRunnerForFilterPreparedValue(IDataSourceVisitor dataSourceVisitor, SquareModel model, II18nContext ctx) {
        super(dataSourceVisitor, model, ctx);
        this.setDataEmptyIgnored(true);
    }

    public final void setTargetFilterField(AnalyticalField field) {
        if (field == null) {
            this._fields = null;
        } else {
            this._fields = new ArrayList<AnalyticalField>();
            this._fields.add(field);
        }
    }

    protected final void setTargetFilterFields(List<AnalyticalField> fields) {
        this._fields = fields;
    }

    @Override
    protected final void applyAdditionalMeasure(List<AnalyticalField> measureFields) {
    }

    @Override
    protected final void initFilterPreparedValueGainer(AbstractEngine engine) throws AnalysisException {
        List<AnalyticalField> fields = null;
        fields = this._fields == null ? this.getFilterFields() : this._fields;
        if (fields != null) {
            for (AnalyticalField field : fields) {
                FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = FilterPreparedValueGainer.create(field, this.getContext());
                if (this._gainers == null) {
                    this._gainers = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
                }
                this._gainers.add(gainer);
            }
            engine.addAdditionalFields(fields);
        }
        this.initGainers(engine, this._gainers);
    }

    protected abstract void initGainers(AbstractEngine var1, List<FilterPreparedValueGainer.AbstractPreparedValueGainer> var2) throws AnalysisException;

    public final List<FilterPreparedValueGainer.IPreparedValueFruit> getPreparedValueFruits() {
        ArrayList<FilterPreparedValueGainer.IPreparedValueFruit> result = new ArrayList<FilterPreparedValueGainer.IPreparedValueFruit>();
        if (this._gainers != null) {
            for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : this._gainers) {
                result.add(gainer.getFruit());
            }
        }
        return result;
    }

    protected final void applyAppointedFilterFieldToMeasuresSafely(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        this.applyAppointedFilterFieldToMeasures(Collections.unmodifiableList(dimensionFields), measureFields);
    }

    private void applyAppointedFilterFieldToMeasures(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        if (this._fields == null) {
            return;
        }
        for (AnalyticalField filterField : this._fields) {
            boolean isAggregation;
            if (this.isContainsTheSame(dimensionFields, filterField) || this.isContainsTheSame(measureFields, filterField)) continue;
            if (filterField.isMeasure()) {
                measureFields.add(filterField);
                continue;
            }
            boolean bl = isAggregation = filterField.getAggregation() != null;
            if (isAggregation) continue;
            filterField.setAggregation(Aggregation.PROPERTIES);
            measureFields.add(filterField);
        }
    }

    protected final boolean isContainsTheSame(List<AnalyticalField> list, AnalyticalField field) {
        for (AnalyticalField measureField : list) {
            if (!measureField.isSame(field)) continue;
            return true;
        }
        return false;
    }

    protected final List<AnalyticalField> getFilterFields() {
        ArrayList<AnalyticalField> fields = null;
        List<FilterItem> filterItems = this.getModel().getFilters();
        if (filterItems != null) {
            fields = new ArrayList<AnalyticalField>(filterItems.size());
            for (FilterItem item : filterItems) {
                fields.add(item.getField());
            }
        }
        return fields;
    }
}

