/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.common;

import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SortableCompositeMember;
import com.kingdee.bos.qing.core.model.analysis.common.ExecutableValue;
import com.kingdee.bos.qing.core.model.exhibition.common.NonstringValue;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableValueCoder {
    public static String dimemsionMembersToJsonString(Set<Object> members) {
        ArrayList<Object> list = new ArrayList<Object>(members.size());
        for (Object member : members) {
            Object parsedValue = ExecutableValueCoder.encodeMember(member);
            list.add(parsedValue);
        }
        Map<String, Object> uniform = ExecutableValueCoder.encodeUniform(list);
        return JsonUtil.encodeToString(uniform);
    }

    public static String dimemsionMemberToJsonString(Object member, String defaultValue) {
        Object parsedValue = ExecutableValueCoder.encodeMember(member);
        if (defaultValue != null && defaultValue.equals(parsedValue)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(parsedValue);
        Map<String, Object> uniform = ExecutableValueCoder.encodeUniform(list);
        return JsonUtil.encodeToString(uniform);
    }

    private static Object encodeMember(Object value) {
        if (value instanceof ParentChildDimensionMember) {
            ParentChildDimensionMember pcdm = (ParentChildDimensionMember)value;
            String idValue = pcdm.getIdValue() == null ? null : pcdm.getIdValue().toString();
            return idValue;
        }
        if (value instanceof SortableCompositeMember) {
            SortableCompositeMember scm = (SortableCompositeMember)value;
            value = scm.getValue();
        }
        if (value instanceof String) {
            return value;
        }
        return NonstringValue.create(value);
    }

    private static Map<String, Object> encodeUniform(List<Object> list) {
        HashMap<String, Object> uniform = new HashMap<String, Object>();
        uniform.put("members", list);
        return uniform;
    }

    public static List<ExecutableValue> decodeComplexValue(String encoded) {
        Map uniform;
        Object list;
        ArrayList<ExecutableValue> result = new ArrayList<ExecutableValue>();
        boolean isJsonMatched = false;
        if (encoded != null && encoded.startsWith("{\"members\":") && encoded.endsWith("}") && (list = (uniform = (Map)JsonUtil.decodeFromString((String)encoded, Map.class)).get("members")) instanceof List) {
            isJsonMatched = true;
            List jsons = (List)list;
            for (Object json : jsons) {
                ExecutableValue ev;
                if (json instanceof String) {
                    ev = new ExecutableValue(ExecutableValue.DataType.Str, (String)json);
                } else {
                    Map nonstring = (Map)json;
                    String value = (String)nonstring.get("value");
                    String type = (String)nonstring.get("dataType");
                    ExecutableValue.DataType dataType = ExecutableValue.DataType.valueOf(type);
                    ev = new ExecutableValue(dataType, value);
                }
                result.add(ev);
            }
        }
        if (!isJsonMatched) {
            ExecutableValue ev = encoded == null ? new ExecutableValue(ExecutableValue.DataType.Null, null) : new ExecutableValue(ExecutableValue.DataType.Str, encoded);
            result.add(ev);
        }
        return result;
    }
}

