/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractFlatBuilderForLineSimilar
extends AbstractFlatBuilder {
    private AnalyticalField _categoryField;
    private Map<Object, AbstractNormalChartModel.Category> _categoriesCollection = new HashMap<Object, AbstractNormalChartModel.Category>();
    private Map<Object, Integer> _categoriesIndex = new HashMap<Object, Integer>();
    private Calendar _minCategory;
    private Calendar _maxCategory;
    private MultiSeriesChartModel _commonChart;

    AbstractFlatBuilderForLineSimilar() {
    }

    @Override
    protected final boolean isCellMeasurable() {
        return false;
    }

    @Override
    public final HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        int headerCount = 0;
        if (this.getColorField() != null) {
            headerCount = this.getModelAssistantStructure().getCellDimensionFieldCount() > 1 ? 1 : 0;
        } else {
            int n = headerCount = this.getModelAssistantStructure().getCellDimensionFieldCount() > 0 ? 1 : 0;
        }
        if (headerCount <= 0 && this.getModelAssistantStructure().getRowDimensionFieldCount() > 0) {
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(1, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(headerCount, "continue");
    }

    @Override
    public final HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame = this.getModelAssistantStructure().getRowDimensionFieldCount() == 0;
        int moreLanes = noFrame && this.getDrawingMeasureCount() == 0 ? 0 : 1;
        return new HeaderForMeasure(moreLanes, "number");
    }

    protected final void setCategoryField(AnalyticalField field) {
        this._categoryField = field;
    }

    protected final void makeSureDateContinuous() {
        if (this._categoryField == null || this._categoryField.getDataType() != DataType.DATE || this._minCategory == null) {
            return;
        }
        Calendar value = this._minCategory;
        while (value.compareTo(this._maxCategory) < 0) {
            value = (Calendar)value.clone();
            switch (this._categoryField.getPartValue()) {
                case DATE_YEAR: {
                    value.add(1, 1);
                    break;
                }
                case DATE_QUARTER: 
                case DATE_YQ: {
                    value.add(2, 3);
                    break;
                }
                case DATE_MONTH: 
                case DATE_YM: {
                    value.add(2, 1);
                    break;
                }
                default: {
                    value.add(5, 1);
                }
            }
            this.collectCategory(value);
        }
    }

    protected final void collectCategory(Object categoryValue) {
        if (!this._categoriesCollection.containsKey(categoryValue)) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            if (this._categoryField != null) {
                String label = this.formatValue(categoryValue, this._categoryField);
                category.setOrderingValue(categoryValue);
                category.setLabel(label);
                category.setValue(AbstractFlatBuilderForLineSimilar.encodeCategoryValue(categoryValue, label));
            }
            this._categoriesCollection.put(categoryValue, category);
            if (this._categoryField != null && this._categoryField.getDataType() == DataType.DATE && categoryValue instanceof Calendar) {
                Calendar value = (Calendar)categoryValue;
                this._minCategory = this._minCategory == null || this._minCategory.compareTo(value) > 0 ? value : this._minCategory;
                this._maxCategory = this._maxCategory == null || this._maxCategory.compareTo(value) < 0 ? value : this._maxCategory;
            }
        }
    }

    abstract AnalyticalField getColorField();

    protected final void makeCommonChart() {
        this._commonChart = new MultiSeriesChartModel();
        for (AbstractNormalChartModel.Category category : this._categoriesCollection.values()) {
            this._commonChart.addCategory(category);
        }
        this._commonChart.sortCategories(this.getI18nCtx().getLanManager().getLocale());
        List<AbstractNormalChartModel.Category> categories = this._commonChart.getCategoryList();
        int c = categories.size();
        for (int i = 0; i < c; ++i) {
            AbstractNormalChartModel.Category category = categories.get(i);
            this._categoriesIndex.put(category.getOrderingValue(), i);
        }
        this._commonChart.setCategoryTitle(this._categoryField == null ? null : this._categoryField.getTitle(this.getI18nCtx()));
        AnalyticalField colorField = this.getColorField();
        if (colorField != null) {
            this._commonChart.setSeriesFieldTitle(colorField.getTitle(this.getI18nCtx()));
        }
        this.cutTooLargeChart(this._commonChart);
    }

    protected final void cutTooLargeChart(MultiSeriesChartModel chart) {
        this.cutTooLarge(chart, 1024, 16);
    }

    protected final MultiSeriesChartModel getCommonChart() {
        return this._commonChart;
    }

    protected final int getCategorySize() {
        return this._categoriesCollection.size();
    }

    protected final int getCategoryIndex(Object categoryValue) {
        int categoryIndex = this._categoriesIndex.get(categoryValue);
        return categoryIndex;
    }

    protected final Object getCategoryValue(CompositeKey dimKeyInCell) {
        Object categoryValue = dimKeyInCell == null || dimKeyInCell.getMemberCount() == 0 || this._categoryField == null ? null : dimKeyInCell.getMember(0);
        return categoryValue;
    }
}

