/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.HeatMapCell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class FlatBuilderForHeatMap
extends AbstractFlatBuilder {
    private static final String SecondaryType_Shape = "shape";
    private static final String SecondaryType_Color = "color";
    private Cuboid _currentFlatingCuboid;

    @Override
    public HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        int oneMoreRow = pml == ParallelMeasureLayout.AtColumn ? (this.getDrawingMeasureCount() > 1 ? 1 : 0) : 0;
        return new HeaderForMeasure(oneMoreRow, null);
    }

    @Override
    public HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        int oneMoreRow = pml == ParallelMeasureLayout.AtRow ? (this.getDrawingMeasureCount() > 1 ? 1 : 0) : 0;
        return new HeaderForMeasure(oneMoreRow, null);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForHeatMap();
    }

    private MarkParserForHeatMap getMyMarkParser() {
        return (MarkParserForHeatMap)this.getMarkParser();
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) {
        this._currentFlatingCuboid = cuboid;
        return cuboid.createDimensionKeyIterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        int measureIndexAtTable = 0;
        for (int i = 0; i < whichMeasureToDraw.length; ++i) {
            Aggregator[] aggregators = this._currentFlatingCuboid.getCellAggregators(dimKey);
            Aggregator aggregator = aggregators[i];
            BigDecimal measureValue = aggregator.getNumberValue();
            Scope scope = this.getMeasureScope(i);
            scope.join(measureValue);
            if (!whichMeasureToDraw[i]) continue;
            AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, i);
            this.mapping(dimKey, groupItem, measureIndexAtTable++);
        }
    }

    @Override
    protected List<Object[]> createPlaneTopHeader() {
        return this.createPlaneTopHeaderImpl();
    }

    @Override
    protected int getCellHeapSize() {
        return HeatMapCell.HEAPZISE_OVERHEAD;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        HeatMapCell cell = new HeatMapCell();
        CompositeKey dimKey = item.getDimensionKey();
        int measureIndex = item.getMeasureIndex();
        Aggregator[] aggregators = this.getCuboid(item.getSubCuboidTag()).getCellAggregators(dimKey);
        Aggregator aggregator = aggregators[measureIndex];
        BigDecimal measureValue = aggregator.getNumberValue();
        String secondaryType = this.getMyMarkParser().getSecondaryType();
        if (secondaryType == SecondaryType_Shape) {
            AnalyticalField field = this.getMyMarkParser().getSizeField();
            cell.setSizeRatio(this.makeSizeValue(measureValue, measureIndex, field));
            cell.setSizeText(this.formatNumber(measureValue, field));
        } else if (secondaryType != SecondaryType_Color) {
            throw new RuntimeException("Unknown secondary-type.");
        }
        int colorIndex = this.getMyMarkParser().getColorFieldIndexAtMeasure();
        if (colorIndex >= 0) {
            AnalyticalField field = this.getMyMarkParser().getColorField();
            aggregator = aggregators[colorIndex];
            BigDecimal colorValue = aggregator.getNumberValue();
            cell.setColor(this.makeContinuousColorValue(colorValue, colorIndex, field));
            cell.setColorText(this.formatNumber(colorValue, field));
        } else {
            cell.setColor(this.getDefaultColorValue());
        }
        return cell;
    }

    @Override
    protected void makeRedundance() {
        int colorIndex;
        HeatMapCell cell = null;
        String secondaryType = this.getMyMarkParser().getSecondaryType();
        if (secondaryType == SecondaryType_Shape) {
            cell = new HeatMapCell();
            cell.setSizeRatio("");
            cell.setSizeTitle(this.getMyMarkParser().getSizeField().getTitle(this.getI18nCtx()));
        }
        if ((colorIndex = this.getMyMarkParser().getColorFieldIndexAtMeasure()) >= 0) {
            if (cell == null) {
                cell = new HeatMapCell();
                cell.setSizeRatio("");
            }
            cell.setColorTitle(this.getMyMarkParser().getColorField().getTitle(this.getI18nCtx()));
        }
        this.getTableView().setCommonCell(cell);
    }

    private static class MarkParserForHeatMap
    extends AbstractMarkParser {
        private String _secondaryType;
        private int _colorIndexAtMeasure = -1;
        private int _sizeIndexAtMeasure = -1;
        private AnalyticalField _colorFeild;
        private AnalyticalField _sizeFeild;

        private MarkParserForHeatMap() {
        }

        public int getColorFieldIndexAtMeasure() {
            return this._colorIndexAtMeasure;
        }

        public int getSizeFieldIndexAtMeasure() {
            return this._sizeIndexAtMeasure;
        }

        public AnalyticalField getColorField() {
            return this._colorFeild;
        }

        public AnalyticalField getSizeField() {
            return this._sizeFeild;
        }

        @Override
        public String getSecondaryType() {
            return this._secondaryType;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            if (this.searchMarkAsMeasure("size") >= 0) {
                this._secondaryType = FlatBuilderForHeatMap.SecondaryType_Shape;
            } else if (this.searchMarkAsMeasure(FlatBuilderForHeatMap.SecondaryType_Color) >= 0) {
                this._secondaryType = FlatBuilderForHeatMap.SecondaryType_Color;
            }
            int colorIndexInMark = this.searchMarkAsMeasure(FlatBuilderForHeatMap.SecondaryType_Color);
            if (colorIndexInMark >= 0) {
                this._colorFeild = this.getModel().getFields().get(colorIndexInMark);
                this._colorIndexAtMeasure = MarkParserForHeatMap.getIndexAtMeasure(this._colorFeild, measureFields);
            }
            if (this._secondaryType == FlatBuilderForHeatMap.SecondaryType_Shape) {
                int sizeIndexInMark = this.searchMarkAsMeasure("size");
                this._sizeFeild = this.getModel().getFields().get(sizeIndexInMark);
                int idx = MarkParserForHeatMap.getIndexAtMeasure(this._sizeFeild, measureFields);
                if (idx >= 0) {
                    this._sizeIndexAtMeasure = idx;
                    whichMeasureToDraw[idx] = true;
                }
            } else if (this._secondaryType == FlatBuilderForHeatMap.SecondaryType_Color) {
                whichMeasureToDraw[this._colorIndexAtMeasure] = true;
            }
        }
    }
}

