/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.flattening.common.sort.PieCommonProcessor;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ChartConfig;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.PieCell;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FlatBuilderForPie
extends AbstractFlatBuilder {
    private CuboidSpliter _cuboidSpliter;
    private PieCommonProcessor _processor = new PieCommonProcessor(new ProcessorDependance());
    private boolean _isProcessorInited = false;
    private int _estimatedHeapSizePerCell;

    @Override
    public HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame;
        boolean bl = noFrame = this.getModelAssistantStructure().getColumnDimensionFieldCount() == 0;
        if (noFrame) {
            int moreLanes = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(moreLanes, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(0, null);
    }

    @Override
    public HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame;
        boolean bl = noFrame = this.getModelAssistantStructure().getRowDimensionFieldCount() == 0;
        if (noFrame) {
            int moreLanes = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(moreLanes, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(0, null);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForPie();
    }

    private MarkParserForPie getMyMarkParser() {
        return (MarkParserForPie)this.getMarkParser();
    }

    @Override
    protected void beforeFlatCuboid() {
        AnalyticalField colorField;
        this._cuboidSpliter = this.createCuboidSpliter();
        int sizeFieldIndex = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        if (sizeFieldIndex >= 0) {
            this._cuboidSpliter.openInsideSubtotal(sizeFieldIndex, sizeFieldIndex);
        }
        this._processor.setDateCategory((colorField = this.getMyMarkParser().getColorDimensionField()) != null && colorField.getDataType() == DataType.DATE);
        ChartConfig cc = this.getChartConfig();
        ChartConfig.PieChartConfig pcc = cc == null ? null : cc.getPieChartConfig();
        int topN = pcc == null ? -1 : pcc.getTopN();
        boolean isHideNegative = pcc == null ? false : pcc.isHideNegative();
        this._processor.setNegativeAsAbsolute(!isHideNegative);
        this._processor.setAscendent(false);
        this._processor.setTopN(topN);
        this._processor.setOthersAsAnItem(true);
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws AnalysisException {
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, null);
        this.sortAndTopN(subCuboidTag);
        this._estimatedHeapSizePerCell = PieCell.HEAPZISE_OVERHEAD + SingleSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD + (AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Node.HEAPZISE_OVERHEAD) * this._processor.getCategoryCount();
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        for (int i = 0; i < whichMeasureToDraw.length; ++i) {
            if (whichMeasureToDraw[i]) {
                AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, i);
                this.mapping(dimKey, groupItem, -1);
            }
            if (i != this.getMyMarkParser().getSizeFieldIndexAtMeasure()) continue;
            Cuboid cuboidInCell = this._cuboidSpliter.getStandardizedCube(subCuboidTag).get(dimKey);
            BigDecimal measureValue = this._cuboidSpliter.getInsideSubtotal(cuboidInCell, i);
            Scope scope = this.getMeasureScope(i);
            scope.join(measureValue);
        }
    }

    @Override
    protected void afterFlatCuboid() {
        this._processor.makeUnifiedColor();
        AnalyticalField colorField = this.getMyMarkParser().getColorDimensionField();
        if (colorField != null) {
            this.confirmDiscreteColorLegendTitlebyField(colorField);
        }
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        PieCell cell = new PieCell();
        CompositeKey dimKey = item.getDimensionKey();
        int measureIndex = item.getMeasureIndex();
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        cell.setChart(chart);
        AnalyticalField colorDimField = this.getMyMarkParser().getColorDimensionField();
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKeyInCell = it.next();
            if (this._cuboidSpliter.isSubtotalKey(dimKeyInCell)) continue;
            Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
            Aggregator aggregator = aggregators[measureIndex];
            BigDecimal measureValue = aggregator.getNumberValue();
            AbstractNormalChartModel.Category category = this._processor.getCategory(dimKeyInCell);
            AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
            node.setValue(measureValue == null ? "" : measureValue.toString());
            node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(measureIndex)));
            chart.addData(category, node);
        }
        chart.setCategoryTitle(colorDimField == null ? null : colorDimField.getTitle(this.getI18nCtx()));
        chart.getOnlyOneSeries().setName(cuboidInCell.getMeasureField(measureIndex).getTitle(this.getI18nCtx()));
        chart.getOnlyOneSeries().setFormatString(cuboidInCell.getMeasureField(measureIndex).getUsableNumberFormat());
        int sizeFieldIndex = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        if (sizeFieldIndex >= 0) {
            AnalyticalField sizeField = this.getMyMarkParser().getSizeMeasureField();
            BigDecimal measureValue = this._cuboidSpliter.getInsideSubtotal(cuboidInCell, sizeFieldIndex);
            cell.setSizeRatio(this.makeSizeValue(measureValue, sizeFieldIndex, sizeField));
            cell.setSizeText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(sizeFieldIndex)));
            cell.setSizeTitle(this.getMeasureTitle(sizeFieldIndex));
        }
        this.cutTooLarge(chart, 512, 16);
        return cell;
    }

    @Override
    protected boolean isCellMeasurable() {
        return this.getMyMarkParser().getSizeFieldIndexAtMeasure() >= 0;
    }

    @Override
    protected BigDecimal getCellMeasurableValue(SubCuboidKey tag, CompositeKey dimKeyForRowCol, int measureIndex) {
        Cuboid cuboidInCell;
        Map<CompositeKey, Cuboid> cuboid;
        int sizeFieldIndex = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        if (sizeFieldIndex >= 0 && (cuboid = this._cuboidSpliter.getStandardizedCube(tag)) != null && (cuboidInCell = cuboid.get(dimKeyForRowCol)) != null) {
            return this._cuboidSpliter.getInsideSubtotal(cuboidInCell, sizeFieldIndex);
        }
        return null;
    }

    private void sortAndTopN(SubCuboidKey subCuboidTag) throws AnalysisException {
        int angleMeasureIndex = this.getMyMarkParser().getAngleFieldIndexAtMeasure();
        if (angleMeasureIndex < 0) {
            return;
        }
        Map<CompositeKey, Cuboid> stanardizedCube = this._cuboidSpliter.getStandardizedCube(subCuboidTag);
        Set<Map.Entry<CompositeKey, Cuboid>> entrySet = stanardizedCube.entrySet();
        if (!this._isProcessorInited) {
            this._isProcessorInited = true;
            this._processor.setMultiPie(entrySet.size() > 1);
            this._processor.setAngleMeasureIndex(angleMeasureIndex);
        }
        for (Map.Entry<CompositeKey, Cuboid> stanardizedCubeEntry : entrySet) {
            Cuboid cuboidInCell = stanardizedCubeEntry.getValue();
            AbstractSortProcessor.CuboidShell insteadCuboid = PieCommonProcessor.copyCuboidShellFrom(cuboidInCell);
            stanardizedCube.put(stanardizedCubeEntry.getKey(), insteadCuboid);
            this._processor.sortAndTopN(cuboidInCell, insteadCuboid);
        }
    }

    private static class MarkParserForPie
    extends AbstractMarkParser {
        private AnalyticalField _colorField;
        private AnalyticalField _sizeField;
        private int _sizeAttrIndexAtMeasure = -1;
        private int _angleAttrIndexAtMeasure = -1;

        private MarkParserForPie() {
        }

        public int getAngleFieldIndexAtMeasure() {
            return this._angleAttrIndexAtMeasure;
        }

        public int getSizeFieldIndexAtMeasure() {
            return this._sizeAttrIndexAtMeasure;
        }

        public AnalyticalField getColorDimensionField() {
            return this._colorField;
        }

        public AnalyticalField getSizeMeasureField() {
            return this._sizeField;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            List<AnalyticalField> markFields = this.getModel().getFields();
            int idx = this.searchMarkAsDimension("color");
            if (idx >= 0) {
                this._colorField = markFields.get(idx);
            }
            if ((idx = this.searchMarkAsMeasure("angle")) >= 0) {
                AnalyticalField field = markFields.get(idx);
                int idxAtMeasure = MarkParserForPie.getIndexAtMeasure(field, measureFields);
                if (idxAtMeasure >= 0) {
                    whichMeasureToDraw[idxAtMeasure] = true;
                }
                this._angleAttrIndexAtMeasure = idxAtMeasure;
            }
            if ((idx = this.searchMarkAsMeasure("size")) >= 0) {
                this._sizeField = markFields.get(idx);
                this._sizeAttrIndexAtMeasure = MarkParserForPie.getIndexAtMeasure(this._sizeField, measureFields);
            }
        }
    }

    private class ProcessorDependance
    implements PieCommonProcessor.IDependance {
        private ProcessorDependance() {
        }

        @Override
        public Locale getI18nContext() {
            return FlatBuilderForPie.this.getI18nCtx().getLanManager().getLocale();
        }

        @Override
        public boolean isSubtotal(CompositeKey dimKey) {
            return FlatBuilderForPie.this._cuboidSpliter.isSubtotalKey(dimKey);
        }

        @Override
        public String makeDiscreteColor(AbstractChartModel.IOrderingSupported object, String text) {
            return FlatBuilderForPie.this.makeDiscreteColorValue(object, text);
        }

        @Override
        public AbstractNormalChartModel.Category createCategory(Object categoryValue) {
            String value;
            String label;
            if (categoryValue instanceof AbstractSortProcessor.OthersMember) {
                label = Messages.getLangMessage(FlatBuilderForPie.this.getI18nCtx(), "others", "\u5176\u5b83");
                Set<Object> members = ((AbstractSortProcessor.OthersMember)categoryValue).getAllRealMembers();
                value = AbstractFlatBuilder.encodeCategoryValue(members);
            } else {
                label = this.parseCategoryLabel(categoryValue);
                value = AbstractFlatBuilder.encodeCategoryValue(categoryValue, label);
            }
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setLabel(label);
            category.setValue(value);
            return category;
        }

        private String parseCategoryLabel(Object categoryValue) {
            ParentChildDimensionMember pcdm;
            String label = categoryValue instanceof ParentChildDimensionMember ? ((pcdm = (ParentChildDimensionMember)categoryValue).getDisplayValue() == null ? "" : pcdm.getDisplayValue().toString()) : this.formatCategoryLabel(categoryValue);
            return label;
        }

        private String formatCategoryLabel(Object categoryValue) {
            AnalyticalField colorField = FlatBuilderForPie.this.getMyMarkParser().getColorDimensionField();
            if (colorField == null) {
                return categoryValue == null ? "" : categoryValue.toString();
            }
            return FlatBuilderForPie.this.formatValue(categoryValue, colorField);
        }
    }
}

