/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.common.TreeChartHandler;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ChartConfig;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.TreeChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.RectTreeCell;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatBuilderForRectTree
extends AbstractFlatBuilder {
    private CuboidSpliter _cuboidSpliter;
    private TreeChartHandler _treeChartHandler;
    private BigDecimal _maxSize;
    private Set<Object> _colorValuesCollection;
    private int _estimatedHeapSizePerCell;

    @Override
    protected HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame;
        boolean bl = noFrame = this.getModelAssistantStructure().getColumnDimensionFieldCount() == 0;
        if (noFrame) {
            int moreLanes = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(moreLanes, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(0, null);
    }

    @Override
    protected HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame;
        boolean bl = noFrame = this.getModelAssistantStructure().getRowDimensionFieldCount() == 0;
        if (noFrame) {
            int moreLanes = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(moreLanes, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(0, null);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForRectTree();
    }

    private MarkParserForRectTree getMyMarkParser() {
        return (MarkParserForRectTree)this.getMarkParser();
    }

    @Override
    protected void beforeFlatCuboid() {
        this._cuboidSpliter = this.createCuboidSpliter();
        int sizeIndex = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        if (sizeIndex >= 0) {
            this._cuboidSpliter.openInsideSubtotal(sizeIndex, sizeIndex);
        }
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws AnalysisException {
        final boolean isHideNegative = this.isHideNegative();
        AnalyticalField discreteColorField = this.getMyMarkParser().getDiscreteColorField();
        final int colorIdxAtDimension = discreteColorField == null ? -1 : this.getModelAssistantStructure().getCellDimensionFields().indexOf(discreteColorField);
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, new CuboidSpliter.AbstractDoMoreHandler(){

            @Override
            public Object measureToSubtotal(Object value) {
                BigDecimal v;
                if (value instanceof BigDecimal && (v = (BigDecimal)value).signum() < 0) {
                    return isHideNegative ? null : v.abs();
                }
                return value;
            }

            @Override
            public void forDimension(CompositeKey dimKeyInCell) {
                if (colorIdxAtDimension >= 0) {
                    Object colorValue = dimKeyInCell.getMember(colorIdxAtDimension);
                    if (FlatBuilderForRectTree.this._colorValuesCollection == null) {
                        FlatBuilderForRectTree.this._colorValuesCollection = new HashSet();
                    }
                    FlatBuilderForRectTree.this._colorValuesCollection.add(colorValue);
                }
            }

            @Override
            public void forMeasure(int measureIndex, Aggregator aggregator) {
                if (FlatBuilderForRectTree.this.getMyMarkParser().getContinuousColorField() != null && measureIndex == FlatBuilderForRectTree.this.getMyMarkParser().getContinuousColorIdxAtMeasure()) {
                    BigDecimal colorValue = aggregator.getNumberValue();
                    Scope scope = FlatBuilderForRectTree.this.getMeasureScope(measureIndex);
                    scope.join(colorValue);
                }
            }
        });
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void afterFlatCuboid() {
        AnalyticalField discreteColorField = this.getMyMarkParser().getDiscreteColorField();
        if (discreteColorField != null && this._colorValuesCollection != null) {
            List<AbstractChartModel.IOrderingSupported> sortedList = AbstractChartModel.toOrderedWrapList(this._colorValuesCollection, this.getI18nCtx().getLanManager().getLocale());
            for (AbstractChartModel.IOrderingSupported colorValue : sortedList) {
                String display = this.formatValue(colorValue.getOrderingValue(), discreteColorField);
                this.makeDiscreteColorValue(colorValue, display);
            }
            this.confirmDiscreteColorLegendTitlebyField(discreteColorField);
        }
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        for (int i = 0; i < whichMeasureToDraw.length; ++i) {
            if (!whichMeasureToDraw[i]) continue;
            AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, i);
            this.mapping(dimKey, groupItem, -1);
            Cuboid cuboidInCell = this._cuboidSpliter.getStandardizedCube(subCuboidTag).get(dimKey);
            BigDecimal measureValue = this._cuboidSpliter.getInsideSubtotal(cuboidInCell, i);
            if (measureValue != null) {
                this._maxSize = this._maxSize == null ? measureValue : this._maxSize.max(measureValue);
            }
            int heapSizeCurrentCell = RectTreeCell.HEAPZISE_OVERHEAD + TreeChartModel.HEAPZISE_OVERHEAD + TreeChartModel.TreeChartNode.HEAPZISE_OVERHEAD * cuboidInCell.getCellCount();
            this._estimatedHeapSizePerCell = Math.max(this._estimatedHeapSizePerCell, heapSizeCurrentCell);
        }
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        int sizeIdx;
        BigDecimal size;
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        CompositeKey dimKey = item.getDimensionKey();
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        if (this._treeChartHandler == null) {
            this._treeChartHandler = this.createTreeHandler();
        }
        this._treeChartHandler.setCuboid(cuboidInCell);
        TreeChartModel chart = this._treeChartHandler.makeChartModel();
        BigDecimal sizeRatio = this._maxSize == null || this._maxSize.signum() == 0 ? BigDecimal.ONE : ((size = this._cuboidSpliter.getInsideSubtotal(cuboidInCell, sizeIdx = this.getMyMarkParser().getSizeFieldIndexAtMeasure())) == null ? BigDecimal.ZERO : size.divide(this._maxSize, 4, 4));
        RectTreeCell cell = new RectTreeCell();
        cell.setChart(chart);
        cell.setSizeRatio(sizeRatio.toString());
        return cell;
    }

    @Override
    protected BigDecimal getCellMeasurableValue(SubCuboidKey tag, CompositeKey dimKeyForRowCol, int measureIndex) {
        Cuboid cuboidInCell;
        Map<CompositeKey, Cuboid> cuboid;
        int sizeFieldIndex = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        if (sizeFieldIndex >= 0 && (cuboid = this._cuboidSpliter.getStandardizedCube(tag)) != null && (cuboidInCell = cuboid.get(dimKeyForRowCol)) != null) {
            return this._cuboidSpliter.getInsideSubtotal(cuboidInCell, sizeFieldIndex);
        }
        return null;
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    private TreeChartHandler createTreeHandler() {
        TreeChartHandler treeChartHandler = new TreeChartHandler();
        treeChartHandler.setI18nContext(this.getI18nCtx());
        treeChartHandler.setChartProperty(this.isHideNegative(), null);
        treeChartHandler.setHandlerRelative(new TreeChartHandler.AbstractRelative(){

            @Override
            public String formatValue(Object value, AnalyticalField analyticalField) {
                return FlatBuilderForRectTree.this.formatValue(value, analyticalField);
            }

            @Override
            public String formatNumber(BigDecimal value, AnalyticalField analyticalField) {
                return FlatBuilderForRectTree.this.formatNumber(value, analyticalField);
            }

            @Override
            public String encodeCategoryValue(Object categoryValue, String label) {
                return FlatBuilderForRectTree.encodeCategoryValue(categoryValue, label);
            }

            @Override
            public String getDefaultColor() {
                return FlatBuilderForRectTree.this.getDefaultColorValue();
            }

            @Override
            public String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported object, String text) {
                return FlatBuilderForRectTree.this.makeDiscreteColorValue(object, text);
            }

            @Override
            public String makeContinuousColorValue(BigDecimal measureValue, Scope scope, AnalyticalField colorField) {
                return FlatBuilderForRectTree.this.makeContinuousColorValue(measureValue, scope, colorField);
            }

            @Override
            public boolean isSubtotal(CompositeKey dimKey) {
                return FlatBuilderForRectTree.this._cuboidSpliter.isSubtotalKey(dimKey);
            }
        });
        MarkParserForRectTree mp = this.getMyMarkParser();
        treeChartHandler.setSizeDefine(mp.getSizeField(), mp.getSizeFieldIndexAtMeasure());
        AnalyticalField colorField = mp.getDiscreteColorField();
        if (colorField != null) {
            int colorIdxAtDimension = this.getModelAssistantStructure().getCellDimensionFields().indexOf(colorField);
            treeChartHandler.setDiscreteColorDefine(colorField, colorIdxAtDimension);
        } else {
            colorField = mp.getContinuousColorField();
            if (colorField != null) {
                Scope scope = this.getMeasureScope(mp.getContinuousColorIdxAtMeasure());
                treeChartHandler.setContinueColorDefine(colorField, scope);
            }
        }
        return treeChartHandler;
    }

    private boolean isHideNegative() {
        ChartConfig cc = this.getChartConfig();
        ChartConfig.RectTreeChartConfig rtcc = cc == null ? null : cc.getRectTreeChartConfig();
        boolean isHideNegative = rtcc == null ? false : rtcc.isHideNegative();
        return isHideNegative;
    }

    private static class MarkParserForRectTree
    extends AbstractMarkParser {
        private AnalyticalField _sizeField;
        private int _sizeIdxAtMeasure = -1;
        private AnalyticalField _discreteColorField;
        private AnalyticalField _continuousColorField;
        private int _continuousColorIdxAtMeasure = -1;

        private MarkParserForRectTree() {
        }

        public AnalyticalField getSizeField() {
            return this._sizeField;
        }

        public int getSizeFieldIndexAtMeasure() {
            return this._sizeIdxAtMeasure;
        }

        public AnalyticalField getDiscreteColorField() {
            return this._discreteColorField;
        }

        public AnalyticalField getContinuousColorField() {
            return this._continuousColorField;
        }

        public int getContinuousColorIdxAtMeasure() {
            return this._continuousColorIdxAtMeasure;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            List<AnalyticalField> markFields = this.getModel().getFields();
            int idx = this.searchMarkAsMeasure("size");
            if (idx >= 0) {
                this._sizeField = markFields.get(idx);
                this._sizeIdxAtMeasure = MarkParserForRectTree.getIndexAtMeasure(this._sizeField, measureFields);
                if (this._sizeIdxAtMeasure >= 0) {
                    whichMeasureToDraw[this._sizeIdxAtMeasure] = true;
                }
            }
            if ((idx = this.searchMarkAsDimension("color")) >= 0) {
                this._discreteColorField = markFields.get(idx);
            } else {
                idx = this.searchMarkAsMeasure("color");
                if (idx >= 0) {
                    this._continuousColorField = markFields.get(idx);
                    this._continuousColorIdxAtMeasure = MarkParserForRectTree.getIndexAtMeasure(this._continuousColorField, measureFields);
                }
            }
        }
    }
}

