/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.AbstractProgress;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.ProgressCircleProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;

class MakerForProgressCircle
extends AbstractSquareViewMaker {
    private Legends.DiscreteColorLegend _legend = new Legends.DiscreteColorLegend();
    private AnalyticalField _desiredField;
    private AnalyticalField _completeField;

    MakerForProgressCircle() {
    }

    private AbstractProgress getChartModel() {
        return (AbstractProgress)this.getModel().getChartModel();
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        FieldSet desiredFields = this.getChartModel().getDesired();
        this._desiredField = desiredFields.getFieldCount() > 0 ? desiredFields.getField(0) : null;
        FieldSet completedFields = this.getChartModel().getCompleted();
        this._completeField = completedFields.getFieldCount() > 0 ? completedFields.getField(0) : null;
        BigDecimal desired = null;
        BigDecimal completed = null;
        if (this.getCuboid().getCellCount() > 0 && this._desiredField != null && this._completeField != null) {
            CompositeKey dimKey = this.getCuboid().createDimensionKeyIterator().next();
            Aggregator[] aggs = this.getCuboid().getCellAggregators(dimKey);
            desired = aggs[0].getNumberValue();
            completed = aggs[1].getNumberValue();
        }
        return this.createChartModel(desired, completed);
    }

    @Override
    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.PROGRESS;
    }

    @Override
    protected AbstractSquareViewMaker.AbstractColorValueMaker createColorValueMaker() {
        return new MyColorValueMaker();
    }

    private MultiSeriesChartModel createChartModel(BigDecimal desired, BigDecimal completed) {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        chart.addCategory(new AbstractNormalChartModel.Category());
        this.addSeries(chart, this._desiredField, desired);
        this.addSeries(chart, this._completeField, completed);
        return chart;
    }

    private void addSeries(MultiSeriesChartModel chart, AnalyticalField field, BigDecimal value) {
        String title = field == null ? "---" : this.getMeasureTitle(field);
        AbstractNormalChartModel.Series series = chart.addSeries(title);
        series.setOrderingValue(field);
        AbstractNormalChartModel.Node node = this.createNodeNotNull(value, field);
        series.getCategoryFitnessNodeList(1).set(0, node);
        String color = this.makeDiscreteColorValue(series, title, false);
        series.setColor(color);
        String legendFormat = ((ProgressCircleProperty)this.getChartModel().getChartProperty()).getLegendFormatString();
        if (legendFormat == null) {
            legendFormat = field == null ? "" : field.getUsableNumberFormat();
        }
        String legendText = this.formatNumber(value, legendFormat);
        this._legend.add(color, legendText, title);
    }

    private class MyColorValueMaker
    extends AbstractSquareViewMaker.CommonDiscreateColorValueMaker {
        private MyColorValueMaker() {
        }

        @Override
        public void createLegends(Legends legends) {
            legends.setDiscreteColorLegend(MakerForProgressCircle.this._legend);
        }
    }
}

