/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.flattening.square.MakerForArea;
import com.kingdee.bos.qing.core.flattening.square.MakerForBar;
import com.kingdee.bos.qing.core.flattening.square.MakerForColumn;
import com.kingdee.bos.qing.core.flattening.square.MakerForComposite;
import com.kingdee.bos.qing.core.flattening.square.MakerForCustomList;
import com.kingdee.bos.qing.core.flattening.square.MakerForDial;
import com.kingdee.bos.qing.core.flattening.square.MakerForFunnel;
import com.kingdee.bos.qing.core.flattening.square.MakerForGrid;
import com.kingdee.bos.qing.core.flattening.square.MakerForKpi;
import com.kingdee.bos.qing.core.flattening.square.MakerForLine;
import com.kingdee.bos.qing.core.flattening.square.MakerForMap;
import com.kingdee.bos.qing.core.flattening.square.MakerForMapGis;
import com.kingdee.bos.qing.core.flattening.square.MakerForPercentArea;
import com.kingdee.bos.qing.core.flattening.square.MakerForPercentStackedBar;
import com.kingdee.bos.qing.core.flattening.square.MakerForPercentStackedColumn;
import com.kingdee.bos.qing.core.flattening.square.MakerForPie;
import com.kingdee.bos.qing.core.flattening.square.MakerForProgressBar;
import com.kingdee.bos.qing.core.flattening.square.MakerForProgressCircle;
import com.kingdee.bos.qing.core.flattening.square.MakerForProgressColumn;
import com.kingdee.bos.qing.core.flattening.square.MakerForRadar;
import com.kingdee.bos.qing.core.flattening.square.MakerForRectTree;
import com.kingdee.bos.qing.core.flattening.square.MakerForScatter;
import com.kingdee.bos.qing.core.flattening.square.MakerForStackedBar;
import com.kingdee.bos.qing.core.flattening.square.MakerForStackedColumn;
import com.kingdee.bos.qing.core.flattening.square.MakerForSunburst;
import com.kingdee.bos.qing.core.flattening.square.MakerForWaterfall;
import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import java.util.HashMap;
import java.util.Map;

public class SquareViewMakerFactory {
    private static Map<SquareChartType, Class<? extends AbstractSquareViewMaker>> map = new HashMap<SquareChartType, Class<? extends AbstractSquareViewMaker>>();

    public static AbstractSquareViewMaker createMaker(SquareChartType chartType) {
        AbstractSquareViewMaker maker;
        Class<? extends AbstractSquareViewMaker> clazz = map.get((Object)chartType);
        try {
            maker = clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        return maker;
    }

    private SquareViewMakerFactory() {
    }

    static {
        map.put(SquareChartType.Column, MakerForColumn.class);
        map.put(SquareChartType.Bar, MakerForBar.class);
        map.put(SquareChartType.StackedColumn, MakerForStackedColumn.class);
        map.put(SquareChartType.StackedBar, MakerForStackedBar.class);
        map.put(SquareChartType.PercentStackedColumn, MakerForPercentStackedColumn.class);
        map.put(SquareChartType.PercentStackedBar, MakerForPercentStackedBar.class);
        map.put(SquareChartType.Line, MakerForLine.class);
        map.put(SquareChartType.Area, MakerForArea.class);
        map.put(SquareChartType.PercentArea, MakerForPercentArea.class);
        map.put(SquareChartType.Pie, MakerForPie.class);
        map.put(SquareChartType.Ring, MakerForPie.class);
        map.put(SquareChartType.Rose, MakerForPie.class);
        map.put(SquareChartType.KPI, MakerForKpi.class);
        map.put(SquareChartType.Map, MakerForMap.class);
        map.put(SquareChartType.GIS, MakerForMapGis.class);
        map.put(SquareChartType.Radar, MakerForRadar.class);
        map.put(SquareChartType.ProgressBar, MakerForProgressBar.class);
        map.put(SquareChartType.ProgressColumn, MakerForProgressColumn.class);
        map.put(SquareChartType.ProgressCircle, MakerForProgressCircle.class);
        map.put(SquareChartType.Composite, MakerForComposite.class);
        map.put(SquareChartType.Grid, MakerForGrid.class);
        map.put(SquareChartType.CustomList, MakerForCustomList.class);
        map.put(SquareChartType.Waterfall, MakerForWaterfall.class);
        map.put(SquareChartType.Funnel, MakerForFunnel.class);
        map.put(SquareChartType.Scatter, MakerForScatter.class);
        map.put(SquareChartType.Dial, MakerForDial.class);
        map.put(SquareChartType.RectTree, MakerForRectTree.class);
        map.put(SquareChartType.Sunburst, MakerForSunburst.class);
    }
}

