/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis;

import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.i18n.ErrorMessage;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.BriefOutputException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.WarningRuleException;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.brief.BriefOutputDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.param.Parameters;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.parser.BriefOutputScriptParser;
import com.kingdee.bos.qing.core.model.parser.WarningRuleScriptParser;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractQingModel
implements IQingModel {
    private transient Meta _meta;
    private transient Parameters _parameters;
    private List<BriefOutputDefinition> briefOutputDefinitions;
    private List<WarningRuleDefinition> warningRuleDefinitions;

    @Override
    public final void bindMeta(Meta meta) {
        this._meta = meta;
        this.fixMetaFieldBinding(meta);
    }

    protected abstract void fixMetaFieldBinding(Meta var1);

    @Override
    public final Meta getMeta() {
        return this._meta;
    }

    @Override
    public final Parameters getParameters() {
        if (this._parameters == null) {
            this._parameters = new Parameters();
        }
        return this._parameters;
    }

    @Override
    public final List<BriefOutputDefinition> getBriefOutputDefinitions() {
        return this.briefOutputDefinitions;
    }

    @Override
    public final List<WarningRuleDefinition> getWarningRuleDefinitions() {
        return this.warningRuleDefinitions;
    }

    protected final void sharedCopy(AbstractQingModel newInst) {
        newInst._meta = this._meta;
        newInst._parameters = this._parameters;
        newInst.briefOutputDefinitions = this.briefOutputDefinitions;
        newInst.warningRuleDefinitions = this.warningRuleDefinitions;
    }

    protected final void sharedToXml(Element node) {
        if (this.briefOutputDefinitions != null) {
            Element nodeBriefOutputs = new Element("BriefOutput");
            for (BriefOutputDefinition bod : this.briefOutputDefinitions) {
                Element nodeBriefOutput = new Element("Item");
                bod.toXml(nodeBriefOutput);
                nodeBriefOutputs.addContent((Content)nodeBriefOutput);
            }
            node.addContent((Content)nodeBriefOutputs);
        }
        if (this.warningRuleDefinitions != null) {
            Element nodeWarningRules = new Element("WarningRule");
            for (WarningRuleDefinition wrd : this.warningRuleDefinitions) {
                Element nodeWarningRule = new Element("Item");
                wrd.toXml(nodeWarningRule);
                nodeWarningRules.addContent((Content)nodeWarningRule);
            }
            node.addContent((Content)nodeWarningRules);
        }
    }

    protected final void sharedFromXml(Element node) throws PersistentModelParseException {
        this.briefOutputDefinitions = null;
        Element nodeBriefOutputs = XmlUtil.getChild((Element)node, (String)"BriefOutput");
        if (nodeBriefOutputs != null) {
            List briefOutputNodes = XmlUtil.getChildren((Element)nodeBriefOutputs, (String)"Item");
            this.briefOutputDefinitions = new ArrayList<BriefOutputDefinition>(briefOutputNodes.size());
            for (Element nodeBriefOutput : briefOutputNodes) {
                BriefOutputDefinition bod = new BriefOutputDefinition();
                bod.fromXml(nodeBriefOutput);
                this.briefOutputDefinitions.add(bod);
            }
        }
        this.warningRuleDefinitions = null;
        Element nodeWarningRules = XmlUtil.getChild((Element)node, (String)"WarningRule");
        if (nodeWarningRules != null) {
            List warningRuleNodes = XmlUtil.getChildren((Element)nodeWarningRules, (String)"Item");
            this.warningRuleDefinitions = new ArrayList<WarningRuleDefinition>(warningRuleNodes.size());
            for (Element nodeWarningRule : warningRuleNodes) {
                WarningRuleDefinition wrd = new WarningRuleDefinition();
                wrd.fromXml(nodeWarningRule);
                this.warningRuleDefinitions.add(wrd);
            }
        }
    }

    public abstract void visitFilters(IFilterVisitor var1);

    public static void parseBriefOutputExprs(BriefOutputDefinition bod, II18nContext i18nCtx) throws BriefOutputException {
        List<BriefOutputDefinition.AbstractPicker> dimensionPickers = bod.getDimensionPickers();
        for (int i = 0; i < dimensionPickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = dimensionPickers.get(i);
            if (picker.getType() != BriefOutputDefinition.PickerType.CONDITION) continue;
            BriefOutputDefinition.ConditionPicker cp = (BriefOutputDefinition.ConditionPicker)picker;
            String formula = cp.getConditionScript();
            try {
                IExpr expr = formula == null ? null : BriefOutputScriptParser.parseConditionFilter(formula);
                cp.setConditionExpr(expr);
                continue;
            }
            catch (ParserException ex) {
                String which = Messages.getLangMessage(i18nCtx, "briefOutputDimensionCondition", "\u7b2c#1\u4e2a\u7ef4\u5ea6\u7684\u7b5b\u9009\u6761\u4ef6").replace("#1", String.valueOf(i + 1));
                throw AbstractQingModel.createBriefOutputException(ex, i18nCtx, bod, which, formula);
            }
        }
        List<BriefOutputDefinition.AbstractPicker> measurePickers = bod.getMeasurePickers();
        for (int i = 0; i < measurePickers.size(); ++i) {
            BriefOutputDefinition.AbstractPicker picker = measurePickers.get(i);
            if (picker.getType() != BriefOutputDefinition.PickerType.CONDITION) continue;
            BriefOutputDefinition.ConditionPicker cp = (BriefOutputDefinition.ConditionPicker)picker;
            String formula = cp.getConditionScript();
            try {
                IExpr expr = formula == null ? null : BriefOutputScriptParser.parseConditionFilter(formula);
                cp.setConditionExpr(expr);
                continue;
            }
            catch (ParserException ex) {
                String which = Messages.getLangMessage(i18nCtx, "briefOutputMeasureCondition", "\u7b2c#1\u4e2a\u5ea6\u91cf\u7684\u7b5b\u9009\u6761\u4ef6").replace("#1", String.valueOf(i + 1));
                throw AbstractQingModel.createBriefOutputException(ex, i18nCtx, bod, which, formula);
            }
        }
        String postScript = bod.getPostScript();
        try {
            IExpr expr = postScript == null ? null : BriefOutputScriptParser.parsePostScript(postScript);
            bod.setPostScriptExpr(expr);
        }
        catch (ParserException ex) {
            String which = Messages.getLangMessage(i18nCtx, "briefOutputPostScript", "\u540e\u5904\u7406\u811a\u672c");
            throw AbstractQingModel.createBriefOutputException(ex, i18nCtx, bod, which, postScript);
        }
    }

    private static BriefOutputException createBriefOutputException(ParserException ex, II18nContext i18nCtx, BriefOutputDefinition bod, String which, String script) {
        String who = bod.getName();
        String what = Messages.getLangMessage(i18nCtx, "briefOutputFormulaParser", "\u8bed\u6cd5\u89e3\u6790");
        String exMsg = ErrorMessage.encodeParserException((ParserException)ex, (II18nContext)i18nCtx);
        String pos = Messages.getLangMessage(i18nCtx, "briefOutputFormulaParserAtPossition", "\u4f4d\u4e8e\u5b57\u7b26#1").replace("#1", String.valueOf(ex.getCharacterIndex()));
        String message = who + " | " + which + " | " + what + " | " + exMsg + " | " + pos + "\r\n" + script;
        return BriefOutputException.createFormulaParserException(message);
    }

    public static void parseWarningRuleExprs(WarningRuleDefinition wrd, II18nContext i18nCtx) throws WarningRuleException {
        List<WarningRuleDefinition.ConditionItem> items = wrd.getConditionItems();
        if (!items.isEmpty()) {
            for (int i = 0; i < items.size(); ++i) {
                WarningRuleDefinition.AbstractCondition condition = items.get(i).getCondition();
                if (!(condition instanceof WarningRuleDefinition.CustomCondition)) continue;
                WarningRuleDefinition.CustomCondition cc = (WarningRuleDefinition.CustomCondition)condition;
                String formula = cc.getConditionScript();
                try {
                    IExpr expr = formula == null ? null : WarningRuleScriptParser.parseCustomCondition(formula);
                    cc.setConditionExpr(expr);
                    continue;
                }
                catch (ParserException ex) {
                    String which = "which=row#1".replace("#1", String.valueOf(i + 1));
                    throw AbstractQingModel.createWarningRuleException(ex, i18nCtx, wrd, which, formula);
                }
            }
        }
        String postScript = wrd.getPostScript();
        try {
            IExpr expr = postScript == null ? null : WarningRuleScriptParser.parsePostScript(postScript);
            wrd.setPostScriptExpr(expr);
        }
        catch (ParserException ex) {
            String which = Messages.getLangMessage(i18nCtx, "briefOutputPostScript", "\u540e\u5904\u7406\u811a\u672c");
            throw AbstractQingModel.createWarningRuleException(ex, i18nCtx, wrd, which, postScript);
        }
    }

    private static WarningRuleException createWarningRuleException(ParserException ex, II18nContext i18nCtx, WarningRuleDefinition wrd, String which, String script) {
        String who = wrd.getName();
        String what = Messages.getLangMessage(i18nCtx, "briefOutputFormulaParser", "\u8bed\u6cd5\u89e3\u6790");
        String exMsg = ErrorMessage.encodeParserException((ParserException)ex, (II18nContext)i18nCtx);
        String pos = Messages.getLangMessage(i18nCtx, "briefOutputFormulaParserAtPossition", "\u4f4d\u4e8e\u5b57\u7b26#1").replace("#1", String.valueOf(ex.getCharacterIndex()));
        String message = who + " | " + which + " | " + what + " | " + exMsg + " | " + pos + "\r\n" + script;
        return WarningRuleException.createFormulaParserException(message);
    }

    public static interface IFilterVisitor {
        public void visit(AnalyticalField var1, AbstractAnalyticalFilter var2);
    }
}

