/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common.filter;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractScopeLimitedSelectedValues;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Element;

public abstract class AbstractAnalyticalFilter {
    private String name;
    private boolean full;
    private boolean affected;
    private boolean onShow = true;
    private transient boolean _isForcedPullDownDisabled = false;

    public AbstractAnalyticalFilter(String name) {
        this.name = name;
    }

    public void forcedPullDownDisabled() {
        this._isForcedPullDownDisabled = true;
    }

    public boolean isForcedPullDownDisabled() {
        return this._isForcedPullDownDisabled;
    }

    public final String getName() {
        return this.name;
    }

    public final void setFullValue(boolean full) {
        this.full = full;
    }

    public final boolean isFullValue() {
        return this.full;
    }

    public boolean isAllAccepted() {
        return this.isFullValue();
    }

    public final void setAffected(boolean affected) {
        this.affected = affected;
    }

    public final boolean isAffected() {
        return this.affected;
    }

    public final void setOnShow(boolean isOnShow) {
        this.onShow = isOnShow;
    }

    public final boolean isOnShow() {
        return this.onShow;
    }

    public abstract void safety();

    public abstract void parseForBeforeRun();

    public abstract AbstractScopeLimitedSelectedValues getSlicedSelectValuesWithinScope(AbstractPreparedValue var1);

    public final void toXml(Element node) {
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"full", (boolean)this.full);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"affected", (boolean)this.affected);
        XmlUtil.writeAttrDefaultTrue((Element)node, (String)"onShow", (boolean)this.onShow);
        this.toXmlImpl(node);
    }

    public final void fromXml(Element node) throws PersistentModelParseException {
        this.full = XmlUtil.readAttrDefaultFalse((Element)node, (String)"full");
        this.affected = XmlUtil.readAttrDefaultFalse((Element)node, (String)"affected");
        this.onShow = XmlUtil.readAttrDefaultTrue((Element)node, (String)"onShow");
        this.fromXmlImpl(node);
    }

    protected abstract void toXmlImpl(Element var1);

    protected abstract void fromXmlImpl(Element var1) throws PersistentModelParseException;

    public AbstractAnalyticalFilter copy() {
        AbstractAnalyticalFilter filter = this.doCopy();
        filter.name = this.name;
        filter.full = this.full;
        filter.affected = this.affected;
        filter.onShow = this.onShow;
        return filter;
    }

    protected abstract AbstractAnalyticalFilter doCopy();

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractAnalyticalFilter> {
        protected AbstractAnalyticalFilter decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String name = json.getAttrValue("name");
            if ("discrete".equals(name)) {
                return (AbstractAnalyticalFilter)this.fromJson(json, DiscreteFilter.class);
            }
            if ("continuous".equals(name)) {
                return (AbstractAnalyticalFilter)this.fromJson(json, ContinuousFilter.class);
            }
            if ("continuousDate".equals(name)) {
                return (AbstractAnalyticalFilter)this.fromJson(json, ContinuousDateFilter.class);
            }
            throw new RuntimeException("Unknown filter name.");
        }
    }
}

