/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square.chart.property.sub;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class Sort {
    private Order order = Order.NUL;
    private SortAccording according;
    private Integer topN;
    private Boolean others;

    public boolean isToSortByMeasure() {
        return this.order == Order.ASC || this.order == Order.DESC;
    }

    public boolean isAscendent() {
        return this.order == Order.ASC;
    }

    public SortAccording getSortAccording() {
        return this.according;
    }

    public int getTopN() {
        return this.topN == null ? -1 : this.topN;
    }

    public boolean isOthersAsAnItem() {
        return this.others == null ? false : this.others;
    }

    public static void copyBase(Sort fromInst, Sort toInst) {
        toInst.order = fromInst.order;
        toInst.according = fromInst.according;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrNotNull((Element)node, (String)"order", (String)this.order.toPersistance());
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"topN", (Integer)this.topN);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"others", (Boolean)this.others);
        if (this.according != null) {
            Element nodeAccording = new Element("Accodring");
            this.according.toXml(nodeAccording);
            node.addContent((Content)nodeAccording);
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        String orderString = XmlUtil.readAttrWhenExist((Element)node, (String)"order");
        this.order = Order.fromPersistance(orderString);
        this.topN = XmlUtil.readAttrIntWhenExist((Element)node, (String)"topN");
        this.others = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"others");
        this.according = null;
        Element nodeAccording = XmlUtil.getChild((Element)node, (String)"Accodring");
        if (nodeAccording != null) {
            this.according = new SortAccording();
            this.according.fromXml(nodeAccording);
        }
    }

    public static enum Order {
        NUL,
        ASC,
        DESC;


        public String toPersistance() {
            return this.name();
        }

        public static Order fromPersistance(String name) {
            try {
                return Order.valueOf(name);
            }
            catch (Exception ex) {
                return NUL;
            }
        }
    }

    public static class SortAccording {
        private Integer measure;
        private String metaField;
        private Aggregation aggregation;
        private transient int _runtimeMeasureIndex = -1;

        public void setRuntimeMeasureIndex(int idx) {
            this._runtimeMeasureIndex = idx;
        }

        public int getRuntimeMeasureIndex() {
            if (this._runtimeMeasureIndex < 0) {
                this._runtimeMeasureIndex = this.measure == null ? 0 : this.measure;
            }
            return this._runtimeMeasureIndex;
        }

        public Integer getMeasureIndex() {
            return this.measure;
        }

        public String getMetaFieldFullName() {
            return this.metaField;
        }

        public Aggregation getAggregation() {
            return this.aggregation;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"measure", (Integer)this.measure);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"metaField", (String)this.metaField);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"aggregation", this.aggregation == null ? null : this.aggregation.toPersistance());
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            this.measure = XmlUtil.readAttrIntWhenExist((Element)node, (String)"measure");
            this.metaField = XmlUtil.readAttrWhenExist((Element)node, (String)"metaField");
            String agg = XmlUtil.readAttrWhenExist((Element)node, (String)"aggregation");
            this.aggregation = agg == null ? null : Aggregation.fromPersistance(agg);
        }
    }
}

