/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.exhibition.common.chart;

import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TreeMapChartModel
extends AbstractChartModel {
    private String[] dimTitles;
    private String sizeFieldTitle;
    private String colorFieldTitle;
    private Integer negativeValueCount;
    private TreeMapNode root = new TreeMapNode("ROOT", null);
    private String negativeValueInfo;

    public TreeMapNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeMapNode root) {
        this.root = root;
        this.root.sortChildren();
    }

    public String[] getDimTitles() {
        return this.dimTitles;
    }

    public void setDimTitles(String[] dimTitles) {
        this.dimTitles = dimTitles;
    }

    public int getNegativeValueCount() {
        return this.negativeValueCount;
    }

    public void setNegativeValueCount(int negativeValueCount) {
        this.negativeValueCount = negativeValueCount;
    }

    public void setNegativeValueInfo(String negativeValueInfo) {
        this.negativeValueInfo = negativeValueInfo;
    }

    public String getNegativeValueInfo() {
        return this.negativeValueInfo;
    }

    public void setSizeFieldTitle(String sizeFieldTitle) {
        this.sizeFieldTitle = sizeFieldTitle;
    }

    public void setColorFieldTitle(String colorFieldTitle) {
        this.colorFieldTitle = colorFieldTitle;
    }

    public String getSizeFieldTitle() {
        return this.sizeFieldTitle;
    }

    public String getColorFieldTitle() {
        return this.colorFieldTitle;
    }

    @Override
    public boolean isEqualTo(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMapChartModel that = (TreeMapChartModel)o;
        if (!Arrays.equals(this.dimTitles, that.dimTitles)) {
            return false;
        }
        if (this.sizeFieldTitle != null ? !this.sizeFieldTitle.equals(that.sizeFieldTitle) : that.sizeFieldTitle != null) {
            return false;
        }
        if (this.colorFieldTitle != null ? !this.colorFieldTitle.equals(that.colorFieldTitle) : that.colorFieldTitle != null) {
            return false;
        }
        return !(this.negativeValueCount != null ? !this.negativeValueCount.equals(that.negativeValueCount) : that.negativeValueCount != null);
    }

    private static class TreeMapNodeCompator
    implements Comparator<TreeMapNode> {
        private TreeMapNodeCompator() {
        }

        @Override
        public int compare(TreeMapNode o1, TreeMapNode o2) {
            Double o1Percentage = o1.size;
            Double o2Percentage = o2.size;
            return o2Percentage.compareTo(o1Percentage);
        }
    }

    public static class TreeMapNode {
        private Object dimValue;
        private Object dimOriValue;
        private String color;
        private String colorText;
        private String sizeText;
        private double size;
        private List<TreeMapNode> children = new ArrayList<TreeMapNode>();

        public TreeMapNode() {
        }

        public TreeMapNode(String dimDisplayValue, String dimOriValue) {
            this.dimValue = dimDisplayValue;
            this.dimOriValue = dimOriValue;
            this.size = 0.0;
        }

        public void sortChildren() {
            Collections.sort(this.children, new TreeMapNodeCompator());
            for (TreeMapNode child : this.children) {
                if (!(child instanceof TreeMapNode)) continue;
                child.sortChildren();
            }
        }

        public String getSizeText() {
            return this.sizeText;
        }

        public TreeMapNode addChildNode(String key, String dimOriValue) {
            TreeMapNode treeMapNode = new TreeMapNode(key, dimOriValue);
            this.children.add(treeMapNode);
            return treeMapNode;
        }

        public List<TreeMapNode> getChildren() {
            return this.children;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public Object getDimValue() {
            return this.dimValue;
        }

        public void setDimValue(Object dimValue) {
            this.dimValue = dimValue;
        }

        public void setDimOriValue(Object dimOriValue) {
            this.dimOriValue = dimOriValue;
        }

        public Object getDimOriValue() {
            return this.dimOriValue;
        }

        public String getColorText() {
            return this.colorText;
        }

        public void setColorText(String colorText) {
            this.colorText = colorText;
        }

        public double getSize() {
            return this.size;
        }

        public void setSize(double size) {
            this.size = size;
        }

        public void setSizeText(String sizeText) {
            this.sizeText = sizeText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeMapNode that = (TreeMapNode)o;
            if (Double.compare(that.size, this.size) != 0) {
                return false;
            }
            if (!this.children.equals(that.children)) {
                return false;
            }
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
                return false;
            }
            return !(this.dimValue == null ? that.dimValue != null : !this.dimValue.equals(that.dimValue));
        }

        public int hashCode() {
            int result = this.children.hashCode();
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.dimValue != null ? this.dimValue.hashCode() : 0);
            long temp = Double.doubleToLongBits(this.size);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

