/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.meta.view;

import com.kingdee.bos.qing.core.model.meta.view.AbstractViewItem;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class MetaTableSubView {
    private String name;
    private String displayName;
    private DisplayAs displayAs = DisplayAs.Table;
    private List<MetaTableSubView> subViews;
    private List<AbstractViewItem> viewItems;

    public MetaTableSubView(String name, String displayName) {
        this.setName(name);
        this.setDisplayName(displayName);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayAs(DisplayAs displayAs) {
        this.displayAs = displayAs;
    }

    public DisplayAs getDisplayAs() {
        return this.displayAs;
    }

    public void setSubViews(List<MetaTableSubView> subViews) {
        this.subViews = subViews;
    }

    public List<MetaTableSubView> getSubViews() {
        if (this.subViews == null) {
            this.subViews = new ArrayList<MetaTableSubView>();
        }
        return this.subViews;
    }

    public void setViewItems(List<AbstractViewItem> items) {
        this.viewItems = items;
    }

    public List<AbstractViewItem> getViewItems() {
        if (this.viewItems == null) {
            this.viewItems = new ArrayList<AbstractViewItem>();
        }
        return this.viewItems;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrNotNull((Element)node, (String)"name", (String)this.name);
        XmlUtil.writeAttrNotNull((Element)node, (String)"displayName", (String)this.displayName);
        XmlUtil.writeAttrNotNull((Element)node, (String)"as", (String)this.displayAs.toPersistance());
        if (this.viewItems != null) {
            node.addContent((Content)AbstractViewItem.itemsToXml(this.viewItems));
        }
        if (this.subViews != null) {
            node.addContent((Content)MetaTableSubView.subViewsToXml(this.subViews));
        }
    }

    public void fromXml(Element node) {
        this.name = XmlUtil.readAttrWhenExist((Element)node, (String)"name");
        this.displayName = XmlUtil.readAttrWhenExist((Element)node, (String)"displayName");
        this.displayAs = DisplayAs.fromPersistance(XmlUtil.readAttrWhenExist((Element)node, (String)"as"));
        this.viewItems = AbstractViewItem.itemsFromXml(node);
        this.subViews = MetaTableSubView.subViewsFromXml(node);
    }

    public static Element subViewsToXml(List<MetaTableSubView> subViews) {
        Element nodeSubViews = new Element("SubViews");
        for (MetaTableSubView subView : subViews) {
            Element nodeSubView = new Element("SubView");
            subView.toXml(nodeSubView);
            nodeSubViews.addContent((Content)nodeSubView);
        }
        return nodeSubViews;
    }

    public static List<MetaTableSubView> subViewsFromXml(Element nodeParent) {
        Element nodeSubViews = nodeParent.getChild("SubViews");
        if (nodeSubViews == null) {
            return null;
        }
        List children = XmlUtil.getChildren((Element)nodeSubViews, (String)"SubView");
        ArrayList<MetaTableSubView> subViews = new ArrayList<MetaTableSubView>(children.size());
        for (Element nodeSubView : children) {
            MetaTableSubView subView = new MetaTableSubView("", "");
            subView.fromXml(nodeSubView);
            subViews.add(subView);
        }
        return subViews;
    }

    public static enum DisplayAs {
        Table,
        ElasticField;


        public String toPersistance() {
            return this.name();
        }

        public static DisplayAs fromPersistance(String name) {
            try {
                return DisplayAs.valueOf(name);
            }
            catch (Exception ex) {
                return Table;
            }
        }
    }
}

