/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.affected;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class AffectedTargets {
    private static Map<String, Class<? extends AbstractTargetItem>> ITEM_CLASS = new HashMap<String, Class<? extends AbstractTargetItem>>();
    private List<AbstractTargetItem> items;

    public static Class<? extends AbstractTargetItem> getClass(String type) {
        Class<? extends AbstractTargetItem> clazz = ITEM_CLASS.get(type);
        return clazz;
    }

    private static AbstractTargetItem createTargetItem(String type) throws PersistentModelParseException {
        Class<? extends AbstractTargetItem> clazz = ITEM_CLASS.get(type);
        if (clazz == null) {
            throw PersistentModelParseException.createParseError("Unknow AffectedTargetItem.type: " + type);
        }
        AbstractTargetItem inst = null;
        try {
            inst = clazz.newInstance();
        }
        catch (InstantiationException ex) {
            LogUtil.error((String)"", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            LogUtil.error((String)"", (Throwable)ex);
        }
        return inst;
    }

    public void toXml(Element node) {
        if (this.items != null) {
            for (AbstractTargetItem targetItem : this.items) {
                Element nodeItem = new Element("Item");
                targetItem.toXml(nodeItem);
                node.addContent((Content)nodeItem);
            }
        }
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        List itemNodes = XmlUtil.getChildren((Element)node, (String)"Item");
        if (itemNodes != null && itemNodes.size() > 0) {
            this.items = new ArrayList<AbstractTargetItem>(itemNodes.size());
            for (Element nodeItem : itemNodes) {
                String type = XmlUtil.readAttrWhenExist((Element)nodeItem, (String)"type");
                AbstractTargetItem targetItem = type == null ? this.fromXmlUpgradeBefore2020Dec(nodeItem) : AffectedTargets.createTargetItem(type);
                if (targetItem == null) continue;
                targetItem.fromXml(nodeItem);
                this.items.add(targetItem);
            }
        }
    }

    private AbstractInnerTargetItem fromXmlUpgradeBefore2020Dec(Element nodeItem) {
        AbstractInnerTargetItem targetItem = null;
        String widget = XmlUtil.readAttrWhenExist((Element)nodeItem, (String)"widget");
        String field = XmlUtil.readAttrWhenExist((Element)nodeItem, (String)"field");
        String param = XmlUtil.readAttrWhenExist((Element)nodeItem, (String)"param");
        if (field != null) {
            targetItem = new BindingFieldItem();
            targetItem.setWidgetName(widget);
            ((BindingFieldItem)targetItem).setFieldName(field);
        } else if (param != null) {
            targetItem = new ParamItem();
            targetItem.setWidgetName(widget);
            ((ParamItem)targetItem).setParamName(param);
        }
        return targetItem;
    }

    static {
        ITEM_CLASS.put(new BindingFieldItem().getType(), BindingFieldItem.class);
        ITEM_CLASS.put(new ParamItem().getType(), ParamItem.class);
        ITEM_CLASS.put(new TabSwitcherItem().getType(), TabSwitcherItem.class);
        ITEM_CLASS.put(new HotlinkItem().getType(), HotlinkItem.class);
    }

    static class HotlinkItem
    extends AbstractTargetItem {
        private String mode;
        private String url;

        HotlinkItem() {
        }

        @Override
        protected String createType() {
            return "hotlink";
        }

        @Override
        protected void toXmlImpl(Element node) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"mode", (String)this.mode);
            XmlUtil.addCDATA((Element)node, (String)this.url);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            this.mode = XmlUtil.readAttrWhenExist((Element)node, (String)"mode");
            this.url = node.getText();
        }
    }

    static class TabSwitcherItem
    extends AbstractInnerTargetItem {
        private int tabIndex;

        TabSwitcherItem() {
        }

        @Override
        protected String createType() {
            return "tab";
        }

        @Override
        protected void toXmlImpl(Element node) {
            XmlUtil.writeAttrInt((Element)node, (String)"index", (int)this.tabIndex);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            try {
                this.tabIndex = XmlUtil.readAttrInt((Element)node, (String)"index");
            }
            catch (XmlUtil.NullException e) {
                this.tabIndex = 0;
            }
        }
    }

    static class ParamItem
    extends AbstractInnerTargetItem {
        private String param;

        ParamItem() {
        }

        public void setParamName(String param) {
            this.param = param;
        }

        @Override
        protected String createType() {
            return "param";
        }

        @Override
        protected void toXmlImpl(Element node) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"name", (String)this.param);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            this.param = XmlUtil.readAttrWhenExist((Element)node, (String)"name");
        }
    }

    static class BindingFieldItem
    extends AbstractInnerTargetItem {
        private String metaField;

        BindingFieldItem() {
        }

        public void setFieldName(String name) {
            this.metaField = name;
        }

        @Override
        protected String createType() {
            return "binding";
        }

        @Override
        protected void toXmlImpl(Element node) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"field", (String)this.metaField);
        }

        @Override
        protected void fromXmlImpl(Element node) {
            this.metaField = XmlUtil.readAttrWhenExist((Element)node, (String)"field");
        }
    }

    private static abstract class AbstractInnerTargetItem
    extends AbstractTargetItem {
        private String widget;

        private AbstractInnerTargetItem() {
        }

        public void setWidgetName(String widgetName) {
            this.widget = widgetName;
        }

        @Override
        public final void toXml(Element node) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"widget", (String)this.widget);
            super.toXml(node);
        }

        @Override
        public final void fromXml(Element node) {
            this.widget = XmlUtil.readAttrWhenExist((Element)node, (String)"widget");
            super.fromXml(node);
        }
    }

    public static abstract class AbstractTargetItem {
        private String type = this.createType();

        public String getType() {
            return this.type;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrNotNull((Element)node, (String)"type", (String)this.type);
            this.toXmlImpl(node);
        }

        public void fromXml(Element node) {
            this.fromXmlImpl(node);
        }

        protected abstract String createType();

        protected abstract void toXmlImpl(Element var1);

        protected abstract void fromXmlImpl(Element var1);
    }
}

