/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.widget;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.widget.WidgetTypeName;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Element;

public abstract class AbstractWidget {
    private String widgetType = this.getWidgetTypeName().toJsonTypeName();
    private String name;
    private String displayName;
    private int x;
    private int y;
    private int width;
    private int height;
    private Boolean widthLocked;
    private Boolean heightLocked;

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Element toXml() {
        Element node = new Element(this.getWidgetTypeName().toXmlNodeName());
        node.setAttribute("name", this.name);
        node.setAttribute("displayName", this.displayName);
        node.setAttribute("x", String.valueOf(this.x));
        node.setAttribute("y", String.valueOf(this.y));
        node.setAttribute("width", String.valueOf(this.width));
        node.setAttribute("height", String.valueOf(this.height));
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"widthLocked", (Boolean)this.widthLocked);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"heightLocked", (Boolean)this.heightLocked);
        this.toXmlMore(node);
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        try {
            this.name = XmlUtil.readAttrNotNull((Element)node, (String)"name");
            this.displayName = XmlUtil.readAttrNotNull((Element)node, (String)"displayName");
        }
        catch (XmlUtil.NullException ex) {
            PersistentModelParseException.createParseError(ex);
        }
        Integer x = XmlUtil.readAttrIntWhenExist((Element)node, (String)"x");
        this.x = x == null ? 0 : x;
        Integer y = XmlUtil.readAttrIntWhenExist((Element)node, (String)"y");
        this.y = y == null ? 0 : y;
        Integer w = XmlUtil.readAttrIntWhenExist((Element)node, (String)"width");
        this.width = w == null ? 0 : w;
        Integer h = XmlUtil.readAttrIntWhenExist((Element)node, (String)"height");
        this.height = h == null ? 0 : h;
        this.widthLocked = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"widthLocked");
        this.heightLocked = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"heightLocked");
        this.fromXmlMore(node);
    }

    protected abstract WidgetTypeName getWidgetTypeName();

    protected abstract void toXmlMore(Element var1);

    protected abstract void fromXmlMore(Element var1) throws PersistentModelParseException;
}

