/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.export.ICheckExportPermission;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.ResultWrapper;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.AnalyticalPreferences;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.domain.ExecuteDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.export.common.exception.ExportNoContentException;
import com.kingdee.bos.qing.export.common.exception.ExportNoEntityPermException;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.SquareViewAdapter;
import com.kingdee.bos.qing.export.common.model.TableViewAdapter;
import com.kingdee.bos.qing.export.common.persistence.ExportConfig;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.excel.ExcelExport;
import com.kingdee.bos.qing.export.excel.ExcelNumberFormater;
import com.kingdee.bos.qing.export.image.ImageExport;
import com.kingdee.bos.qing.export.image.SquareImageExport;
import com.kingdee.bos.qing.export.pdf.PdfExport;
import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.model.SetupModel;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class ExportDomain {
    public void doExportSquareImage(int width, int height, IQingFile exportFile, SquareModel model, SquareExecuteDomain executeDomain, String imageType) throws AnalysisException {
        SquareViewAdapter sqViewAdapter = new SquareViewAdapter(width, height);
        boolean dataEmpty = false;
        try {
            sqViewAdapter.exeFromModel(model, executeDomain);
        }
        catch (AnalysisException e) {
            dataEmpty = true;
            LogUtil.error((String)"execute failed when generate image", (Throwable)((Object)e));
        }
        SquareImageExport export = new SquareImageExport(sqViewAdapter, imageType, executeDomain.getI18nContext());
        export.setDataEmpty(dataEmpty);
        export.setHeight(height);
        export.setWidth(width);
        long start = System.currentTimeMillis();
        export.exportToFile(exportFile);
        if (LogUtil.isDebugEnabled()) {
            StringBuilder logText = new StringBuilder();
            logText.append("export ");
            logText.append(imageType);
            logText.append(" cost(ms): ");
            logText.append(System.currentTimeMillis() - start);
            LogUtil.debug((String)logText.toString());
        }
    }

    public void checkEntityExportPermission(QingContext qingContext, String tag, AnalyticalModel analyticalModel) throws Exception {
        List<MetaTable> listTable = analyticalModel.getMeta().getTables();
        ICheckExportPermission checkExportPermissionService = (ICheckExportPermission)CustomStrategyRegistrar.getStrategy(ICheckExportPermission.class);
        if (checkExportPermissionService == null) {
            return;
        }
        ArrayList<String> tableNames = new ArrayList<String>(2);
        for (MetaTable table : listTable) {
            tableNames.add(table.getName());
        }
        List noExportPermEntityNames = checkExportPermissionService.checkEntityExportPermission(qingContext.getUserId(), tag, tableNames);
        if (!noExportPermEntityNames.isEmpty()) {
            StringBuilder noExportPermEntityBuilder = new StringBuilder();
            noExportPermEntityBuilder.append("\n    ");
            for (String entityName : noExportPermEntityNames) {
                noExportPermEntityBuilder.append(entityName).append("\n    ");
            }
            String noExportPermissionMsg = Messages.getMLS((QingContext)qingContext, (String)"noExportPermMsg", (String)"\u60a8\u5c1a\u672a\u83b7\u5f97\u4ee5\u4e0b\u4e1a\u52a1\u5b9e\u4f53\u7684\u5f15\u51fa\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743:#1", (Messages.ProjectName)Messages.ProjectName.QING_CORE).replace("#1", noExportPermEntityBuilder.toString());
            throw new ExportNoEntityPermException(noExportPermissionMsg);
        }
    }

    public void doExport(IQingFile qingFile, String fileName, UnitUtil.ExportType exportType, AnalyticalModel analyticalModel, ExecuteDomain excuteDomain, AnalyticalPreferences preferences, String skin, II18nContext i18n) throws AnalysisException {
        ExhibitionStatus exhibitionStatus = preferences.getExhibitionStatus();
        TableViewAdapter tvAdapter = this.creatTableViewAdapter(exportType, analyticalModel, excuteDomain, exhibitionStatus, skin, i18n);
        if (tvAdapter.getRowCount() == 0 || tvAdapter.getColCount() == 0) {
            throw new ExportNoContentException("no content");
        }
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("export rowCout: " + tvAdapter.getRowCount() + ", colCount: " + tvAdapter.getColCount()));
        }
        switch (exportType) {
            case EXCEL: {
                String jsonExportConfig = preferences.getExportConfig();
                ExportConfig config = (ExportConfig)JsonUtil.decodeFromString((String)jsonExportConfig, ExportConfig.class);
                tvAdapter.setExportConfig(config);
                this.doExportExcel(qingFile, tvAdapter);
                break;
            }
            case PDF: {
                String jsonExportSetting = preferences.getExportSetting();
                SetupModel setupModel = (SetupModel)JsonUtil.decodeFromString((String)jsonExportSetting, SetupModel.class);
                this.doExportPdf(qingFile, fileName, setupModel, tvAdapter);
                break;
            }
            case PNG: {
                this.doExportPng(qingFile, tvAdapter, "png");
                break;
            }
            default: {
                throw new RuntimeException("Unknown exprotType: " + (Object)((Object)exportType));
            }
        }
    }

    private TableViewAdapter creatTableViewAdapter(UnitUtil.ExportType exportType, AnalyticalModel model, ExecuteDomain excuteDomain, ExhibitionStatus exhibitionStatus, String skin, II18nContext i18n) throws AnalysisException {
        boolean isOriginalTable;
        boolean bl = isOriginalTable = ChartType.Table == model.getChartType();
        if (ChartType.Table != model.getChartType() && exportType == UnitUtil.ExportType.EXCEL) {
            this.changeToTableModel(model);
            model.setChartType(ChartType.Table);
        }
        ArrayList<ExcelNumberFormater> formatFileds = new ArrayList<ExcelNumberFormater>();
        boolean isToAdjustExhibition = false;
        if (UnitUtil.ExportType.EXCEL == exportType) {
            MarkFieldSet markFieldSet = model.getMarkFieldSet();
            if (markFieldSet != null && markFieldSet.getFields() != null && markFieldSet.getFields().size() > 0) {
                List<AnalyticalField> analyticalFields = markFieldSet.getFields();
                List<String> markTypes = markFieldSet.getMarkTypes();
                ArrayList<AnalyticalField> joinedFields = new ArrayList<AnalyticalField>(analyticalFields.size());
                for (int i = 0; i < analyticalFields.size(); ++i) {
                    AnalyticalField analyticalField = analyticalFields.get(i);
                    if (!"label".equals(markTypes.get(i)) || this.isIncludeFields(joinedFields, analyticalField)) continue;
                    joinedFields.add(analyticalField);
                    String formatStr = analyticalField.getUsableNumberFormat();
                    ExcelNumberFormater excelNumberFormater = new ExcelNumberFormater(formatStr);
                    formatFileds.add(excelNumberFormater);
                    analyticalField.setNumberFormat(excelNumberFormater.getBaseFormatString());
                }
            }
            isToAdjustExhibition = !isOriginalTable;
        }
        ResultWrapper result = excuteDomain.execute(model, null);
        TableViewAdapter tvAdapter = new TableViewAdapter(result.getTableView(), exhibitionStatus, isToAdjustExhibition, model.getChartConfig(), skin, i18n);
        tvAdapter.setFormatFiledModels(formatFileds);
        return tvAdapter;
    }

    private boolean isIncludeFields(List<AnalyticalField> joinedFields, AnalyticalField analyticalField) {
        if (joinedFields == null || joinedFields.isEmpty()) {
            return false;
        }
        for (int i = 0; i < joinedFields.size(); ++i) {
            AnalyticalField joinedField = joinedFields.get(i);
            MetaField metaField = analyticalField.getMetaField();
            if (!joinedField.isSame(analyticalField) || metaField.getFormulaAggStatus() == MetaField.FormulaAggStatus.Interline || metaField.getFormulaAggStatus() == MetaField.FormulaAggStatus.WithTotal) continue;
            return true;
        }
        return false;
    }

    private void doExportExcel(IQingFile qingFile, IExportAdapter tvAdapter) throws ExportException, UserStoppedException {
        ExcelExport export = new ExcelExport(tvAdapter);
        long start = System.currentTimeMillis();
        export.exportToFile(qingFile);
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("export excel cost(ms): " + (System.currentTimeMillis() - start)));
        }
    }

    private void doExportPdf(IQingFile qingFile, String fileName, SetupModel model, TableViewAdapter tvAdapter) throws ExportException {
        tvAdapter.setRowFirst(model.isRowFirst());
        tvAdapter.setTopHeaderAll(model.isTopHeaderAll());
        tvAdapter.setLeftHeaderAll(model.isLeftHeaderAll());
        PdfExport pdfExport = new PdfExport();
        TableViewExportJob exportJob = new TableViewExportJob(model, tvAdapter);
        exportJob.setExportFile(qingFile);
        long start = System.currentTimeMillis();
        pdfExport.export(exportJob, fileName);
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)("export pdf cost(ms): " + (System.currentTimeMillis() - start)));
        }
    }

    private void doExportPng(IQingFile exportUuid, IExportAdapter tvAdapter, String imageType) throws ExportException, UserStoppedException {
        ImageExport export = new ImageExport(tvAdapter, imageType);
        long start = System.currentTimeMillis();
        export.exportToFile(exportUuid);
        if (LogUtil.isDebugEnabled()) {
            StringBuilder logText = new StringBuilder();
            logText.append("export ");
            logText.append(imageType);
            logText.append(" cost(ms): ");
            logText.append(System.currentTimeMillis() - start);
            LogUtil.debug((String)logText.toString());
        }
    }

    private void changeToTableModel(AnalyticalModel model) {
        int i;
        AnalyticalFieldSet row = model.getRow();
        AnalyticalFieldSet column = model.getColumn();
        MarkFieldSet markFieldSet = model.getMarkFieldSet();
        List<AnalyticalField> markFields = null;
        markFields = markFieldSet != null ? markFieldSet.getFields() : new ArrayList<AnalyticalField>();
        List<AnalyticalField> rows = row.getFields();
        List<AnalyticalField> columns = column.getFields();
        ArrayList<AnalyticalField> rowDimensionWrap = new ArrayList<AnalyticalField>(10);
        ArrayList<AnalyticalField> rowMesaureWrap = new ArrayList<AnalyticalField>(10);
        ArrayList<AnalyticalField> columnDimensionWrap = new ArrayList<AnalyticalField>(10);
        ArrayList<AnalyticalField> columnMesaureWrap = new ArrayList<AnalyticalField>(10);
        ArrayList<AnalyticalField> markDimensionWrap = new ArrayList<AnalyticalField>(10);
        ArrayList<AnalyticalField> markMesaureWrap = new ArrayList<AnalyticalField>(10);
        for (AnalyticalField rowField : rows) {
            if (rowField.isMeasure()) {
                rowMesaureWrap.add(rowField);
                continue;
            }
            rowDimensionWrap.add(rowField);
        }
        for (AnalyticalField colField : columns) {
            if (colField.isMeasure()) {
                columnMesaureWrap.add(colField);
                continue;
            }
            columnDimensionWrap.add(colField);
        }
        for (AnalyticalField markField : markFields) {
            if (markField.isMeasure()) {
                markMesaureWrap.add(markField);
                continue;
            }
            markDimensionWrap.add(markField);
        }
        if (columnDimensionWrap.size() == 0 && rowDimensionWrap.size() + markDimensionWrap.size() > 1 && markDimensionWrap.size() > 0) {
            columnDimensionWrap.add((AnalyticalField)markDimensionWrap.get(markDimensionWrap.size() - 1));
            markDimensionWrap.remove(markDimensionWrap.size() - 1);
        }
        for (i = markDimensionWrap.size() - 1; i >= 0; --i) {
            rowDimensionWrap.add((AnalyticalField)markDimensionWrap.get(i));
        }
        for (i = rowMesaureWrap.size() - 1; i >= 0; --i) {
            markMesaureWrap.add((AnalyticalField)rowMesaureWrap.get(i));
        }
        for (i = columnMesaureWrap.size() - 1; i >= 0; --i) {
            markMesaureWrap.add((AnalyticalField)columnMesaureWrap.get(i));
        }
        ArrayList<String> markTypes = new ArrayList<String>(10);
        for (int i2 = 0; i2 < markMesaureWrap.size(); ++i2) {
            markTypes.add("label");
        }
        row.setFields(rowDimensionWrap);
        column.setFields(columnDimensionWrap);
        if (markFieldSet != null) {
            markFieldSet.setFields(markMesaureWrap);
            markFieldSet.setMarkTypes(markTypes);
        }
    }
}

