/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.longer.MdEngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.ConfigCeilingException;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.ResultWrapper;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractScopeLimitedSelectedValues;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AbstractFilterDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.ExecuteDomain;
import com.kingdee.bos.qing.domain.FilterDomain;
import com.kingdee.bos.qing.domain.MetaDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MdExecuteDomain
extends ExecuteDomain {
    public MdExecuteDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    @Override
    protected boolean isExhibitionCacheable() {
        return false;
    }

    @Override
    protected boolean isOutputingLeftHeadMergeBlocks(AnalyticalModel model) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultWrapper christmas(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, boolean isCheckSelectedValueScope) throws AnalysisException {
        TableView tv;
        this.fireMilestoneEvent(ExecuteDomain.Milestone.BEGIN);
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        boolean theRealFirstTime = isCheckSelectedValueScope;
        if (theRealFirstTime) {
            MetaDomain.verifyMetaFieldsExist(model.getMeta(), dataSource.getMeta());
        }
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoLonger(model, additionalFilters);
        }
        MdEngineRunner runner = new MdEngineRunner(dataSource, model);
        runner.setContext(this.getI18nContext());
        FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        int filterCount = filterFieldSet.getFieldCount();
        ArrayList<AbstractPreparedValue> pvs = new ArrayList<AbstractPreparedValue>(filterCount);
        ArrayList<AbstractScopeLimitedSelectedValues> filterSelectedValue = isCheckSelectedValueScope ? new ArrayList<AbstractScopeLimitedSelectedValues>(filterCount) : null;
        Integer[] filterIndexArray = this.cleanInvalidFilterFieldForPrepareValues(filterFieldSet, pvs, filterSelectedValue);
        HashMap<Integer, Integer> fruitsMapping = new HashMap<Integer, Integer>();
        List<AnalyticalField> fieldsThatPreparedValueByEngine = this.whosePreparedValueByEngine(filterFieldSet, filterIndexArray, fruitsMapping, -1);
        for (AnalyticalField field : fieldsThatPreparedValueByEngine) {
            runner.addPreparedValueTargetField(field);
        }
        ICorrespondent correspondent = null;
        try {
            correspondent = MdExecuteDomain.createExecutingCorrespondent();
            this.fireMilestoneEvent(ExecuteDomain.Milestone.ENGINE_START);
            AbstractEngine engine = runner.run(correspondent);
            this.fireMilestoneEvent(ExecuteDomain.Milestone.ENGINE_FINISH, "engine", engine);
            this.fireMilestoneEvent(ExecuteDomain.Milestone.FLAT_START);
            tv = this.flat(model, runner.getModelAssistantStructure(), engine, correspondent);
            this.fireMilestoneEvent(ExecuteDomain.Milestone.FLAT_FINISH);
            this.collectMemoryInfo(correspondent);
            engine = null;
        }
        catch (ConfigCeilingException ex) {
            tv = this.createFlatBuilder(model, null).getTableView();
            tv.getTopHead().add(new String[]{" "});
            tv.setWarning(Messages.getLangMessage(this.getI18nContext(), "tooLargeDataToExecute", "\u6570\u636e\u91cf\u8d85\u51fa\u5f15\u64ce\u5904\u7406\u9650\u5236\u3002"));
        }
        finally {
            MdExecuteDomain.destroyExecutingCorrespondent(correspondent);
        }
        List<FilterPreparedValueGainer.IPreparedValueFruit> allPvfs = this.runForAllPreparedValues(filterFieldSet, filterIndexArray, runner.getPreparedValueFruits(), fruitsMapping);
        for (int i = 0; i < filterIndexArray.length; ++i) {
            int filterIdx = filterIndexArray[i];
            AbstractAnalyticalFilter filter = filterFieldSet.getFilter(i);
            FilterPreparedValueGainer.IPreparedValueFruit allPvf = allPvfs.get(i);
            AbstractPreparedValue pv = allPvf.getPreparedValue();
            pvs.set(filterIdx, pv);
            if (!isCheckSelectedValueScope || filter.isFullValue() || allPvf.isGainerInvalid()) continue;
            AbstractScopeLimitedSelectedValues selectedValue = filter.getSlicedSelectValuesWithinScope(pv);
            filterSelectedValue.set(filterIdx, selectedValue);
        }
        this.fireMilestoneEvent(ExecuteDomain.Milestone.END);
        this.collectCpuInfo();
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.setTableView(tv);
        wrapper.setFilterPreparedValues(pvs);
        wrapper.setFilterSelectedValues(filterSelectedValue);
        return wrapper;
    }

    @Override
    public ResultWrapper execute(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters) throws AnalysisException {
        return this.filtering(model, additionalFilters, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultWrapper filtering(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, int filteringIndex) throws AnalysisException {
        TableView tv;
        this.fireMilestoneEvent(ExecuteDomain.Milestone.BEGIN);
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoLonger(model, additionalFilters);
        }
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        MdEngineRunner runner = new MdEngineRunner(dataSource, model);
        runner.setContext(this.getI18nContext());
        FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        int filterCount = filterFieldSet.getFieldCount();
        ArrayList<AbstractPreparedValue> pvs = new ArrayList<AbstractPreparedValue>(filterCount);
        Integer[] filterIndexArray = this.cleanInvalidFilterFieldForPrepareValues(filterFieldSet, pvs, null);
        HashMap<Integer, Integer> fruitsMapping = new HashMap<Integer, Integer>();
        List<AnalyticalField> fieldsThatPreparedValueByEngine = this.whosePreparedValueByEngine(filterFieldSet, filterIndexArray, fruitsMapping, filteringIndex);
        for (AnalyticalField field : fieldsThatPreparedValueByEngine) {
            runner.addPreparedValueTargetField(field);
        }
        ICorrespondent correspondent = null;
        try {
            correspondent = MdExecuteDomain.createExecutingCorrespondent();
            this.fireMilestoneEvent(ExecuteDomain.Milestone.ENGINE_START);
            AbstractEngine engine = runner.run(correspondent);
            this.fireMilestoneEvent(ExecuteDomain.Milestone.ENGINE_FINISH, "engine", engine);
            this.fireMilestoneEvent(ExecuteDomain.Milestone.FLAT_START);
            tv = this.flat(model, runner.getModelAssistantStructure(), engine, correspondent);
            this.fireMilestoneEvent(ExecuteDomain.Milestone.FLAT_FINISH);
            this.collectMemoryInfo(correspondent);
            engine = null;
        }
        finally {
            MdExecuteDomain.destroyExecutingCorrespondent(correspondent);
        }
        if (fieldsThatPreparedValueByEngine.isEmpty()) {
            pvs = new ArrayList();
        } else {
            List<FilterPreparedValueGainer.IPreparedValueFruit> pvfsByEngine = runner.getPreparedValueFruits();
            for (int i = 0; i < filterIndexArray.length; ++i) {
                AnalyticalField field;
                int filterIdx = filterIndexArray[i];
                if (filterIdx == filteringIndex || (field = filterFieldSet.getField(filterIdx)).isCanPullDown()) continue;
                int fruitByEngineIdx = (Integer)fruitsMapping.get(filterIdx);
                FilterPreparedValueGainer.IPreparedValueFruit fruit = pvfsByEngine.get(fruitByEngineIdx);
                AbstractPreparedValue pv = fruit.getPreparedValue();
                pvs.set(filterIdx, pv);
            }
        }
        this.fireMilestoneEvent(ExecuteDomain.Milestone.END);
        this.collectCpuInfo();
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.setTableView(tv);
        wrapper.setFilterPreparedValues(pvs);
        return wrapper;
    }

    private List<AnalyticalField> whosePreparedValueByEngine(FilterFieldSet filterFieldSet, Integer[] filterIndexArray, Map<Integer, Integer> fruitsMapping, int filteringIndex) {
        ArrayList<AnalyticalField> filterFileds = new ArrayList<AnalyticalField>();
        for (int i = 0; i < filterIndexArray.length; ++i) {
            AnalyticalField field;
            int filterIdx = filterIndexArray[i];
            if (filterIdx == filteringIndex || (field = filterFieldSet.getField(filterIdx)).isCanPullDown()) continue;
            fruitsMapping.put(filterIdx, filterFileds.size());
            filterFileds.add(field);
        }
        return filterFileds;
    }

    private List<FilterPreparedValueGainer.IPreparedValueFruit> runForAllPreparedValues(FilterFieldSet filterFieldSet, Integer[] filterIndexArray, List<FilterPreparedValueGainer.IPreparedValueFruit> pvfsByEngine, Map<Integer, Integer> fruitsMapping) throws AnalysisException {
        ArrayList<FilterPreparedValueGainer.IPreparedValueFruit> allPvfs = new ArrayList<FilterPreparedValueGainer.IPreparedValueFruit>();
        AbstractFilterDomain filterDomain = null;
        for (int i = 0; i < filterIndexArray.length; ++i) {
            FilterPreparedValueGainer.IPreparedValueFruit fruit;
            int filterIdx = filterIndexArray[i];
            AnalyticalField field = filterFieldSet.getField(filterIdx);
            if (field.isCanPullDown()) {
                if (filterDomain == null) {
                    filterDomain = new FilterDomain(this.getDataSourceCreator());
                }
                fruit = filterDomain.getAllPreparedValueByPullDown(field);
            } else {
                int fruitByEngineIdx = fruitsMapping.get(filterIdx);
                fruit = pvfsByEngine.get(fruitByEngineIdx);
            }
            allPvfs.add(fruit);
        }
        return allPvfs;
    }
}

