/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.model.analysis.common.CustomPalette;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.cosmetic.CosmeticModel;
import com.kingdee.bos.qing.domain.AbstractDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PaletteDomain
extends AbstractDomain {
    public PaletteDomain() {
        super(null);
    }

    public List<CustomPalette> getPresetPalettes(String paletteGroup, String paletteType) {
        ArrayList<CustomPalette> presets = new ArrayList<CustomPalette>();
        presets.add(this.createPalette(paletteGroup, paletteType, "white"));
        presets.add(this.createPalette(paletteGroup, paletteType, "darkBlue"));
        return presets;
    }

    private CustomPalette createPalette(String paletteGroup, String paletteType, String skin) {
        CosmeticModel cosmeticModel;
        try {
            cosmeticModel = CosmeticModel.loadPresetCosmetic(skin);
        }
        catch (PersistentModelParseException e) {
            return null;
        }
        List<CosmeticModel.Item> items = cosmeticModel.getGroup(paletteGroup);
        if (paletteType == null) {
            ArrayList<String> colors = new ArrayList<String>();
            for (CosmeticModel.Item item : items) {
                colors.add(item.getValue());
            }
            CustomPalette palette = new CustomPalette();
            palette.setPresetName(skin);
            palette.setColors(colors);
            return palette;
        }
        for (CosmeticModel.Item item : items) {
            if (!paletteType.equals(item.getKey())) continue;
            String[] colors = item.getValue().split(",");
            CustomPalette palette = new CustomPalette();
            palette.setPresetName(skin);
            palette.setColors(Arrays.asList(colors));
            return palette;
        }
        return null;
    }
}

