/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.AxisCell;
import com.kingdee.bos.qing.export.chart.JsDrawChart;
import com.kingdee.bos.qing.export.chart.mock.Canvas;
import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Graphics;

class CellRendererForBar
extends AbstractCellRenderer {
    CellRendererForBar() {
    }

    @Override
    public Object draw(AbstractCellRenderer.CellRenderParameter parameter) {
        Canvas value = null;
        try {
            Object cellModel = parameter.getCellModel();
            ExStyle style = parameter.getCellStyle();
            int canvasWidth = style.getWidth();
            int canvasHeight = style.getHeight();
            Graphics jdkGraphics = parameter.getJdkGraphics();
            DrawInfo.Direction direction = parameter.getDirection();
            ICell commonCell = parameter.getCommonCell();
            AbstractChartModel modelAtCommonCell = ((ChartCell)commonCell).getChart();
            if (cellModel instanceof ChartCell) {
                AbstractChartModel modelAtCell = ((ChartCell)cellModel).getChart();
                this.fillCellModelData((SingleSeriesChartModel)modelAtCommonCell, (SingleSeriesChartModel)modelAtCell);
                if (DrawInfo.Direction.LANDSCAPE == direction) {
                    value = JsDrawChart.getInstance().drawVerticalBar(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel(), parameter.getChartConfig().isLabelInBar());
                } else if (DrawInfo.Direction.PORTRAIT == direction) {
                    value = JsDrawChart.getInstance().drawHorizontalBar(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel(), parameter.getChartConfig().isLabelInBar());
                }
            } else if (cellModel instanceof AxisCell) {
                SingleSeriesChartModel modelAtCell = new SingleSeriesChartModel();
                this.fillCellModelData((SingleSeriesChartModel)modelAtCommonCell, modelAtCell);
                if (DrawInfo.Direction.LANDSCAPE == direction) {
                    value = JsDrawChart.getInstance().drawVerticalAxis(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel(), parameter.getChartConfig().isLabelInBar());
                } else if (DrawInfo.Direction.PORTRAIT == direction) {
                    value = JsDrawChart.getInstance().drawHorizontalAxis(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, parameter.getChartConfig().isShowLabel(), parameter.getChartConfig().isLabelInBar());
                }
            }
        }
        catch (ExportJavaScriptException e) {
            LogUtil.error((String)"Init JsDrawChart error.", (Throwable)((Object)e));
        }
        return value;
    }
}

