/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.square;

import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.FunnelChartProperty;
import com.kingdee.bos.qing.export.chart.JsDrawChart;
import com.kingdee.bos.qing.export.chart.renderer.square.IChartDrawable;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import java.awt.Graphics;

public class ChartRendererForFunnel
implements IChartDrawable {
    private static final String functionName = "drawFunnel";
    private static final int FunnelAttr_LABEL_NONE = 0;
    private static final int FunnelAttr_LABEL_LEFT = 1;
    private static final int FunnelAttr_LABEL_CENTER = 2;
    private static final int FunnelAttr_LABEL_RIGHT = 3;

    @Override
    public Object draw(int canvasWidth, int canvasHeight, Graphics jdkGraphics, Object model, AbstractChartProperty chartProperty) throws ExportJavaScriptException {
        FunnelChartProperty property = (FunnelChartProperty)chartProperty;
        boolean ladderPerfect = property.getLadder() == FunnelChartProperty.Ladder.PERFECT;
        int labelNamePosition = this.translateAttrLabelPosition(property.getNameLabelPosition());
        int labelValuePosition = this.translateAttrLabelPosition(property.getValueLabelPosition());
        int labelPercentPosition = this.translateAttrLabelPosition(property.getRatioLabelPosition());
        String radioBy = property.getRatioBy().toPersistance();
        String percentageFormat = property.getRatioFormat();
        return JsDrawChart.getInstance().drawChart(functionName, canvasWidth, canvasHeight, model, jdkGraphics, ladderPerfect, labelNamePosition, labelValuePosition, labelPercentPosition, radioBy, percentageFormat);
    }

    private int translateAttrLabelPosition(FunnelChartProperty.Position position) {
        return position == FunnelChartProperty.Position.LEFT ? 1 : (position == FunnelChartProperty.Position.RIGHT ? 3 : (position == FunnelChartProperty.Position.CENTER ? 2 : 0));
    }
}

