/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.image;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.MapChartProperty;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartImgGeneratorForGIS;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartImgGeneratorForMap;
import com.kingdee.bos.qing.export.chart.renderer.square.ChartRendererFactory;
import com.kingdee.bos.qing.export.chart.renderer.square.IChartDrawable;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.SquareViewAdapter;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.image.AbstractImageExport;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.map.MapLoader;
import com.kingdee.bos.qing.util.CloseUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;

public class SquareImageExport
extends AbstractImageExport {
    private int width = 500;
    private int height = 250;
    private SquareViewAdapter sqViewAdapter;
    private II18nContext ii18nContext;
    private boolean dataIsEmpty = false;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDataEmpty(boolean isEmpty) {
        this.dataIsEmpty = isEmpty;
    }

    public SquareImageExport(SquareViewAdapter sqViewAdapter, String imageType, II18nContext ii18nContext) {
        this.sqViewAdapter = sqViewAdapter;
        this.ii18nContext = ii18nContext;
        this.imageType = imageType;
    }

    @Override
    public void exportToFile(IQingFile exportFile) throws ExportException {
        if (this.dataIsEmpty || this.sqViewAdapter.isNothingDisplay()) {
            String message = Messages.getLangMessage(this.ii18nContext, "squareNothingToDisplay", "\u6ca1\u6709\u53ef\u5c55\u73b0\u7684\u6570\u636e");
            this.drawDataEmptyImg(exportFile, message);
        } else if (this.sqViewAdapter.isChartMap()) {
            this.drawSvgImg(exportFile);
        } else if (this.sqViewAdapter.isChartGIS()) {
            this.drawGISImg(exportFile);
        } else {
            this.drawGraphicsImg(exportFile);
        }
    }

    private void drawDataEmptyImg(IQingFile exportFile, String message) throws ExportException {
        BufferedImage image = new BufferedImage(this.width, this.height, this.getBufferedImageType());
        Graphics2D mainGraphics = this.getGraphics(image);
        float fontSize = 24.0f;
        Font font = ExFont.getDefaultAwtFont().deriveFont(fontSize);
        mainGraphics.setFont(font);
        mainGraphics.setColor(new Color(204, 204, 204));
        FontMetrics fm = mainGraphics.getFontMetrics(font);
        int textWidth = fm.stringWidth(message);
        mainGraphics.drawString(message, this.width - textWidth >> 1, this.height + (int)fontSize >> 1);
        this.writeImg(image, exportFile);
        mainGraphics.dispose();
    }

    /*
     * Loose catch block
     */
    private void drawSvgImg(IQingFile exportFile) throws ExportException {
        ChartImgGeneratorForMap mapGenerator = new ChartImgGeneratorForMap();
        MapChartProperty chartProperty = (MapChartProperty)this.sqViewAdapter.getProperty();
        OutsideReference outsideRef = chartProperty.getOutsideReference();
        MapLoader.Reference ref = new MapLoader.Reference(outsideRef.getRefToId(), outsideRef.getRefToFullPath());
        InputStream backgroundImage = null;
        try {
            MapLoader.BackImage backImg = null;
            if (!"map20180808_china".equals(ref.getRefToId())) {
                backgroundImage = MapLoader.loadBackImage(ref);
                backImg = MapLoader.loadBackImageDescription(ref);
            }
            mapGenerator.writeImg(this.width, this.height, this.sqViewAdapter.getChartModel(), chartProperty, exportFile, this.imageType, backgroundImage, backImg);
        }
        catch (MapLoader.MapNotFoundException e) {
            String message = Messages.getLangMessage(this.ii18nContext, "mapNotFound", "\u5730\u56fe\u6a21\u677f\u4e0d\u5b58\u5728");
            this.drawDataEmptyImg(exportFile, message);
            CloseUtil.close((Closeable[])new Closeable[]{backgroundImage});
        }
        catch (MapLoader.MapLoaderException e2) {
            throw new ExportException(e2);
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{backgroundImage});
                    throw throwable;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{backgroundImage});
    }

    private void drawGraphicsImg(IQingFile exportFile) throws ExportException {
        BufferedImage image = new BufferedImage(this.width, this.height, this.getBufferedImageType());
        IChartDrawable renderer = ChartRendererFactory.getRenderer(this.sqViewAdapter.getChartType());
        Graphics2D mainGraphics = this.getGraphics(image);
        renderer.draw(this.width, this.height, mainGraphics, this.sqViewAdapter.getChartModel(), this.sqViewAdapter.getProperty());
        this.writeImg(image, exportFile);
        mainGraphics.dispose();
    }

    private Graphics2D getGraphics(BufferedImage image) {
        Graphics2D mainGraphics = (Graphics2D)image.getGraphics();
        mainGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        mainGraphics.setBackground(this.backgroundColor);
        mainGraphics.setColor(this.backgroundColor);
        mainGraphics.fillRect(0, 0, this.width, this.height);
        ExFont exFont = this.sqViewAdapter.getFont();
        float fontSize = (float)exFont.getFontSize() * UnitUtil.getCurrentDpi() / 72.0f;
        mainGraphics.setFont(ExFont.getDefaultAwtFont().deriveFont(fontSize));
        return mainGraphics;
    }

    private void drawGISImg(IQingFile exportFile) throws ExportException {
        ChartImgGeneratorForGIS chartImgGeneratorForGIS = new ChartImgGeneratorForGIS();
        chartImgGeneratorForGIS.writeImg(exportFile);
    }
}

