/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf.comp;

import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForLegend;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.model.ExBorder;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.export.common.model.RowColRange;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.TableViewExportPagination;
import com.kingdee.bos.qing.export.pdf.comp.BasicPainter;
import com.kingdee.bos.qing.export.pdf.model.DimensionFloat;
import com.kingdee.bos.qing.util.LogUtil;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PageBody
extends BasicPainter {
    private int pageIndex;
    private List<RowColRange> listPageScope;
    private float topHeadHeight;
    private float leftHeadWidth;
    private List<String> diagonalTitles;
    private float scale;
    private float legendGapPT;
    private static final Color borderColor = new ExBorder().getBorderColor();

    public PageBody(TableViewExportJob exportJob, List<RowColRange> scopes) {
        super(exportJob);
        this.listPageScope = scopes;
        this.diagonalTitles = this.getTableAdapter().getDiagonalTitles();
        this.scale = this.model.getScaleModel().getScale();
        this.legendGapPT = UnitUtil.pixelToPt(this.tableAdapter.getLegendGap()) * this.scale;
    }

    @Override
    public List<ColumnText> createContent(PdfContentByte pdfContentByte) throws DocumentException {
        ArrayList<ColumnText> cts = new ArrayList<ColumnText>();
        if (this.listPageScope == null || this.listPageScope.isEmpty()) {
            return cts;
        }
        float x = this.getX();
        float y = 0.0f;
        float lly = this.getHeight() + this.getY();
        DimensionFloat dimen = null;
        for (int i = 0; i < this.listPageScope.size(); ++i) {
            float upRightY;
            float lowRightY;
            float lowRightX;
            float lowLeftX;
            RowColRange rowColPage = this.listPageScope.get(i);
            PdfPTable table = this.createPdfPTable(rowColPage);
            ColumnText ct = new ColumnText(pdfContentByte);
            if (dimen == null) {
                dimen = this.getRowColDimension(rowColPage);
                ct.setSimpleColumn(x, lly, x + dimen.getWidth(), lly - dimen.getHeight());
                lowLeftX = x;
                lowRightX = x + dimen.getWidth();
                lowRightY = lly;
                upRightY = lly - dimen.getHeight();
            } else if (this.model.isHFrugal()) {
                dimen = this.getRowColDimension(rowColPage);
                ct.setSimpleColumn(x += dimen.getWidth() + 5.0f, lly, x + dimen.getWidth(), this.getY());
                lowLeftX = x;
                lowRightX = x + dimen.getWidth();
                lowRightY = lly;
                upRightY = this.getY();
            } else {
                dimen = this.getRowColDimension(rowColPage);
                ct.setSimpleColumn(x, lly - (y += dimen.getHeight() + 5.0f), x + dimen.getWidth(), this.getY());
                lowLeftX = x;
                lowRightX = x + dimen.getWidth();
                lowRightY = lly - y;
                upRightY = this.getY();
            }
            ct.addElement((Element)table);
            cts.add(ct);
            if (this.pageIndex != this.exportJob.getPageCount() - 1 || this.exportJob.isLegendInOnePage() || this.tableAdapter.getLegendNumber() <= 0) continue;
            this.addLegends(cts, pdfContentByte, lowLeftX, lowRightX, lowRightY, upRightY);
        }
        return cts;
    }

    @Override
    public List<ColumnText> createContentOfLengend(PdfContentByte pdfContentByte) throws DocumentException {
        ArrayList<ColumnText> cts = new ArrayList<ColumnText>();
        if (this.tableAdapter.getLegendNumber() > 0) {
            float x = this.getX();
            float lly = this.getHeight() + this.getY();
            float lowLeftX = x;
            float lowRightX = x;
            float lowRightY = lly;
            float upRightY = this.getY();
            this.addLegends(cts, pdfContentByte, lowLeftX, lowRightX, lowRightY, upRightY);
        }
        return cts;
    }

    private PdfPTable createPdfPTable(RowColRange rowColPage) throws DocumentException {
        int colCount = rowColPage.getToCol() - rowColPage.getFromCol() + 1;
        PdfPTable table = new PdfPTable(colCount);
        table.setLockedWidth(true);
        float[] totalWidth = new float[colCount];
        for (int i = 0; i < colCount; ++i) {
            totalWidth[i] = this.getColWidth(rowColPage.getFromCol() + i);
        }
        table.setTotalWidth(totalWidth);
        int rowEnd = rowColPage.getToRow();
        int colEnd = rowColPage.getToCol();
        ArrayList<RowColRange> listMergeRange = new ArrayList<RowColRange>();
        this.addTopHeadCell(table, rowColPage, listMergeRange, totalWidth, colCount);
        for (int r = rowColPage.getFromRow(); r <= rowEnd; ++r) {
            this.addLeftHeadCell(table, rowColPage, listMergeRange, totalWidth, colCount, r);
            for (int c = rowColPage.getFromCol(); c <= colEnd; ++c) {
                boolean isColEnd;
                boolean isColStart;
                boolean isRowEnd;
                boolean isRowStart = r == rowColPage.getFromRow();
                PdfPCell cell = this.createPdfPCell(r, c, listMergeRange, isRowStart, isRowEnd = r == rowEnd, isColStart = c == rowColPage.getFromCol(), isColEnd = c == colEnd, colEnd);
                if (cell == null) continue;
                table.addCell(cell);
            }
        }
        for (RowColRange mergeRange : listMergeRange) {
            RowColRange newMergeRange = new RowColRange(mergeRange);
            if (mergeRange.getToRow() >= rowEnd + 1) {
                newMergeRange.setFromRow(mergeRange.getFromRow());
                newMergeRange.setToRow(rowEnd);
                mergeRange.setFromRow(rowEnd + 1);
            }
            if (mergeRange.getToCol() >= colEnd + 1) {
                newMergeRange.setFromCol(mergeRange.getFromCol());
                newMergeRange.setToCol(colEnd);
                mergeRange.setFromCol(colEnd + 1);
            }
            if (!this.isValid(newMergeRange) || newMergeRange.equals(mergeRange) || !this.tableAdapter.isTopHeaderAll() && !this.tableAdapter.isLeftHeaderAll()) continue;
            this.getTableAdapter().getMergeRanges().add(newMergeRange);
        }
        return table;
    }

    private PdfPTable createTableOfLengend(float totalWidth) throws DocumentException {
        int colCount = 1;
        PdfPTable table = new PdfPTable(colCount);
        table.setLockedWidth(true);
        float[] totalWidths = new float[]{totalWidth};
        table.setTotalWidth(totalWidths);
        return table;
    }

    private boolean isValid(RowColRange range) {
        return range.getFromCol() < range.getToCol() || range.getFromRow() < range.getToRow();
    }

    private PdfPCell createPdfPCell(int r, int c, List<RowColRange> listMergeRange, boolean isRowStart, boolean isRowEnd, boolean isColStart, boolean isColEnd, int colEndIndex) {
        boolean isFirstMergeCell = false;
        PdfPCell cell = new PdfPCell();
        int mergeColNumber = 1;
        RowColRange mergeRange = this.getCellMergeRange(r, c);
        if (mergeRange != null) {
            isFirstMergeCell = this.isFirstMergeCell(mergeRange, r, c);
            if (isFirstMergeCell) {
                mergeColNumber = (mergeRange.getToCol() < colEndIndex ? mergeRange.getToCol() : colEndIndex) - mergeRange.getFromCol() + 1;
                cell.setRowspan(mergeRange.getToRow() - mergeRange.getFromRow() + 1);
                cell.setColspan(mergeRange.getToCol() - mergeRange.getFromCol() + 1);
                listMergeRange.add(mergeRange);
            } else {
                return null;
            }
        }
        if (r == 0 && c == 0 && this.diagonalTitles != null && !this.diagonalTitles.isEmpty()) {
            cell.setCellEvent((PdfPCellEvent)this.exportJob.getDiagonalCellEvent());
            isColEnd = true;
            isRowEnd = true;
            this.setCellStyle(cell, this.getTableAdapter().styleAt(r, c), isRowStart, isRowEnd, isColStart, isColEnd);
        } else {
            this.setCellContent(r, c, cell);
            this.setCellStyle(cell, this.getTableAdapter().styleAt(r, c), isRowStart, isRowEnd, isColStart, isColEnd);
            this.fitCellHandle(cell, this.getColWidth(c, mergeColNumber));
        }
        float rowHeight = this.getRowHeight(isFirstMergeCell, isColEnd, cell, r);
        cell.setFixedHeight(rowHeight - 1.0E-4f);
        return cell;
    }

    private void setCellContent(int row, int col, PdfPCell cell) {
        cell.setCellEvent((PdfPCellEvent)new ChartCellEvent(row, col, this.tableAdapter.styleAt(row, col)));
    }

    private float getRowHeight(boolean isFirstMergeCell, boolean isColEnd, PdfPCell cell, int row) {
        float rowHeight = 0.0f;
        if (isFirstMergeCell && isColEnd) {
            for (int i = row; i < row + cell.getRowspan(); ++i) {
                if (!((rowHeight += this.getRowHeight(i)) > this.getHeight())) continue;
                rowHeight = this.getHeight();
                break;
            }
        } else {
            rowHeight = this.getRowHeight(row);
        }
        return rowHeight;
    }

    private void setCellStyle(PdfPCell cell, ExStyle style, boolean isRowStart, boolean isRowEnd, boolean isColStart, boolean isColEnd) {
        cell.setNoWrap(style.isNoWrap());
        if (style.getBackgroundColor() != null) {
            cell.setBackgroundColor(style.getBackgroundColor());
        }
        if (style.getForegroundColor() != null && cell.getPhrase() != null) {
            Font font = new Font(cell.getPhrase().getFont());
            font.setColor(style.getForegroundColor());
            ArrayList chunks = cell.getPhrase().getChunks();
            for (Element chunk : chunks) {
                ((Chunk)chunk).setFont(font);
            }
        }
        cell.setPaddingTop(cell.getPaddingTop() * this.scale);
        cell.setPaddingBottom(cell.getPaddingBottom() * this.scale);
        cell.setPaddingLeft(cell.getPaddingLeft() * this.scale);
        cell.setPaddingRight(cell.getPaddingRight() * this.scale);
        cell.setVerticalAlignment(this.transferAlign(style.getVerticalAlignment()));
        cell.setHorizontalAlignment(this.transferAlign(style.getHorizontalAlignment()));
        ExBorder border = style.getBorderLeft();
        if (border == null) {
            if (isColStart && !this.tableAdapter.isLeftHeaderAll()) {
                border = new ExBorder();
                cell.setBorderWidthLeft((float)border.getBorderWidth() / 2.0f * this.scale);
                cell.setBorderColorLeft(borderColor);
            } else {
                cell.setBorderWidthLeft(0.0f);
            }
        } else {
            cell.setBorderWidthLeft((float)border.getBorderWidth() / 2.0f * this.scale);
            cell.setBorderColorLeft(borderColor);
        }
        border = style.getBorderRight();
        if (style.getBorderRight() == null) {
            if (isColEnd) {
                border = new ExBorder();
                cell.setBorderWidthRight((float)border.getBorderWidth() / 2.0f * this.scale);
                cell.setBorderColorRight(borderColor);
            } else {
                cell.setBorderWidthRight(0.0f);
            }
        } else {
            cell.setBorderWidthRight((float)border.getBorderWidth() / 2.0f * this.scale);
            cell.setBorderColorRight(borderColor);
        }
        border = style.getBorderTop();
        if (style.getBorderTop() == null) {
            if (isRowStart && !this.tableAdapter.isTopHeaderAll()) {
                border = new ExBorder();
                cell.setBorderWidthTop((float)border.getBorderWidth() / 2.0f * this.scale);
                cell.setBorderColorTop(borderColor);
            } else {
                cell.setBorderWidthTop(0.0f);
            }
        } else {
            cell.setBorderWidthTop((float)border.getBorderWidth() / 2.0f * this.scale);
            cell.setBorderColorTop(borderColor);
        }
        border = style.getBorderBottom();
        if (style.getBorderBottom() == null) {
            if (isRowEnd) {
                border = new ExBorder();
                cell.setBorderWidthBottom((float)border.getBorderWidth() / 2.0f * this.scale);
                cell.setBorderColorBottom(borderColor);
            } else {
                cell.setBorderWidthBottom(0.0f);
            }
        } else {
            cell.setBorderWidthBottom((float)border.getBorderWidth() / 2.0f * this.scale);
            cell.setBorderColorBottom(borderColor);
        }
    }

    private boolean isFirstMergeCell(RowColRange mergeRange, int row, int col) {
        if (mergeRange == null) {
            return false;
        }
        return row == mergeRange.getFromRow() && col == mergeRange.getFromCol();
    }

    private RowColRange getCellMergeRange(int row, int col) {
        List<RowColRange> mergeRanges = this.getTableAdapter().getMergeRanges();
        if (mergeRanges == null) {
            return null;
        }
        for (RowColRange range : mergeRanges) {
            if (row < range.getFromRow() || row > range.getToRow() || col < range.getFromCol() || col > range.getToCol()) continue;
            return range;
        }
        return null;
    }

    private DimensionFloat getRowColDimension(RowColRange rowColPage) {
        int i;
        if (this.topHeadHeight == 0.0f) {
            this.topHeadHeight = TableViewExportPagination.handleTopHeadAll(this.tableAdapter, this.getHeight(), rowColPage.getFromRow());
            this.topHeadHeight *= this.scale;
        }
        if (this.leftHeadWidth == 0.0f) {
            this.leftHeadWidth = TableViewExportPagination.handleLeftHeadAll(this.tableAdapter, this.getWidth(), rowColPage.getFromCol());
            this.leftHeadWidth *= this.scale;
        }
        float h = 0.0f;
        float w = 0.0f;
        for (i = rowColPage.getFromRow(); i <= rowColPage.getToRow(); ++i) {
            h += this.getRowHeightOrColumnWidth(i, true);
        }
        for (i = rowColPage.getFromCol(); i <= rowColPage.getToCol(); ++i) {
            w += this.getRowHeightOrColumnWidth(i, false);
        }
        return new DimensionFloat(w + this.leftHeadWidth, h + this.topHeadHeight);
    }

    private float getRowHeightOrColumnWidth(int index, boolean isRow) {
        if (isRow) {
            return this.getRowHeight(index);
        }
        return this.getColWidth(index);
    }

    private float getRowHeight(int row) {
        float height;
        int h = this.getTableAdapter().getRowHeight(row);
        if (h < 0) {
            h = 0;
        }
        if ((height = UnitUtil.pixelToPt(h) * this.scale) > this.getHeight()) {
            height = this.getHeight();
        }
        return height;
    }

    private float getColWidth(int col) {
        float width;
        int w = this.getTableAdapter().getColWidth(col);
        if (w < 0) {
            w = 0;
        }
        if ((width = UnitUtil.pixelToPt(w) * this.scale) > this.getWidth()) {
            width = this.getWidth();
        }
        return width;
    }

    private float getColWidth(int colIndex, int mergeColNumber) {
        float width = this.getColWidth(colIndex);
        return width * (float)mergeColNumber;
    }

    private void fitCellHandle(PdfPCell cell, float cellWidth) {
        if (cell.getPhrase() == null) {
            return;
        }
        Phrase phrase = cell.getPhrase();
        Chunk chunk = (Chunk)phrase.getChunks().get(0);
        if (cell.isNoWrap() && cell.getPaddingLeft() + chunk.getWidthPoint() > cellWidth) {
            cell.setPhrase(null);
            cell.setCellEvent((PdfPCellEvent)new FitCellEvent(phrase));
        }
    }

    private void addTopHeadCell(PdfPTable table, RowColRange rowColPage, List<RowColRange> listMergeRange, float[] totalWidth, int colCount) throws DocumentException {
        if (this.tableAdapter.isTopHeaderAll() && rowColPage.getFromRow() >= this.tableAdapter.getTopHeadRowCount()) {
            for (int r = 0; r < this.tableAdapter.getTopHeadRowCount(); ++r) {
                PdfPCell cell;
                int c;
                if (this.tableAdapter.isLeftHeaderAll() && rowColPage.getFromCol() >= this.tableAdapter.getLeftHeadColCount() && r == 0) {
                    this.resetColumnCount(colCount, totalWidth, table);
                    for (c = 0; c < this.tableAdapter.getLeftHeadColCount(); ++c) {
                        cell = this.createPdfPCell(r, c, listMergeRange, false, false, false, false, rowColPage.getToCol());
                        if (cell == null) continue;
                        table.addCell(cell);
                    }
                }
                for (c = rowColPage.getFromCol(); c <= rowColPage.getToCol(); ++c) {
                    boolean isColEnd = c == rowColPage.getToCol();
                    cell = this.createPdfPCell(r, c, listMergeRange, false, false, false, isColEnd, rowColPage.getToCol());
                    if (cell == null) continue;
                    table.addCell(cell);
                }
            }
        }
    }

    private void addLeftHeadCell(PdfPTable table, RowColRange rowColPage, List<RowColRange> listMergeRange, float[] totalWidth, int colCount, int row) throws DocumentException {
        if (this.tableAdapter.isLeftHeaderAll() && rowColPage.getFromCol() >= this.tableAdapter.getLeftHeadColCount()) {
            if (!(this.tableAdapter.isTopHeaderAll() && rowColPage.getFromRow() >= this.tableAdapter.getTopHeadRowCount() || row != rowColPage.getFromRow())) {
                this.resetColumnCount(colCount, totalWidth, table);
            }
            for (int c = 0; c < this.tableAdapter.getLeftHeadColCount(); ++c) {
                boolean isRowEnd;
                boolean isRowStart = row == rowColPage.getFromRow();
                PdfPCell cell = this.createPdfPCell(row, c, listMergeRange, isRowStart, isRowEnd = row == rowColPage.getToRow(), false, false, rowColPage.getToCol());
                if (cell == null) continue;
                table.addCell(cell);
            }
        }
    }

    private void addLegends(ArrayList<ColumnText> cts, PdfContentByte pdfContentByte, float leftX, float rightX, float lowY, float upY) throws DocumentException {
        float startX;
        float tmp;
        if (this.tableAdapter.getLegendNumber() < 1) {
            return;
        }
        if (leftX > rightX) {
            tmp = leftX;
            leftX = rightX;
            rightX = tmp;
        }
        if (lowY > upY) {
            tmp = lowY;
            lowY = upY;
            upY = tmp;
        }
        if (this.exportJob.isLegendInOneCol()) {
            startX = rightX;
            float startY = upY;
            this.addVerticalLegends(cts, pdfContentByte, startX + this.legendGapPT, startY);
        } else {
            startX = rightX;
            float startY = upY;
            this.addHorizontalLegends(cts, pdfContentByte, startX + this.legendGapPT, startY);
        }
    }

    private void addVerticalLegends(ArrayList<ColumnText> cts, PdfContentByte pdfContentByte, float startX, float startY) throws DocumentException {
        float legendWidthPT = UnitUtil.pixelToPt(this.tableAdapter.getVerticalLegendWidth()) * this.scale;
        float legendHeightPT = UnitUtil.pixelToPt(this.tableAdapter.getVerticalLegendHeight()) * this.scale;
        PdfPCell cell = new PdfPCell();
        ExStyle style = this.tableAdapter.getLengendStyle();
        this.setCellStyle(cell, style, false, false, false, false);
        cell.setCellEvent((PdfPCellEvent)new LegendCellEvent(true));
        cell.setFixedHeight(legendHeightPT - 0.01f);
        PdfPTable table = this.createTableOfLengend(legendWidthPT);
        table.addCell(cell);
        ColumnText ct = new ColumnText(pdfContentByte);
        ct.setSimpleColumn(startX, startY, startX + legendWidthPT, startY - legendHeightPT);
        ct.addElement((Element)table);
        cts.add(ct);
    }

    private void addHorizontalLegends(ArrayList<ColumnText> cts, PdfContentByte pdfContentByte, float startX, float startY) throws DocumentException {
        float legendWidthPT = UnitUtil.pixelToPt(this.tableAdapter.getHorizontalLegendWidth()) * this.scale;
        float legendHeightPT = UnitUtil.pixelToPt(this.tableAdapter.getHorizontalLegendHeight()) * this.scale;
        PdfPCell cell = new PdfPCell();
        ExStyle style = this.tableAdapter.getLengendStyle();
        this.setCellStyle(cell, style, false, false, false, false);
        cell.setCellEvent((PdfPCellEvent)new LegendCellEvent(false));
        cell.setFixedHeight(legendHeightPT - 0.01f);
        PdfPTable table = this.createTableOfLengend(legendWidthPT);
        table.addCell(cell);
        ColumnText ct = new ColumnText(pdfContentByte);
        ct.setSimpleColumn(startX, startY, startX + legendWidthPT, startY - legendHeightPT);
        ct.addElement((Element)table);
        cts.add(ct);
    }

    private void resetColumnCount(int colCount, float[] totalWidth, PdfPTable table) throws DocumentException {
        int i;
        int headCount = this.tableAdapter.getLeftHeadColCount();
        float[] allWidth = new float[colCount + headCount];
        for (i = 0; i < headCount; ++i) {
            allWidth[i] = this.getColWidth(i);
        }
        for (i = headCount; i < allWidth.length; ++i) {
            allWidth[i] = totalWidth[i - headCount];
        }
        table.setTotalWidth(allWidth);
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    class LegendCellEvent
    implements PdfPCellEvent {
        private boolean isVerticalAlign;

        public LegendCellEvent(boolean isVerticalAlign) {
            this.isVerticalAlign = isVerticalAlign;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            PdfContentByte canvas = canvases[1];
            float scale = PageBody.this.model.getScaleModel().getScale();
            PdfTemplate chartTemplate = canvas.createTemplate(position.getWidth(), position.getHeight());
            PdfGraphics2D graphics2d = new PdfGraphics2D((PdfContentByte)chartTemplate, position.getWidth(), position.getHeight(), (FontMapper)TableViewExportJob.getFontMapper(), false, false, 0.0f);
            graphics2d.setFont(PageBody.this.getAwtFont());
            LogUtil.info((String)PageBody.this.getAwtFont().toString());
            double scaleRate = 72.0f / UnitUtil.getCurrentDpi() * scale;
            graphics2d.scale(scaleRate, scaleRate);
            try {
                this.drawLegendOnGraphics((Graphics2D)graphics2d, 0, 0, this.isVerticalAlign);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            finally {
                graphics2d.dispose();
            }
            try {
                canvas.getPdfWriter().releaseTemplate(chartTemplate);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            canvas.addTemplate(chartTemplate, position.getLeft(), position.getBottom());
        }

        private void drawLegendOnGraphics(Graphics2D mainGraphics, int startX, int startY, boolean isVerticalAlign) throws ExportJavaScriptException {
            CellRendererForLegend.LegendRenderParameter parameter = PageBody.this.getTableAdapter().getLegendRenderParameter();
            parameter.setMainGraphics(mainGraphics);
            parameter.setStartX(startX);
            parameter.setStartY(startY);
            CellRendererForLegend render = new CellRendererForLegend();
            if (isVerticalAlign) {
                render.drawVerticalLegends(parameter);
            } else {
                render.drawHorizontalLegends(parameter);
            }
        }
    }

    class ChartCellEvent
    implements PdfPCellEvent {
        private int row;
        private int col;
        private ExStyle style;

        public ChartCellEvent(int row, int col, ExStyle style) {
            this.row = row;
            this.col = col;
            this.style = style;
        }

        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            PdfContentByte canvas = canvases[1];
            float scale = PageBody.this.model.getScaleModel().getScale();
            PdfTemplate chartTemplate = canvas.createTemplate(position.getWidth(), position.getHeight());
            PdfGraphics2D graphics2d = new PdfGraphics2D((PdfContentByte)chartTemplate, position.getWidth(), position.getHeight(), (FontMapper)TableViewExportJob.getFontMapper(), false, false, 0.0f);
            graphics2d.setFont(this.style.getExFont().toAwtFont());
            double scaleRate = 72.0f / UnitUtil.getCurrentDpi() * scale;
            graphics2d.scale(scaleRate, scaleRate);
            this.style.setWidth((int)((double)position.getWidth() / scaleRate));
            this.style.setHeight((int)((double)position.getHeight() / scaleRate));
            PageBody.this.getTableAdapter().drawCell(this.row, this.col, this.style, (Graphics)graphics2d);
            graphics2d.dispose();
            try {
                canvas.getPdfWriter().releaseTemplate(chartTemplate);
            }
            catch (IOException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            canvas.addTemplate(chartTemplate, position.getLeft(), position.getBottom());
        }
    }

    class FitCellEvent
    implements PdfPCellEvent {
        private Phrase phrase;

        public FitCellEvent(Phrase phrase) {
            this.phrase = phrase;
        }

        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            PdfContentByte canvas = canvases[3];
            PdfTemplate template = canvas.createTemplate(position.getWidth() - 0.5f, position.getHeight());
            ColumnText ct = new ColumnText((PdfContentByte)template);
            Chunk ck = (Chunk)this.phrase.getChunks().get(0);
            float width = ck.getWidthPoint() + cell.getPaddingLeft() + 10.0f;
            float height = (position.getHeight() + PageBody.this.getTextHeight(ck.getContent())) / 2.0f + 6.0f * PageBody.this.scale;
            ct.setSimpleColumn(cell.getPaddingLeft(), 0.0f, width, height);
            ct.addElement((Element)this.phrase);
            try {
                ct.go();
            }
            catch (DocumentException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            canvas.addTemplate(template, position.getLeft(), position.getBottom());
            try {
                canvas.getPdfWriter().releaseTemplate(template);
            }
            catch (IOException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }
}

