/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.builder;

import com.kingdee.bos.qing.map.designer.model.AreaOutputStyle;
import com.kingdee.bos.qing.map.designer.model.DesigntimeMapModel;
import com.kingdee.bos.qing.map.designer.model.Layer;
import com.kingdee.bos.qing.map.designer.model.Page;
import com.kingdee.bos.qing.map.designer.model.Path;
import com.kingdee.bos.qing.map.designer.model.Point;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class MapBuilder {
    private float _scaled = 100.0f;

    public Element buildSvg(DesigntimeMapModel model) {
        Page page = model.getPage();
        Element svgRoot = new Element("svg");
        svgRoot.setAttribute("viewBox", "0,0," + page.getWidth() + "," + page.getHeight());
        svgRoot.setAttribute("width", "100%");
        svgRoot.setAttribute("height", "100%");
        String cssClassName = "qing-map-" + System.currentTimeMillis();
        svgRoot.addContent((Content)this.buildStyles(page, cssClassName));
        svgRoot.addContent((Content)this.buildAreas(page, cssClassName));
        return svgRoot;
    }

    private Element buildStyles(Page page, String cssClassName) {
        AreaOutputStyle commonStyle = page.getOutputConfig().getCommonStyle();
        ArrayList<String[]> styleList = new ArrayList<String[]>();
        this.prepareFillStyle(commonStyle.getFillColor(), commonStyle.getFillOpacity(), styleList, true);
        this.prepareBorderStyle(commonStyle.getBorderColor(), commonStyle.getBorderOpacity(), styleList);
        ArrayList<String[]> hoverStyleList = new ArrayList<String[]>();
        this.prepareFillStyle(commonStyle.getHoverFillColor(), commonStyle.getHoverFillOpacity(), hoverStyleList, false);
        this.prepareBorderStyle(commonStyle.getHoverBorderColor(), commonStyle.getHoverBorderOpacity(), hoverStyleList);
        Element svgStyle = new Element("style");
        svgStyle.setAttribute("type", "text/css");
        svgStyle.setText(this.buildStyle(cssClassName, styleList) + this.buildStyle(cssClassName + ":hover", hoverStyleList));
        Element svgDefs = new Element("defs");
        svgDefs.addContent((Content)svgStyle);
        return svgDefs;
    }

    private Element buildAreas(Page page, String cssClassName) {
        Element svgAllPath = new Element("g");
        int c = page.getLayersCount();
        for (int i = 0; i < c; ++i) {
            Layer layer = page.getLayer(i);
            svgAllPath.addContent((Content)this.buildArea(layer, cssClassName));
        }
        return svgAllPath;
    }

    private Element buildArea(Layer layer, String cssClassName) {
        Element svgPath = new Element("path");
        svgPath.setAttribute("name", layer.getId());
        svgPath.setAttribute("title", layer.getName());
        svgPath.setAttribute("class", cssClassName);
        svgPath.setAttribute("d", this.buildAreaPaths(layer));
        return svgPath;
    }

    private String buildAreaPaths(Layer layer) {
        StringBuilder sb = new StringBuilder();
        int c = layer.getPathsCount();
        for (int i = 0; i < c; ++i) {
            Path path = layer.getPath(i);
            if (!path.isClosed() || path.getPointsCount() <= 2) continue;
            this.buildOneClosedPath(path, sb);
        }
        return sb.toString();
    }

    private void buildOneClosedPath(Path path, StringBuilder sb) {
        sb.append('M');
        this.buildCoordinate(path.getPoint(0), sb);
        int c = path.getPointsCount();
        for (int i = 1; i < c; ++i) {
            sb.append('L');
            this.buildCoordinate(path.getPoint(i), sb);
        }
        sb.append('Z');
    }

    private void buildCoordinate(Point point, StringBuilder sb) {
        sb.append((float)point.getX() / this._scaled);
        sb.append(',');
        sb.append((float)point.getY() / this._scaled);
    }

    private void prepareFillStyle(String fillColor, int hundredOpacity, List<String[]> list, boolean mustBeNotNull) {
        if (fillColor != null) {
            list.add(new String[]{"fill", fillColor});
            list.add(new String[]{"fill-opacity", String.valueOf((float)hundredOpacity / 100.0f)});
        } else if (mustBeNotNull) {
            list.add(new String[]{"fill-opacity", "0"});
        }
    }

    private void prepareBorderStyle(String borderColor, int hundredOpacity, List<String[]> list) {
        if (borderColor != null) {
            list.add(new String[]{"stroke", borderColor});
            list.add(new String[]{"stroke-opacity", String.valueOf((float)hundredOpacity / 100.0f)});
            list.add(new String[]{"stroke-width", "1"});
        }
    }

    private String buildStyle(String cssClassName, List<String[]> styleList) {
        StringBuilder sb = new StringBuilder();
        this.newLine(sb);
        sb.append('.');
        sb.append(cssClassName);
        this.newLine(sb);
        sb.append('{');
        this.newLine(sb);
        for (String[] item : styleList) {
            sb.append('\t');
            sb.append(item[0]);
            sb.append(": ");
            sb.append(item[1]);
            sb.append(';');
            this.newLine(sb);
        }
        sb.append('}');
        this.newLine(sb);
        return sb.toString();
    }

    private void newLine(StringBuilder sb) {
        sb.append("\r\n");
    }
}

