/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.designer.model;

import com.kingdee.bos.qing.map.designer.exception.PersistentModelParseException;
import com.kingdee.bos.qing.map.designer.model.Layer;
import com.kingdee.bos.qing.map.designer.model.OutputConfig;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class Page {
    private int width;
    private int height;
    private OutputConfig config;
    private List<Layer> layers;
    private String backImage;

    public void setBackImageId(String imgId) {
        this.backImage = imgId;
    }

    public String getBackImageId() {
        return this.backImage;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public OutputConfig getOutputConfig() {
        if (this.config == null) {
            this.config = new OutputConfig();
        }
        return this.config;
    }

    public int getLayersCount() {
        return this.layers == null ? 0 : this.layers.size();
    }

    public Layer getLayer(int idx) {
        return this.layers.get(idx);
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrInt((Element)node, (String)"width", (int)this.width);
        XmlUtil.writeAttrInt((Element)node, (String)"height", (int)this.height);
        Element nodeConfig = new Element("OutputConfig");
        this.getOutputConfig().toXml(nodeConfig);
        node.addContent((Content)nodeConfig);
        Element nodeLayers = new Element("Layers");
        int c = this.layers.size();
        for (int i = 0; i < c; ++i) {
            Layer layer = this.layers.get(i);
            Element nodeLayer = layer.toXml();
            nodeLayers.addContent((Content)nodeLayer);
        }
        node.addContent((Content)nodeLayers);
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodeLayers;
        try {
            this.width = XmlUtil.readAttrInt((Element)node, (String)"width");
            this.height = XmlUtil.readAttrInt((Element)node, (String)"height");
        }
        catch (XmlUtil.NullException ex) {
            throw PersistentModelParseException.createParseError(ex, "Attributes width/height be missing.");
        }
        Element nodeConfig = XmlUtil.getChild((Element)node, (String)"OutputConfig");
        this.getOutputConfig().fromXml(nodeConfig);
        try {
            nodeLayers = XmlUtil.getChildNotNull((Element)node, (String)"Layers");
        }
        catch (XmlUtil.NullException e) {
            throw PersistentModelParseException.createParseError(e, "<Layers> not found.");
        }
        List layerNodes = XmlUtil.getChildren((Element)nodeLayers);
        this.layers = new ArrayList<Layer>(layerNodes.size());
        int c = layerNodes.size();
        for (int i = 0; i < c; ++i) {
            Element nodeLayer = (Element)layerNodes.get(i);
            Layer layer = new Layer();
            layer.fromXml(nodeLayer);
            this.layers.add(layer);
        }
    }
}

