/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.designer.model;

import com.kingdee.bos.qing.map.designer.exception.PersistentModelParseException;
import com.kingdee.bos.qing.map.designer.model.Point;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class Path {
    private List<Point> points;
    private boolean closed;

    public Path() {
    }

    public Path(List<Point> points, boolean closed) {
        this.points = points;
        this.closed = closed;
    }

    public int getPointsCount() {
        return this.points == null ? 0 : this.points.size();
    }

    public Point getPoint(int idx) {
        return this.points.get(idx);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Element toXml() {
        Element node = new Element("Path");
        XmlUtil.writeAttrDefaultTrue((Element)node, (String)"closed", (boolean)this.closed);
        Element nodePoints = new Element("Points");
        int c = this.points.size();
        for (int i = 0; i < c; ++i) {
            Point point = this.points.get(i);
            nodePoints.addContent((Content)point.toXml());
        }
        node.addContent((Content)nodePoints);
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodePoints;
        this.closed = XmlUtil.readAttrDefaultTrue((Element)node, (String)"closed");
        try {
            nodePoints = XmlUtil.getChildNotNull((Element)node, (String)"Points");
        }
        catch (XmlUtil.NullException e) {
            throw PersistentModelParseException.createParseError("<Points> not found.");
        }
        List pointNodes = XmlUtil.getChildren((Element)nodePoints);
        this.points = new ArrayList<Point>(pointNodes.size());
        int c = pointNodes.size();
        for (int i = 0; i < c; ++i) {
            Element nodePoint = (Element)pointNodes.get(i);
            Point point = new Point();
            point.fromXml(nodePoint);
            this.points.add(point);
        }
    }
}

