/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.monitor;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.core.exception.ConfigCeilingException;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.monitor.IMemoryOccupant;
import com.kingdee.bos.qing.monitor.RuntimeMonitor;
import java.util.HashMap;
import java.util.Map;

public class Correspondent
implements ICorrespondent,
IMemoryOccupant {
    private String _tag;
    private int _id;
    private long[] _detailUsedBytes = new long[12];
    private long _usedBytes = 0L;
    private transient boolean _isStoppedByUser = false;
    private transient IMemoryOccupant.IBeggingListener _listener;

    public Correspondent(String tag) {
        this._tag = tag;
        this._id = (int)System.currentTimeMillis();
    }

    public int hashCode() {
        return this._tag.hashCode() * 31 + this._id;
    }

    public boolean equals(Object obj) {
        Correspondent another;
        return obj instanceof Correspondent && this._tag.equals((another = (Correspondent)obj).getTag()) && this._id == another._id;
    }

    public String toString() {
        return this._tag + "|" + this._id;
    }

    public String getTag() {
        return this._tag;
    }

    public void stopByUser() {
        this._isStoppedByUser = true;
    }

    @Override
    public void checkStoppedByUser() throws UserStoppedException {
        if (this._isStoppedByUser) {
            throw new UserStoppedException();
        }
        try {
            ServerRequestInvokeContext.staticCheckInterrupt();
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
    }

    @Override
    public void checkMoreThanMaxCubeCells(long currentCells) throws ConfigCeilingException {
        long max = RuntimeMonitor.getConfig().getMaxCubeCells();
        if (max <= 0L) {
            return;
        }
        if (currentCells > max) {
            throw ConfigCeilingException.createMaxCubeCells(max);
        }
    }

    @Override
    public void applyForMemory(int key, long bytes) throws EnvCeilingException {
        long oldSize = this._detailUsedBytes[key];
        long delta = bytes - oldSize;
        long oldAllSize = this._usedBytes;
        long newAllSize = this._usedBytes + delta;
        this.fireBeggingListener(oldAllSize, newAllSize);
        this._detailUsedBytes[key] = bytes;
        this._usedBytes = newAllSize;
    }

    @Override
    public void resetMalloc(int[] keys) throws EnvCeilingException {
        long oldAllSize = this._usedBytes;
        long delta = 0L;
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            delta += this._detailUsedBytes[key];
        }
        long newAllSize = oldAllSize - delta;
        this.fireBeggingListener(oldAllSize, newAllSize);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            this._detailUsedBytes[key] = 0L;
        }
        this._usedBytes = newAllSize;
    }

    @Override
    public long getUsedBytes() {
        return this._usedBytes;
    }

    @Override
    public void setBeggingListener(IMemoryOccupant.IBeggingListener listener) {
        this._listener = listener;
    }

    private void fireBeggingListener(long oldBytes, long newBytes) throws EnvCeilingException {
        IMemoryOccupant.Reply reply = this._listener.beg(oldBytes, newBytes);
        if (reply == HereYouAre) {
            return;
        }
        if (reply == TryAgain) {
            throw EnvCeilingException.createAbort(newBytes);
        }
        if (reply instanceof IMemoryOccupant.GiveUp) {
            long allUsable = ((IMemoryOccupant.GiveUp)reply).getUsableMemory();
            throw EnvCeilingException.createNoCapacity(newBytes, allUsable);
        }
        throw new RuntimeException("Unknown");
    }

    @Override
    public Map<String, Object> getPerformanceInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("all", this._usedBytes);
        map.put("detail", this._detailUsedBytes.clone());
        return map;
    }
}

