/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.service;

import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TraceSpansCacheUtil;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.dashboard.exception.FilterPreparedValueException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.cosmetic.CosmeticModel;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractCalendar;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.DashboardDomain;
import com.kingdee.bos.qing.domain.MetaDomain;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.service.Associate;
import com.kingdee.bos.qing.service.IDashboardService;
import com.kingdee.bos.qing.service.IExecutable;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDashboardService
extends BehaviorService
implements IDashboardService,
IExecutable {
    private AbstractDomain.IDataSourceCreator _dataSourceCreator;

    @Override
    public void setDataSourceCreator(AbstractDomain.IDataSourceCreator dsc) {
        this._dataSourceCreator = dsc;
    }

    private AbstractDomain.IDataSourceCreator getDataSourceCreator() {
        if (this._dataSourceCreator == null) {
            throw new RuntimeException("The implement of IDataSourceCreator must be appointed.");
        }
        return this._dataSourceCreator;
    }

    @Override
    @Associate(data=true)
    public final byte[] getWidgetBoundMeta(Map<String, String> params) {
        try {
            Meta meta = new MetaDomain(this.getDataSourceCreator()).getMeta();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)meta));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Associate(data=true)
    @LongTimeServiceMethodAnnotation
    public final byte[] getFilterPreparedValue(Map<String, String> params) {
        String typeName = params.get("formalizedType");
        String metaFieldFullName = params.get("metaFieldFullName");
        String displayMetaFieldFullName = params.get("displayMetaFieldFullName");
        String orderByMetaFieldFullName = params.get("orderByMetaFieldFullName");
        boolean isOrderByAsc = Boolean.parseBoolean(params.get("orderByAsc"));
        boolean isLightWeight = Boolean.parseBoolean(params.get("lightWeight"));
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)"\u83b7\u53d6\u7b5b\u9009\u5668\u7684\u5907\u9009\u503c");
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".getFilterPreparedValue");
            traceSpan.addAttribute("\u4f5c\u7528\u65b9\u5f0f", typeName);
            traceSpan.addAttribute("\u5b57\u6bb5", metaFieldFullName);
            AdditionalFilterDomain.AdditionalFilters additionalFilters = null;
            String additionalFiltersJsonString = params.get("additionalFilters");
            if (additionalFiltersJsonString != null) {
                additionalFilters = AdditionalFilterDomain.AdditionalFilters.decodeAdditionalFilters(additionalFiltersJsonString);
            }
            Meta meta = null;
            try {
                meta = new MetaDomain(this.getDataSourceCreator()).getMeta();
            }
            catch (Exception e) {
                byte[] byArray = ResponseUtil.output((Exception)e);
                TracerUtil.close((TraceSpan)traceSpan);
                TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
                return byArray;
            }
            Map<String, MetaField> metaFields = meta.createSearchingMap();
            MetaField valueMf = metaFields.get(metaFieldFullName);
            if (valueMf == null) {
                FilterPreparedValueException ex = new FilterPreparedValueException("MetaField [" + metaFieldFullName + "] not exist");
                byte[] byArray = ResponseUtil.output((Exception)((Object)ex));
                return byArray;
            }
            MetaField displayMf = displayMetaFieldFullName == null ? null : metaFields.get(displayMetaFieldFullName);
            MetaField orderByMf = orderByMetaFieldFullName == null ? null : metaFields.get(orderByMetaFieldFullName);
            try {
                DashboardDomain.FilterFormalizedType filterFormalizedType = DashboardDomain.FilterFormalizedType.valueOf(typeName);
                DashboardDomain domain = new DashboardDomain(this.getDataSourceCreator());
                AbstractPreparedValue pv = domain.getFilterPreparedValue(filterFormalizedType, valueMf, displayMf, orderByMf, isOrderByAsc, meta, additionalFilters, isLightWeight);
                byte[] byArray = ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)pv));
                return byArray;
            }
            catch (Exception e) {
                byte[] byArray = ResponseUtil.output((Exception)e);
                TracerUtil.close((TraceSpan)traceSpan);
                TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
                return byArray;
            }
        }
        finally {
            TracerUtil.close((TraceSpan)traceSpan);
            TraceSpansCacheUtil.appendToCacheLimitMax((TraceSpansCacheUtil.TraceSpansCacheTypeEnum)TraceSpansCacheUtil.TraceSpansCacheTypeEnum.EXECUTE, (TraceSpan)traceSpan, (boolean)false);
        }
    }

    @Override
    public final byte[] parseRelativePeriod(Map<String, String> params) {
        long end;
        long start;
        String part = params.get("part");
        String relativeModelJsonString = params.get("relative");
        if (part == null) {
            RelativeDateRange model = (RelativeDateRange)JsonUtil.decodeFromString((String)relativeModelJsonString, RelativeDateRange.class);
            RuntimeRelativeDateRange rt = new RuntimeRelativeDateRange(model);
            rt.parseRange();
            start = rt.getDateStart();
            end = rt.getDateEnd();
        } else {
            String p;
            if ("y".equalsIgnoreCase(part)) {
                p = "Y";
            } else if ("q".equalsIgnoreCase(part)) {
                p = "YQ";
            } else if ("m".equalsIgnoreCase(part)) {
                p = "YM";
            } else if ("d".equalsIgnoreCase(part)) {
                p = "YMD";
            } else {
                throw new RuntimeException("Unknown params value. part=" + part);
            }
            AbstractCalendar.SimpleRalative model = (AbstractCalendar.SimpleRalative)JsonUtil.decodeFromString((String)relativeModelJsonString, AbstractCalendar.SimpleRalative.class);
            long[] scope = AbstractCalendar.parseRange(model, p);
            start = scope[0];
            end = scope[1];
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("fromDate", start);
        result.put("toDate", end);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
    }

    @Override
    public final byte[] loadPresetCosmetic(Map<String, String> params) {
        String skin = params.get("skin");
        try {
            CosmeticModel cosmeticModel = CosmeticModel.loadPresetCosmetic(skin);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)cosmeticModel));
        }
        catch (PersistentModelParseException e) {
            return ResponseUtil.output((Exception)((Object)e));
        }
    }
}

