/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source;

import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.api.AbstractOpenAPISourceDomain;
import com.kingdee.bos.qing.data.domain.source.bizmeta.AbstractBizMetaSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.designtime.source.AbstractBizMetaSource;
import java.util.HashMap;
import java.util.Map;

public class SourceDomainFactory {
    private static Map<String, AbstractBizMetaSourceDomain> bizMetaSourceDomainImplMap = new HashMap<String, AbstractBizMetaSourceDomain>(16);

    public static <T extends AbstractBizMetaSourceDomain> void setBizMetaSourceDomainImp(String bizMetaType, T bizMetaSourceDomain) {
        bizMetaSourceDomainImplMap.put(bizMetaType, bizMetaSourceDomain);
    }

    private static AbstractBizMetaSourceDomain newBizMetaSourceDomainInstance(AbstractSource source) throws UnSupportDataSourceException {
        AbstractBizMetaSource bizMetaSource = (AbstractBizMetaSource)source;
        String bizMetaType = bizMetaSource.getBizMetaType();
        AbstractBizMetaSourceDomain bizMetaSourceDomain = bizMetaSourceDomainImplMap.get(bizMetaType);
        if (bizMetaSourceDomain == null) {
            throw new UnSupportDataSourceException("unsupport BizMetaType:" + bizMetaType);
        }
        return bizMetaSourceDomain;
    }

    public static AbstractBizMetaSourceDomain newBizMetaSourceDomainInstance(String bizMetaType) throws UnSupportDataSourceException {
        AbstractBizMetaSourceDomain bizMetaSourceDomain = bizMetaSourceDomainImplMap.get(bizMetaType);
        if (bizMetaSourceDomain == null) {
            throw new UnSupportDataSourceException("unsupport BizMetaType:" + bizMetaType);
        }
        return bizMetaSourceDomain;
    }

    public static AbstractDataSourceDomain getSourceDomain(AbstractSource source) throws UnSupportDataSourceException {
        if (source == null) {
            throw new UnSupportDataSourceException("sourceType null");
        }
        AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomainSilence(source);
        if (null == domain) {
            throw new UnSupportDataSourceException("unsupport sourceType:" + source.getType());
        }
        return domain;
    }

    public static AbstractDataSourceDomain getSourceDomainSilence(AbstractSource source) {
        try {
            SourceType sourceType = source.getType();
            AbstractDataSourceDomain sourceDomain = null;
            switch (sourceType) {
                case DB: {
                    sourceDomain = AbstractDBSourceDomain.newInstance(source);
                    break;
                }
                case File: {
                    sourceDomain = AbstractFileSourceDomain.newInstance(source);
                    break;
                }
                case BizMeta: {
                    sourceDomain = SourceDomainFactory.newBizMetaSourceDomainInstance(source);
                    break;
                }
                case OPENAPI: {
                    sourceDomain = AbstractOpenAPISourceDomain.newInstance(source);
                    break;
                }
            }
            if (null != sourceDomain) {
                return sourceDomain;
            }
            throw new UnSupportDataSourceException("");
        }
        catch (UnSupportDataSourceException e) {
            return null;
        }
    }
}

