/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.handler.impl.ColumnToRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.api.AbstractOpenAPISourceDomain;
import com.kingdee.bos.qing.data.domain.source.api.http.RESTfulHttp;
import com.kingdee.bos.qing.data.domain.source.api.parser.RESTfulHttpResultParseTool;
import com.kingdee.bos.qing.data.domain.source.api.parser.RESTfulResultParseTool;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLTranslateException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.RESTfulURLModel;
import com.kingdee.bos.qing.data.model.designtime.source.OpenAPISource;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StackTraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RESTfulDataSetSourceDomain
extends AbstractOpenAPISourceDomain {
    public static RESTfulDataSetSourceDomain newInstance() {
        return new RESTfulDataSetSourceDomain();
    }

    @Override
    public String openAPIInitialCheck(QingContext qingContext, AbstractSource source) throws OpenAPIException {
        RESTfulURLModel restfulURLModel = RESTfulURLModel.newInstance();
        restfulURLModel.checkValidity(source);
        restfulURLModel.checkConnectable(source);
        return null;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws OpenAPIException {
        RESTfulURLModel restfulURLModel = RESTfulURLModel.newInstance();
        restfulURLModel.checkValidity(source);
        String usableEntitiesURL = restfulURLModel.getUsableEntitiesURL();
        Map<String, String> headsMap = this.getRequestHead(source, usableEntitiesURL);
        String resultJsonStr = RESTfulHttp.post(qingContext, usableEntitiesURL, headsMap, null, true);
        return RESTfulResultParseTool.getUsableEntities(resultJsonStr, restfulURLModel);
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String associateName) throws OpenAPIException {
        RESTfulURLModel restfulURLModel = RESTfulURLModel.newInstance();
        restfulURLModel.checkValidity(source);
        String designtimeDataObjectUrl = restfulURLModel.getDesigntimeDataObjectURL(associateName);
        Map<String, String> headsMap = this.getRequestHead(source, designtimeDataObjectUrl);
        String resultJsonStr = RESTfulHttp.post(qingContext, designtimeDataObjectUrl, headsMap, null, true);
        return RESTfulResultParseTool.getDesigntimeDataObject(source.getName(), resultJsonStr, associateName);
    }

    @Override
    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws OpenAPIException {
        AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams = this.initRuntimeParams(runtimeEntity);
        if (runtimeParams == null) {
            return 0L;
        }
        RESTfulURLModel restfulURLModel = RESTfulURLModel.newInstance();
        restfulURLModel.checkValidity(runtimeEntity.getSource());
        long noFilterRowCount = this.getRowCount(runtimeEntity, restfulURLModel, qingContext);
        IRuntimeFilter pushdownableFilter = runtimeEntity.getPushdownableFilter();
        IRuntimeFilter unPushdownableFilter = runtimeEntity.getUnPushdownableFilter();
        List<ColumnToRowProperty> columnToRowProperties = runtimeEntity.getOrinalEntity().getColumnToRowProperties();
        Collection unionColumnToRowProperties = null;
        if (runtimeEntity.getEntityExtractContext() != null) {
            columnToRowProperties = runtimeEntity.getEntityExtractContext().getColumnToRowProperties();
        }
        if (CollectionUtils.isNotEmpty(unionColumnToRowProperties) || CollectionUtils.isNotEmpty(columnToRowProperties) || pushdownableFilter != null && !pushdownableFilter.isInvalid() || unPushdownableFilter != null && !unPushdownableFilter.isInvalid()) {
            return this.getHasFilterRowCount(noFilterRowCount, runtimeEntity, runtimeParams, restfulURLModel, qingContext);
        }
        return noFilterRowCount;
    }

    private long getHasFilterRowCount(long noFilterRowCount, RuntimeEntity runtimeEntity, AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams, RESTfulURLModel restfulURLModel, QingContext qingContext) throws OpenAPIException {
        long limit = restfulURLModel.getPageSize() == null ? 2000L : (long)restfulURLModel.getPageSize().intValue();
        long maxPageNumber = noFilterRowCount / limit + (long)(noFilterRowCount % limit == 0L ? 0 : 1);
        long hasFilterRowCount = 0L;
        String selectedFielsds = RESTfulDataSetSourceDomain.getSelectedFields(runtimeEntity);
        String extractDataUrl = restfulURLModel.getExtractDataUrl(runtimeEntity);
        int pageNumber = 1;
        while ((long)pageNumber <= maxPageNumber) {
            Map<String, Object> systemParams = RESTfulURLModel.getSystemParams(selectedFielsds, pageNumber, limit);
            Map<String, String> headsMap = this.getRequestHead(runtimeEntity.getSource(), extractDataUrl);
            String resultJsonStr = RESTfulHttp.post(qingContext, extractDataUrl, headsMap, systemParams, true);
            List<Object[]> data = RESTfulHttpResultParseTool.getData(resultJsonStr);
            for (Object[] objArr : data) {
                ColumnToRowDataHandler columnToRowdataHandler;
                List<Map<String, Object>> rowDataList;
                Map<String, Object> oneRowMap = this.getPriDataOneRowMap(objArr, runtimeEntity);
                if (oneRowMap == null || !CollectionUtils.isNotEmpty(rowDataList = (columnToRowdataHandler = new ColumnToRowDataHandler()).columnToRow(oneRowMap, runtimeEntity))) continue;
                for (Map<String, Object> rowMap : rowDataList) {
                    Map<String, Object> calculatedRowData;
                    Map<String, Object> innerFilterRowMap = this.innerExcuteFilterParam(runtimeParams, rowMap);
                    if (innerFilterRowMap == null || (calculatedRowData = RESTfulDataSetSourceDomain.getRowDataAfterCalculateAndFilter(innerFilterRowMap, runtimeEntity)) == null) continue;
                    ++hasFilterRowCount;
                }
            }
            ++pageNumber;
        }
        return hasFilterRowCount;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws OpenAPIException {
        RESTfulURLModel restfulURLModel = RESTfulURLModel.newInstance();
        restfulURLModel.checkValidity(runtimeEntity.getSource());
        String previewDataUrl = restfulURLModel.getPreviewDataUrl(runtimeEntity);
        String selectedFields = RESTfulDataSetSourceDomain.getSelectedFields(runtimeEntity);
        Long rowCount = this.getRowCount(runtimeEntity, restfulURLModel, qingContext);
        Integer limit = 2000;
        long maxPageNumber = rowCount / (long)limit.intValue() + (long)(rowCount % (long)limit.intValue() == 0L ? 0 : 1);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        try {
            int pageNumber = 1;
            while ((long)pageNumber <= maxPageNumber) {
                Map<String, Object> systemParams = RESTfulURLModel.getSystemParams(selectedFields, pageNumber, limit.intValue());
                Map<String, String> headsMap = this.getRequestHead(runtimeEntity.getSource(), previewDataUrl);
                String resultJsonStr = RESTfulHttp.post(qingContext, previewDataUrl, headsMap, systemParams, true);
                List<Object[]> httpData = RESTfulHttpResultParseTool.getData(resultJsonStr);
                AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams = this.initRuntimeParams(runtimeEntity);
                if (runtimeParams == null) {
                    return new PreviewDataModel(data);
                }
                block3: for (Object[] objArr : httpData) {
                    ColumnToRowDataHandler columnToRowdataHandler;
                    List<Map<String, Object>> rowDataList;
                    Map<String, Object> oneRowMap = this.getPriDataOneRowMap(objArr, runtimeEntity);
                    Map<String, Object> innerFilterRowMap = this.innerExcuteFilterParam(runtimeParams, oneRowMap);
                    if (innerFilterRowMap == null || !CollectionUtils.isNotEmpty(rowDataList = (columnToRowdataHandler = new ColumnToRowDataHandler()).columnToRow(oneRowMap, runtimeEntity))) continue;
                    for (Map<String, Object> rowMap : rowDataList) {
                        Map<String, Object> calculatedRowData = RESTfulDataSetSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                        if (calculatedRowData == null) continue;
                        data.add(RESTfulDataSetSourceDomain.getOutputData(calculatedRowData, runtimeEntity, true));
                        if (data.size() != rows) continue;
                        continue block3;
                    }
                }
                ++pageNumber;
            }
        }
        catch (Exception e) {
            throw new OpenAPIException(2061202, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        return new PreviewDataModel(data);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws OpenAPIException, DBKSQLTranslateException, DataSourcePersistenceException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Long getRowCount(RuntimeEntity runtimeEntity, RESTfulURLModel restfulURLModel, QingContext qingContext) throws OpenAPIException {
        String rowCountUrl = restfulURLModel.getRowCountURL(runtimeEntity);
        Map<String, String> headsMap = this.getRequestHead(runtimeEntity.getSource(), rowCountUrl);
        String resultJsonStr = RESTfulHttp.post(qingContext, rowCountUrl, headsMap, null, true);
        return RESTfulHttpResultParseTool.getRowCount(resultJsonStr);
    }

    private Map<String, String> getRequestHead(AbstractSource source, String realUrl) throws OpenAPIException {
        Map headsMap = null;
        OpenAPISource openAPISource = (OpenAPISource)source;
        AbstractAuthModel authModel = openAPISource.getAuthModel();
        if (authModel != null) {
            headsMap = authModel.createRequestHeads(realUrl);
        }
        return headsMap;
    }
}

