/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api.parser;

import com.kingdee.bos.qing.data.domain.source.api.parser.RESTfulHttpResultParseTool;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.RESTfulURLModel;
import com.kingdee.bos.qing.data.model.runtime.api.restful.EntityStructure;
import com.kingdee.bos.qing.data.model.runtime.api.restful.RESTfulEntity;
import com.kingdee.bos.qing.data.model.runtime.api.restful.RESTfulNode;
import com.kingdee.bos.qing.data.model.runtime.api.restful.RESTfulProperty;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RESTfulResultParseTool {
    public static AbstractNode getUsableEntities(String resultJsonStr, RESTfulURLModel restfulURLModel) throws OpenAPIException {
        List<RESTfulNode> restfulEntityList = RESTfulHttpResultParseTool.getUsableEntities(resultJsonStr);
        FolderNode root = new FolderNode();
        for (RESTfulNode restfulEntity : restfulEntityList) {
            LeafNode leafNode = new LeafNode();
            leafNode.setName(restfulEntity.getName());
            leafNode.setDisplayName(restfulEntity.getAlias());
            leafNode.setCommentInfo(restfulEntity.getAlias());
            leafNode.setType("table");
            root.addChild((AbstractNode)leafNode);
        }
        if (StringUtils.isBlank((CharSequence)restfulURLModel.getResourcePath())) {
            return root;
        }
        return RESTfulResultParseTool.isNotRootPathGetUsableEntities(restfulURLModel, root);
    }

    private static AbstractNode isNotRootPathGetUsableEntities(RESTfulURLModel restfulURLModel, FolderNode root) {
        String entityName = restfulURLModel.getResourcePath();
        LeafNode leafNode = new LeafNode();
        for (AbstractNode node : root.getChildren()) {
            if (!node.getName().equals(entityName)) continue;
            leafNode.setName(entityName);
            leafNode.setDisplayName(node.getDisplayName());
            leafNode.setCommentInfo(node.getDisplayName());
            leafNode.setType("table");
            break;
        }
        root.setChildren(null);
        root.addChild((AbstractNode)leafNode);
        return root;
    }

    public static DesigntimeDataObject getDesigntimeDataObject(String dbName, String resultJsonStr, String associateName) throws OpenAPIException {
        EntityStructure entityStructure = RESTfulHttpResultParseTool.getDesigntimeDataObject(resultJsonStr);
        ArrayList<Entity> entities = new ArrayList<Entity>(entityStructure.getEntities().size());
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (RESTfulEntity resTfulEntity : entityStructure.getEntities()) {
            Entity entity = new Entity();
            entity.setSource(dbName);
            entity.setUnionUnit(false);
            entity.setName(resTfulEntity.getName());
            entity.setAlias(resTfulEntity.getAlias());
            entity.setCommentInfo(resTfulEntity.getAlias());
            entity.setAssociateName(resTfulEntity.getName());
            ArrayList<Property> properties = new ArrayList<Property>(resTfulEntity.getProperties().size());
            int j = 0;
            for (RESTfulProperty resTfulProperty : resTfulEntity.getProperties()) {
                Property property = new Property();
                String name = resTfulProperty.getName();
                String alias = resTfulProperty.getAlias();
                name = nameMap.containsKey(name) ? name + "_" + j : name;
                alias = aliasMap.containsKey(alias) ? alias + "_" + j : alias;
                property.setName(name);
                property.setAlias(alias);
                property.setCommentInfo(name);
                property.setDataType(resTfulProperty.getDataType());
                property.setAppointedDataType(resTfulProperty.getDataType());
                property.setAssociateName(name);
                property.setHide(false);
                property.setRelatedBaseProperty("");
                properties.add(property);
                nameMap.put(name, name);
                aliasMap.put(alias, alias);
            }
            entity.setProperties(properties);
            entities.add(entity);
        }
        DesigntimeDataObject designtimeDataObject = new DesigntimeDataObject();
        designtimeDataObject.setName(associateName);
        designtimeDataObject.setEntities(entities);
        return designtimeDataObject;
    }
}

