/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import org.xml.sax.SAXException;

public class MergeCellRange {
    private int firstRow;
    private int firstCol;
    private int lastRow;
    private int lastCol;
    private transient CellInfo cellInfo;

    public MergeCellRange(int firstRow, int lastRow, int firstCol, int lastCol) {
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstCol = firstCol;
        this.lastCol = lastCol;
    }

    public CellInfo getCellInfo() {
        return this.cellInfo;
    }

    public void setCellInfo(CellInfo cellInfo) {
        this.cellInfo = cellInfo;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public static MergeCellRange parse(String mergeRef) throws SAXException {
        try {
            String[] index = mergeRef.split(":");
            String firstCol = index[0].replaceAll("[^(A-Za-z)]", "");
            String firstRow = index[0].substring(index[0].indexOf(firstCol) + firstCol.length());
            String lastCol = index[1].replaceAll("[^(A-Za-z)]", "");
            String lastRow = index[1].substring(index[1].indexOf(lastCol) + lastCol.length());
            int intFirstCol = MergeCellRange.excelColStrToNum(firstCol, firstCol.length());
            int intLastCol = MergeCellRange.excelColStrToNum(lastCol, lastCol.length());
            int intFirstRow = Integer.parseInt(firstRow);
            int intLastRow = Integer.parseInt(lastRow);
            return new MergeCellRange(intFirstRow, intLastRow, intFirstCol, intLastCol);
        }
        catch (Exception e) {
            String msg = Messages.getMLS((String)"cellError", (String)"\u5408\u5e76\u5355\u5143\u683c#1\u5b58\u5728\u95ee\u9898", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            throw new SAXException(msg.replace("#1", mergeRef), e);
        }
    }

    private static int excelColStrToNum(String colStr, int length) {
        int num = 0;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            char ch = colStr.charAt(length - i - 1);
            num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }
}

