/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers;

import com.kingdee.bos.qing.data.domain.source.file.excel07.Excel07SaxReaderContext;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellFactory;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.EmptyCellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.MergeCellRange;
import com.kingdee.bos.qing.data.domain.source.file.excel07.elemenhandlers.ElementHandlerAdapter;
import org.xml.sax.Attributes;

public class CElementHandler
extends ElementHandlerAdapter {
    @Override
    public void handleStart(Attributes attributes, Excel07SaxReaderContext context) {
        CellDataType cellDataType = CellDataType.of(attributes.getValue("t"));
        CellInfo cellInfo = CellFactory.createCellInfo(cellDataType, attributes, context);
        context.setCurrentCell(cellInfo);
    }

    private void fillBlankCell(Excel07SaxReaderContext context) {
        CellInfo currentCell = context.getCurrentCell();
        int length = context.getColSize();
        int preColIndex = length == 0 ? 0 : context.getCell(length - 1).getCol();
        for (int index = preColIndex + 1; index <= currentCell.getCol() - 1; ++index) {
            EmptyCellInfo emptyCellInfo = new EmptyCellInfo();
            emptyCellInfo.setLocation(currentCell.getRow(), index);
            context.addNewCell(emptyCellInfo);
        }
    }

    @Override
    public void handleEnd(Excel07SaxReaderContext context) {
        CellInfo cell = context.getCurrentCell();
        MergeCellRange cellRange = context.getMergeCellRange(cell.getRow(), cell.getCol());
        if (null == cellRange) {
            this.fillBlankCell(context);
            cell.initRawValue(context.getSharedStringsTable());
            context.addNewCell(cell);
            return;
        }
        if (cellRange.getFirstCol() == cell.getCol()) {
            this.fillBlankCell(context);
        }
        this.processMergeCell(context, cell, cellRange);
    }

    private void processMergeCell(Excel07SaxReaderContext context, CellInfo cell, MergeCellRange cellRange) {
        if (this.isFirstMergeCell(cellRange, cell)) {
            cell.initRawValue(context.getSharedStringsTable());
            cellRange.setCellInfo(cell);
            context.addNewCell(cell);
            return;
        }
        CellInfo copyMergeCellInfo = cellRange.getCellInfo().createCopy(false);
        copyMergeCellInfo.setLocation(cell.getRow(), cell.getCol());
        context.setCurrentCell(copyMergeCellInfo);
        context.addNewCell(copyMergeCellInfo);
    }

    private boolean isFirstMergeCell(MergeCellRange cellRange, CellInfo cell) {
        return cellRange.getFirstCol() == cell.getCol() && cellRange.getFirstRow() == cell.getRow();
    }

    @Override
    public String getElementFlag() {
        return "c";
    }
}

