/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.RowContentHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.file.sax.DataSourceExceptionSAXException;
import com.kingdee.bos.qing.data.exception.file.sax.InterruptedSAXException;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class FullExtractRowContentHandler
extends RowContentHandler {
    private ProgressProcessor progressProcessor;

    public FullExtractRowContentHandler(RunningTimeParams runningTimeParams, ProgressProcessor progressProcessor, Map<Integer, String> colIndexAndNameMap) {
        super(runningTimeParams, colIndexAndNameMap);
        this.progressProcessor = progressProcessor;
    }

    @Override
    public void handle(int rowNum, List<CellInfo> cellInfos) throws SAXException {
        if (rowNum == 1) {
            return;
        }
        try {
            ServerRequestInvokeContext.staticCheckInterrupt();
        }
        catch (InterruptedException e) {
            throw new InterruptedSAXException(e);
        }
        List<Object[]> convertedDataList = this.convertAndFilter(rowNum - 1, cellInfos);
        if (CollectionUtils.isNotEmpty(convertedDataList)) {
            for (Object[] convertedDatas : convertedDataList) {
                if (null == convertedDatas) continue;
                if (this.progressProcessor != null) {
                    this.dealWithProgress(convertedDatas);
                    continue;
                }
                this.writeToFile(convertedDatas);
            }
        }
    }

    private void dealWithProgress(Object[] convertedDatas) throws SAXException {
        this.progressProcessor.dealOneRow();
        if (this.progressProcessor.isDataLimit()) {
            throw new InterruptedSAXException();
        }
        this.writeToFile(convertedDatas);
        this.progressProcessor.writeOneRow();
    }

    private void writeToFile(Object[] convertedDatas) throws SAXException {
        try {
            this.runningTimeParams.getDataSourceWriter().writeData(convertedDatas);
        }
        catch (DataSourcePersistenceException e) {
            throw new DataSourceExceptionSAXException(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedSAXException(e);
        }
    }
}

