/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.RowContentHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.file.sax.InterruptedSAXException;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class PreviewRowContentHandler
extends RowContentHandler {
    public PreviewRowContentHandler(RunningTimeParams runningTimeParams, Map<Integer, String> colIndexAndNameMap) {
        super(runningTimeParams, colIndexAndNameMap);
    }

    @Override
    public void handle(int rowNum, List<CellInfo> cellInfos) throws SAXException {
        int previewSize = this.getHandleResult().getPreviewResult().size();
        if (this.runningTimeParams.getTopN() == previewSize) {
            throw new InterruptedSAXException();
        }
        if (rowNum == 1) {
            return;
        }
        List<Object[]> convertedDataList = this.convertAndFilter(rowNum - 1, cellInfos);
        if (CollectionUtils.isNotEmpty(convertedDataList)) {
            for (Object[] convertedDatas : convertedDataList) {
                if (this.runningTimeParams.getTopN() == previewSize) {
                    throw new InterruptedSAXException();
                }
                if (null == convertedDatas) continue;
                this.getHandleResult().addPreviewResult(convertedDatas);
            }
        }
    }
}

