/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler;

import com.kingdee.bos.qing.data.domain.handler.impl.ColumnToRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.IRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RowContentHandler
implements IRowDataHandler<ResultContent> {
    protected RunningTimeParams runningTimeParams;
    protected RuntimeEntity runtimeEntity;
    protected QSDataSourceWriter dataSourcePersistentWriter;
    protected Map<Integer, String> colIndexAndNameMap = new HashMap<Integer, String>();
    private ResultContent resultContent = new ResultContent();

    public RowContentHandler(RunningTimeParams runningTimeParams, Map<Integer, String> colIndexAndNameMap) {
        this.runningTimeParams = runningTimeParams;
        this.colIndexAndNameMap = colIndexAndNameMap;
        this.runtimeEntity = runningTimeParams.getRuntimeEntity();
        if (this.runtimeEntity != null) {
            this.dataSourcePersistentWriter = this.runtimeEntity.getDataSourcePersistentWriter();
        }
    }

    protected List<Object[]> convertAndFilter(int thisRow, List<CellInfo> cellInfos) {
        List<Map<String, Object>> filterRowList = this.doFilter(thisRow, cellInfos);
        if (CollectionUtils.isNotEmpty(filterRowList)) {
            ArrayList<Object[]> resultList = new ArrayList<Object[]>();
            for (Map<String, Object> filterRow : filterRowList) {
                if (null == filterRow || filterRow.size() <= 0) continue;
                resultList.add(AbstractDataSourceDomain.getOutputData(filterRow, this.runningTimeParams.getRuntimeEntity(), this.runningTimeParams.isPreview()));
            }
            return resultList;
        }
        return null;
    }

    private List<Map<String, Object>> doFilter(int rowNum, List<CellInfo> cellInfos) {
        Map<String, Object> rowDatas = this.convertToInputDataType(rowNum, cellInfos);
        if (this.dataSourcePersistentWriter != null && null != rowDatas && rowDatas.size() > 0) {
            Object[] outputData = AbstractDataSourceDomain.getOutputData(rowDatas, this.runningTimeParams.getSourceRuntimeEntity(), this.runningTimeParams.isPreview());
            try {
                this.dataSourcePersistentWriter.writeData(outputData);
            }
            catch (DataSourcePersistenceException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
                this.dataSourcePersistentWriter.close((Exception)((Object)e));
                this.dataSourcePersistentWriter = null;
                this.runtimeEntity.setDataSourcePersistentWriter(null);
            }
            catch (InterruptedException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
                this.dataSourcePersistentWriter.close((Exception)e);
                this.dataSourcePersistentWriter = null;
                this.runtimeEntity.setDataSourcePersistentWriter(null);
            }
        }
        ColumnToRowDataHandler dataHandler = new ColumnToRowDataHandler();
        List<Map<String, Object>> rowDataList = dataHandler.columnToRow(rowDatas, this.runtimeEntity);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(rowDataList)) {
            for (Map<String, Object> rowDataMap : rowDataList) {
                IRuntimeFilter runtimeFiler = this.runningTimeParams.getRuntimeFilter();
                if ((runtimeFiler == null || !runtimeFiler.innerExcuteFilterWtihRawValue(rowDataMap)) && runtimeFiler != null) continue;
                resultList.add(this.runningTimeParams.getFileSourceDomain().filterCalculateColumn(rowDataMap, this.runningTimeParams.getRuntimeEntity()));
            }
        }
        return resultList;
    }

    private Map<String, Object> convertToInputDataType(int rowNum, List<CellInfo> cellInfos) {
        RuntimeEntity runtimeEntity = this.runningTimeParams.getRuntimeEntity();
        Map<String, RuntimeProperty> selectedPriAssociatePropertyMap = runtimeEntity.getSelectedPriAssociatePropertyMap();
        HashMap<String, Object> rowDatas = new HashMap<String, Object>();
        for (CellInfo cellInfo : cellInfos) {
            int col = cellInfo.getCol();
            String associateColName = this.colIndexAndNameMap.get(col);
            RuntimeProperty rp = selectedPriAssociatePropertyMap.get(associateColName);
            if (null == rp) continue;
            rowDatas.put(rp.getName(), this.getCellValue(cellInfo, rp));
        }
        return rowDatas;
    }

    private Object getCellValue(CellInfo cellInfo, RuntimeProperty rp) {
        try {
            return cellInfo.getCellValue(rp.getInputDataType());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public ResultContent getHandleResult() {
        return this.resultContent;
    }
}

